/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserIORequest;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTable;
import org.gjt.sp.jedit.browser.VFSDirectoryEntryTableModel;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;

class BrowserView
extends JPanel {
    private VFSBrowser browser;
    private JSplitPane splitPane;
    private JList parentDirectories;
    private VFSDirectoryEntryTable table;
    private Set tmpExpanded;
    private BrowserCommandsMenu popup;
    private boolean showIcons;

    public BrowserView(final VFSBrowser browser) {
        this.browser = browser;
        this.tmpExpanded = new HashSet();
        this.parentDirectories = new JList();
        this.parentDirectories.getSelectionModel().setSelectionMode(0);
        this.parentDirectories.setCellRenderer(new ParentDirectoryRenderer());
        this.parentDirectories.setVisibleRowCount(5);
        this.parentDirectories.addMouseListener(new ParentMouseHandler());
        final JScrollPane parentScroller = new JScrollPane(this.parentDirectories);
        parentScroller.setMinimumSize(new Dimension(0, 0));
        this.table = new VFSDirectoryEntryTable(this);
        this.table.addMouseListener(new TableMouseHandler());
        JScrollPane tableScroller = new JScrollPane(this.table);
        tableScroller.setMinimumSize(new Dimension(0, 0));
        tableScroller.getViewport().setBackground(this.table.getBackground());
        tableScroller.getViewport().addMouseListener(new TableMouseHandler());
        this.splitPane = new JSplitPane(browser.isHorizontalLayout() ? 1 : 0, parentScroller, tableScroller);
        this.splitPane.setOneTouchExpandable(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String prop = browser.isHorizontalLayout() ? "vfs.browser.horizontalSplitter" : "vfs.browser.splitter";
                int loc = jEdit.getIntegerProperty(prop, -1);
                if (loc == -1) {
                    loc = parentScroller.getPreferredSize().height;
                }
                BrowserView.this.splitPane.setDividerLocation(loc);
                BrowserView.this.parentDirectories.ensureIndexIsVisible(BrowserView.this.parentDirectories.getModel().getSize());
            }
        });
        if (browser.isMultipleSelectionEnabled()) {
            this.table.getSelectionModel().setSelectionMode(2);
        } else {
            this.table.getSelectionModel().setSelectionMode(0);
        }
        this.setLayout(new BorderLayout());
        this.add("Center", this.splitPane);
        this.propertiesChanged();
    }

    public void focusOnFileView() {
        this.table.requestFocus();
    }

    public void removeNotify() {
        String prop = this.browser.isHorizontalLayout() ? "vfs.browser.horizontalSplitter" : "vfs.browser.splitter";
        jEdit.setIntegerProperty(prop, this.splitPane.getDividerLocation());
        super.removeNotify();
    }

    public VFS.DirectoryEntry[] getSelectedFiles() {
        return this.table.getSelectedFiles();
    }

    public void selectNone() {
        this.table.clearSelection();
    }

    public void saveExpansionState() {
        this.tmpExpanded.clear();
        this.table.getExpandedDirectories(this.tmpExpanded);
    }

    public void clearExpansionState() {
        this.tmpExpanded.clear();
    }

    public void loadDirectory(Object node, String path) {
        path = MiscUtilities.constructPath(this.browser.getDirectory(), path);
        VFS vfs = VFSManager.getVFSForPath(path);
        Object session = vfs.createVFSSession(path, this);
        if (session == null) {
            return;
        }
        if (node == null) {
            this.parentDirectories.setListData(new Object[]{new LoadingPlaceholder()});
        }
        Object[] loadInfo = new Object[2];
        VFSManager.runInWorkThread(new BrowserIORequest(0, this.browser, session, vfs, path, null, loadInfo));
        this.browser.directoryLoaded(node, loadInfo);
    }

    public void directoryLoaded(Object node, String path, ArrayList directory) {
        if (node == null) {
            DefaultListModel<VFS.DirectoryEntry> parentList = new DefaultListModel<VFS.DirectoryEntry>();
            String parent = path;
            while (true) {
                VFS _vfs = VFSManager.getVFSForPath(parent);
                parentList.insertElementAt(new VFS.DirectoryEntry(_vfs.getFileName(parent), parent, parent, 1, 0L, false), 0);
                String newParent = _vfs.getParentOfPath(parent);
                if (newParent == null || VFSBrowser.pathsEqual(parent, newParent)) break;
                parent = newParent;
            }
            this.parentDirectories.setModel(parentList);
            int index = parentList.getSize() - 1;
            this.parentDirectories.setSelectedIndex(index);
            this.parentDirectories.ensureIndexIsVisible(index);
        }
        this.table.setDirectory(VFSManager.getVFSForPath(path), node, directory, this.tmpExpanded);
    }

    public void updateFileView() {
        this.table.repaint();
    }

    public void maybeReloadDirectory(String path) {
        String browserDir = this.browser.getDirectory();
        String symlinkBrowserDir = MiscUtilities.isURL(browserDir) ? browserDir : MiscUtilities.resolveSymlinks(browserDir);
        if (VFSBrowser.pathsEqual(path, symlinkBrowserDir)) {
            this.saveExpansionState();
            this.loadDirectory(null, browserDir);
        }
        if (!(browserDir.startsWith("favorites") || browserDir.startsWith("roots") || path.startsWith(symlinkBrowserDir))) {
            return;
        }
        if (browserDir.startsWith("roots") && MiscUtilities.isURL(path) && !MiscUtilities.getProtocolOfURL(path).equals("file")) {
            return;
        }
        this.table.maybeReloadDirectory(path);
    }

    public void propertiesChanged() {
        this.showIcons = jEdit.getBooleanProperty("vfs.browser.showIcons");
        this.table.propertiesChanged();
        this.splitPane.setBorder(null);
    }

    public VFSBrowser getBrowser() {
        return this.browser;
    }

    public VFSDirectoryEntryTable getTable() {
        return this.table;
    }

    public JList getParentDirectoryList() {
        return this.parentDirectories;
    }

    private void showFilePopup(VFS.DirectoryEntry[] files, Component comp, Point point) {
        this.popup = new BrowserCommandsMenu(this.browser, files);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        int index = BrowserView.access$100(2.access$200(this.this$1)).getModel().getSize() - 1;
                        BrowserView.access$100(2.access$200(this.this$1)).setSelectedIndex(index);
                    }
                });
            }

            static /* synthetic */ BrowserView access$200(2 x0) {
                return x0.BrowserView.this;
            }
        });
        GUIUtilities.showPopupMenu(this.popup, comp, point.x, point.y);
    }

    static class LoadingPlaceholder {
        LoadingPlaceholder() {
        }
    }

    class TableMouseHandler
    extends MouseAdapter {
        TableMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            Point p = evt.getPoint();
            int row = BrowserView.this.table.rowAtPoint(p);
            int column = BrowserView.this.table.columnAtPoint(p);
            if (row == -1) {
                return;
            }
            if (column == 0) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(row, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, p.x)) {
                    return;
                }
            }
            if ((evt.getModifiers() & 0x10) != 0 && evt.getClickCount() % 2 == 0) {
                BrowserView.this.browser.filesActivated(evt.isShiftDown() ? 1 : 0, true);
            } else if (GUIUtilities.isMiddleButton(evt.getModifiers())) {
                if (evt.isShiftDown()) {
                    BrowserView.this.table.getSelectionModel().addSelectionInterval(row, row);
                } else {
                    BrowserView.this.table.getSelectionModel().setSelectionInterval(row, row);
                }
                BrowserView.this.browser.filesActivated(evt.isShiftDown() ? 1 : 0, true);
            }
        }

        public void mousePressed(MouseEvent evt) {
            Point p = evt.getPoint();
            if (evt.getSource() != BrowserView.this.table) {
                p.x -= BrowserView.this.table.getX();
                p.y -= BrowserView.this.table.getY();
            }
            int row = BrowserView.this.table.rowAtPoint(p);
            int column = BrowserView.this.table.columnAtPoint(p);
            if (column == 0 && row != -1) {
                VFSDirectoryEntryTableModel.Entry entry = (VFSDirectoryEntryTableModel.Entry)BrowserView.this.table.getModel().getValueAt(row, 0);
                if (FileCellRenderer.ExpansionToggleBorder.isExpansionToggle(entry.level, p.x)) {
                    BrowserView.this.table.toggleExpanded(row);
                    return;
                }
            }
            if (GUIUtilities.isMiddleButton(evt.getModifiers())) {
                if (row != -1) {
                    if (evt.isShiftDown()) {
                        BrowserView.this.table.getSelectionModel().addSelectionInterval(row, row);
                    } else {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            } else if (GUIUtilities.isPopupTrigger(evt)) {
                if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                    BrowserView.this.popup.setVisible(false);
                    BrowserView.this.popup = null;
                    return;
                }
                if (row == -1) {
                    BrowserView.this.showFilePopup(null, BrowserView.this.table, evt.getPoint());
                } else {
                    if (!BrowserView.this.table.getSelectionModel().isSelectedIndex(row)) {
                        BrowserView.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                    BrowserView.this.showFilePopup(BrowserView.this.getSelectedFiles(), BrowserView.this.table, evt.getPoint());
                }
            }
        }

        public void mouseReleased(MouseEvent evt) {
            if (!GUIUtilities.isPopupTrigger(evt) && BrowserView.this.table.getSelectedRow() != -1) {
                BrowserView.this.browser.filesSelected();
            }
        }
    }

    class ParentMouseHandler
    extends MouseAdapter {
        ParentMouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            Object obj;
            int row = BrowserView.this.parentDirectories.locationToIndex(evt.getPoint());
            if (row != -1 && (obj = BrowserView.this.parentDirectories.getModel().getElementAt(row)) instanceof VFS.DirectoryEntry) {
                VFS.DirectoryEntry dirEntry = (VFS.DirectoryEntry)obj;
                if (GUIUtilities.isPopupTrigger(evt)) {
                    if (BrowserView.this.popup != null && BrowserView.this.popup.isVisible()) {
                        BrowserView.this.popup.setVisible(false);
                        BrowserView.this.popup = null;
                    } else {
                        BrowserView.this.parentDirectories.setSelectedIndex(row);
                        BrowserView.this.showFilePopup(new VFS.DirectoryEntry[]{dirEntry}, BrowserView.this.parentDirectories, evt.getPoint());
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent evt) {
            Object obj;
            if (evt.getClickCount() % 2 != 0 && !GUIUtilities.isMiddleButton(evt.getModifiers())) {
                return;
            }
            int row = BrowserView.this.parentDirectories.locationToIndex(evt.getPoint());
            if (row != -1 && (obj = BrowserView.this.parentDirectories.getModel().getElementAt(row)) instanceof VFS.DirectoryEntry) {
                VFS.DirectoryEntry dirEntry = (VFS.DirectoryEntry)obj;
                if (!GUIUtilities.isPopupTrigger(evt)) {
                    BrowserView.this.browser.setDirectory(dirEntry.path);
                    if (BrowserView.this.browser.getMode() == 2) {
                        BrowserView.this.focusOnFileView();
                    }
                }
            }
        }
    }

    class ParentDirectoryRenderer
    extends DefaultListCellRenderer {
        Font plainFont = UIManager.getFont("Tree.font");
        Font boldFont;

        ParentDirectoryRenderer() {
            if (this.plainFont == null) {
                this.plainFont = jEdit.getFontProperty("metal.secondary.font");
            }
            this.boldFont = new Font(this.plainFont.getName(), 1, this.plainFont.getSize());
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.setBorder(new EmptyBorder(1, index * 5 + 1, 1, 1));
            if (value instanceof LoadingPlaceholder) {
                this.setFont(this.plainFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.loadingIcon : null);
                this.setText(jEdit.getProperty("vfs.browser.tree.loading"));
            } else if (value instanceof VFS.DirectoryEntry) {
                VFS.DirectoryEntry dirEntry = (VFS.DirectoryEntry)value;
                this.setFont(this.boldFont);
                this.setIcon(BrowserView.this.showIcons ? FileCellRenderer.getIconForFile(dirEntry, true) : null);
                this.setText(dirEntry.name);
            } else if (value == null) {
                this.setText("VFS does not follow VFS API");
            }
            return this;
        }
    }
}

