/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.browser;

import bsh.NameSpace;
import bsh.UtilEvalError;
import gnu.regexp.RE;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.EventListenerList;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.BrowserCommandsMenu;
import org.gjt.sp.jedit.browser.BrowserIORequest;
import org.gjt.sp.jedit.browser.BrowserListener;
import org.gjt.sp.jedit.browser.BrowserView;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.gui.DefaultFocusComponent;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.VFSUpdate;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.util.Log;

public class VFSBrowser
extends JPanel
implements EBComponent,
DefaultFocusComponent {
    public static final String NAME = "vfs.browser";
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int BROWSER_DIALOG = 4;
    public static final int CHOOSE_DIRECTORY_DIALOG = 3;
    public static final int BROWSER = 2;
    public static final int M_OPEN = 0;
    public static final int M_OPEN_NEW_VIEW = 1;
    public static final int M_OPEN_NEW_PLAIN_VIEW = 2;
    public static final int M_OPEN_NEW_SPLIT = 3;
    public static final int M_INSERT = 4;
    String currentEncoding;
    boolean autoDetectEncoding;
    private static ActionContext actionContext = new BrowserActionContext();
    private EventListenerList listenerList = new EventListenerList();
    private View view;
    private boolean horizontalLayout;
    private String path;
    private HistoryTextField pathField;
    private JCheckBox filterCheckbox;
    private HistoryTextField filterField;
    private Box toolbarBox;
    private FavoritesMenuButton favorites;
    private PluginsMenuButton plugins;
    private BrowserView browserView;
    private RE filenameFilter;
    private int mode;
    private boolean multipleSelection;
    private boolean showHiddenFiles;
    private boolean sortMixFilesAndDirs;
    private boolean sortIgnoreCase;
    private boolean doubleClickClose;
    private boolean requestRunning;
    private boolean maybeReloadRequestRunning;
    static /* synthetic */ Class class$org$gjt$sp$jedit$browser$BrowserListener;
    static /* synthetic */ Class class$org$gjt$sp$jedit$jEdit;
    static /* synthetic */ Class class$javax$swing$JList;
    static /* synthetic */ Class class$org$gjt$sp$jedit$browser$VFSBrowser;

    public static void browseDirectoryInNewWindow(View view, String path) {
        DockableWindowManager wm = view.getDockableWindowManager();
        if (path != null) {
            jEdit.setTemporaryProperty("vfs.browser.path.tmp", path);
        }
        wm.floatDockableWindow(NAME);
        jEdit.unsetProperty("vfs.browser.path.tmp");
    }

    public static void browseDirectory(View view, String path) {
        DockableWindowManager wm = view.getDockableWindowManager();
        VFSBrowser browser = (VFSBrowser)wm.getDockable(NAME);
        if (browser != null) {
            wm.showDockableWindow(NAME);
            browser.setDirectory(path);
        } else {
            if (path != null) {
                jEdit.setTemporaryProperty("vfs.browser.path.tmp", path);
            }
            wm.addDockableWindow(NAME);
            jEdit.unsetProperty("vfs.browser.path.tmp");
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public VFSBrowser(View view, String position) {
        this(view, null, 2, true, position);
    }

    public VFSBrowser(View view, String path, int mode, boolean multipleSelection, String position) {
        super(new BorderLayout());
        String filter;
        this.mode = mode;
        this.multipleSelection = multipleSelection;
        this.view = view;
        this.currentEncoding = jEdit.getProperty("buffer.encoding", System.getProperty("file.encoding"));
        this.autoDetectEncoding = jEdit.getBooleanProperty("buffer.encodingAutodetect");
        ActionHandler actionHandler = new ActionHandler();
        Box topBox = new Box(1);
        this.horizontalLayout = mode != 2 || "top".equals(position) || "bottom".equals(position);
        this.toolbarBox = new Box(this.horizontalLayout ? 0 : 1);
        topBox.add(this.toolbarBox);
        GridBagLayout layout = new GridBagLayout();
        JPanel pathAndFilterPanel = new JPanel(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridy = 0;
        cons.gridx = 0;
        cons.fill = 1;
        cons.anchor = 13;
        JLabel label = new JLabel(jEdit.getProperty("vfs.browser.path"), 4);
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        layout.setConstraints(label, cons);
        pathAndFilterPanel.add(label);
        this.pathField = new HistoryTextField("vfs.browser.path");
        this.pathField.setInstantPopups(true);
        this.pathField.setEnterAddsToHistory(false);
        this.pathField.setSelectAllOnFocus(true);
        Dimension prefSize = this.pathField.getPreferredSize();
        prefSize.width = 0;
        this.pathField.setPreferredSize(prefSize);
        this.pathField.addActionListener(actionHandler);
        cons.gridx = 1;
        cons.weightx = 1.0;
        layout.setConstraints(this.pathField, cons);
        pathAndFilterPanel.add(this.pathField);
        this.filterCheckbox = new JCheckBox(jEdit.getProperty("vfs.browser.filter"));
        this.filterCheckbox.setMargin(new Insets(0, 0, 0, 0));
        this.filterCheckbox.setRequestFocusEnabled(false);
        this.filterCheckbox.setBorder(new EmptyBorder(0, 0, 0, 12));
        this.filterCheckbox.setSelected(jEdit.getBooleanProperty("vfs.browser.filter-enabled"));
        this.filterCheckbox.addActionListener(actionHandler);
        if (mode != 3) {
            cons.gridx = 0;
            cons.weightx = 0.0;
            cons.gridy = 1;
            layout.setConstraints(this.filterCheckbox, cons);
            pathAndFilterPanel.add(this.filterCheckbox);
        }
        this.filterField = new HistoryTextField("vfs.browser.filter");
        this.filterField.setInstantPopups(true);
        this.filterField.setSelectAllOnFocus(true);
        this.filterField.addActionListener(actionHandler);
        if (mode != 3) {
            cons.gridx = 1;
            cons.weightx = 1.0;
            layout.setConstraints(this.filterField, cons);
            pathAndFilterPanel.add(this.filterField);
        }
        topBox.add(pathAndFilterPanel);
        this.add("North", topBox);
        this.browserView = new BrowserView(this);
        this.add("Center", this.browserView);
        this.propertiesChanged();
        if (mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            filter = jEdit.getProperty("vfs.browser.last-filter");
            if (filter == null) {
                filter = jEdit.getProperty("vfs.browser.default-filter");
            }
        } else {
            String ext = MiscUtilities.getFileExtension(view.getBuffer().getName());
            filter = ext.length() == 0 ? jEdit.getProperty("vfs.browser.default-filter") : "*" + ext;
        }
        this.filterField.setText(filter);
        this.filterField.addCurrentToHistory();
        this.updateFilterEnabled();
        if (path == null) {
            path = jEdit.getProperty("vfs.browser.path.tmp");
        }
        if (path == null || path.length() == 0) {
            String userHome = System.getProperty("user.home");
            String defaultPath = jEdit.getProperty("vfs.browser.defaultPath");
            if (defaultPath.equals("home")) {
                path = userHome;
            } else if (defaultPath.equals("working")) {
                path = System.getProperty("user.dir");
            } else if (defaultPath.equals("buffer")) {
                if (view != null) {
                    Buffer buffer = view.getBuffer();
                    path = buffer.getDirectory();
                } else {
                    path = userHome;
                }
            } else {
                HistoryModel pathModel;
                path = defaultPath.equals("last") ? ((pathModel = HistoryModel.getModel("vfs.browser.path")).getSize() == 0 ? "~" : pathModel.getItem(0)) : (defaultPath.equals("favorites") ? "favorites:" : userHome);
            }
        }
        final String _path = path;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                VFSBrowser.this.setDirectory(_path);
            }
        });
    }

    public void focusOnDefaultComponent() {
        this.browserView.focusOnFileView();
    }

    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    public void removeNotify() {
        super.removeNotify();
        jEdit.setBooleanProperty("vfs.browser.filter-enabled", this.filterCheckbox.isSelected());
        if (this.mode == 2 || !jEdit.getBooleanProperty("vfs.browser.currentBufferFilter")) {
            jEdit.setProperty("vfs.browser.last-filter", this.filterField.getText());
        }
        EditBus.removeFromBus(this);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof PropertiesChanged) {
            this.propertiesChanged();
        } else if (msg instanceof BufferUpdate) {
            BufferUpdate bmsg = (BufferUpdate)msg;
            if (bmsg.getWhat() == BufferUpdate.CREATED || bmsg.getWhat() == BufferUpdate.CLOSED) {
                this.browserView.updateFileView();
            }
        } else if (msg instanceof PluginUpdate) {
            PluginUpdate pmsg = (PluginUpdate)msg;
            if (pmsg.getWhat() == PluginUpdate.LOADED || pmsg.getWhat() == PluginUpdate.UNLOADED) {
                this.plugins.updatePopupMenu();
            }
        } else if (msg instanceof VFSUpdate) {
            this.maybeReloadDirectory(((VFSUpdate)msg).getPath());
        }
    }

    public View getView() {
        return this.view;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isMultipleSelectionEnabled() {
        return this.multipleSelection;
    }

    public boolean isHorizontalLayout() {
        return this.horizontalLayout;
    }

    public boolean getShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
    }

    public String getFilenameFilter() {
        if (this.filterCheckbox.isSelected()) {
            String filter = this.filterField.getText();
            if (filter.length() == 0) {
                return "*";
            }
            return filter;
        }
        return "*";
    }

    public void setFilenameFilter(String filter) {
        if (filter == null || filter.length() == 0 || filter.equals("*")) {
            this.filterCheckbox.setSelected(false);
        } else {
            this.filterCheckbox.setSelected(true);
            this.filterField.setText(filter);
        }
    }

    public HistoryTextField getDirectoryField() {
        return this.pathField;
    }

    public String getDirectory() {
        return this.path;
    }

    public void setDirectory(String path) {
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        this.pathField.setText(path);
        if (!this.startRequest()) {
            return;
        }
        this.updateFilenameFilter();
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, path);
        this.path = path;
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void rootDirectory() {
        if (OperatingSystem.isMacOS() || OperatingSystem.isDOSDerived()) {
            this.setDirectory("roots:");
        } else {
            this.setDirectory("/");
        }
    }

    public void reloadDirectory() {
        VFSManager.getVFSForPath(this.path).reloadDirectory(this.path);
        this.updateFilenameFilter();
        this.browserView.saveExpansionState();
        this.browserView.loadDirectory(null, this.path);
    }

    public void delete(VFS.DirectoryEntry[] files) {
        String dialogType = MiscUtilities.isURL(files[0].deletePath) && "favorites".equals(MiscUtilities.getProtocolOfURL(files[0].deletePath)) ? "vfs.browser.delete-favorites" : "vfs.browser.delete-confirm";
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            buf.append(files[i].path);
            buf.append('\n');
        }
        Object[] args = new Object[]{buf.toString()};
        int result = GUIUtilities.confirm(this, dialogType, args, 0, 2);
        if (result != 0) {
            return;
        }
        VFS vfs = VFSManager.getVFSForPath(files[0].deletePath);
        if (!this.startRequest()) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            Object session = vfs.createVFSSession(files[i].deletePath, this);
            if (session == null) continue;
            VFSManager.runInWorkThread(new BrowserIORequest(1, this, session, vfs, files[i].deletePath, null, null));
        }
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void rename(String from) {
        VFS vfs = VFSManager.getVFSForPath(from);
        String filename = vfs.getFileName(from);
        Object[] args = new String[]{filename};
        String to = GUIUtilities.input(this, "vfs.browser.rename", args, filename);
        if (to == null) {
            return;
        }
        to = MiscUtilities.constructPath(vfs.getParentOfPath(from), to);
        Object session = vfs.createVFSSession(from, this);
        if (session == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(2, this, session, vfs, from, to, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void mkdir() {
        String parent;
        String newDirectory = GUIUtilities.input(this, "vfs.browser.mkdir", null);
        if (newDirectory == null) {
            return;
        }
        VFS.DirectoryEntry[] selected = this.getSelectedFiles();
        if (selected.length == 0) {
            parent = this.path;
        } else if (selected[0].type == 0) {
            parent = selected[0].path;
            parent = VFSManager.getVFSForPath(parent).getParentOfPath(parent);
        } else {
            parent = selected[0].path;
        }
        VFS vfs = VFSManager.getVFSForPath(parent);
        newDirectory = MiscUtilities.constructPath(parent, newDirectory);
        Object session = vfs.createVFSSession(newDirectory, this);
        if (session == null) {
            return;
        }
        if (!this.startRequest()) {
            return;
        }
        VFSManager.runInWorkThread(new BrowserIORequest(3, this, session, vfs, newDirectory, null, null));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.endRequest();
            }
        });
    }

    public void newFile() {
        VFS.DirectoryEntry[] selected = this.getSelectedFiles();
        if (selected.length >= 1) {
            VFS.DirectoryEntry file = selected[0];
            if (file.type == 1) {
                jEdit.newFile(this.view, file.path);
            } else {
                VFS vfs = VFSManager.getVFSForPath(file.path);
                jEdit.newFile(this.view, vfs.getParentOfPath(file.path));
            }
        } else {
            jEdit.newFile(this.view, this.path);
        }
    }

    public void searchInDirectory() {
        VFS.DirectoryEntry[] selected = this.getSelectedFiles();
        if (selected.length >= 1) {
            VFS.DirectoryEntry file = selected[0];
            this.searchInDirectory(file.path, file.type != 0);
        } else {
            this.searchInDirectory(this.path, true);
        }
    }

    public void searchInDirectory(String path, boolean directory) {
        String filter;
        if (directory) {
            filter = this.getFilenameFilter();
        } else {
            String name = MiscUtilities.getFileName(path);
            String ext = MiscUtilities.getFileExtension(name);
            filter = ext == null || ext.length() == 0 ? this.getFilenameFilter() : "*" + ext;
            path = MiscUtilities.getParentOfPath(path);
        }
        SearchAndReplace.setSearchFileSet(new DirectoryListSet(path, filter, true));
        SearchDialog.showSearchDialog(this.view, null, 2);
    }

    public BrowserView getBrowserView() {
        return this.browserView;
    }

    public VFS.DirectoryEntry[] getSelectedFiles() {
        return this.browserView.getSelectedFiles();
    }

    public void locateFile(final String path) {
        if (!this.filenameFilter.isMatch(MiscUtilities.getFileName(path))) {
            this.setFilenameFilter(null);
        }
        this.setDirectory(MiscUtilities.getParentOfPath(path));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                VFSBrowser.this.browserView.getTable().selectFile(path);
            }
        });
    }

    public void addBrowserListener(BrowserListener l) {
        this.listenerList.add(class$org$gjt$sp$jedit$browser$BrowserListener == null ? (class$org$gjt$sp$jedit$browser$BrowserListener = VFSBrowser.class$("org.gjt.sp.jedit.browser.BrowserListener")) : class$org$gjt$sp$jedit$browser$BrowserListener, l);
    }

    public void removeBrowserListener(BrowserListener l) {
        this.listenerList.remove(class$org$gjt$sp$jedit$browser$BrowserListener == null ? (class$org$gjt$sp$jedit$browser$BrowserListener = VFSBrowser.class$("org.gjt.sp.jedit.browser.BrowserListener")) : class$org$gjt$sp$jedit$browser$BrowserListener, l);
    }

    public void filesActivated(int mode, boolean canDoubleClickClose) {
        VFS.DirectoryEntry[] selectedFiles = this.browserView.getSelectedFiles();
        Buffer buffer = null;
        for (int i = 0; i < selectedFiles.length; ++i) {
            VFS.DirectoryEntry file = selectedFiles[i];
            if (file.type == 1 || file.type == 2) {
                if (mode == 1 && this.mode == 2) {
                    VFSBrowser.browseDirectoryInNewWindow(this.view, file.path);
                    continue;
                }
                this.setDirectory(file.path);
                continue;
            }
            if (this.mode != 2 && this.mode != 4) continue;
            if (mode == 4) {
                this.view.getBuffer().insertFile(this.view, file.path);
                continue;
            }
            Buffer _buffer = jEdit.getBuffer(file.path);
            if (_buffer == null) {
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                props.put("encoding", this.currentEncoding);
                props.put("encodingAutodetect", new Boolean(this.autoDetectEncoding));
                _buffer = jEdit.openFile(null, null, file.path, false, props);
            } else if (this.doubleClickClose && canDoubleClickClose && this.mode != 4 && selectedFiles.length == 1) {
                EditPane[] editPanes = this.view.getEditPanes();
                for (int j = 0; j < editPanes.length; ++j) {
                    if (editPanes[j].getBuffer() != _buffer) continue;
                    jEdit.closeBuffer(this.view, _buffer);
                    return;
                }
            }
            if (_buffer == null) continue;
            buffer = _buffer;
        }
        if (buffer != null) {
            switch (mode) {
                case 0: {
                    this.view.setBuffer(buffer);
                    break;
                }
                case 1: {
                    jEdit.newView(this.view, buffer, false);
                    break;
                }
                case 2: {
                    jEdit.newView(this.view, buffer, true);
                    break;
                }
                case 3: {
                    this.view.splitHorizontally().setBuffer(buffer);
                }
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != (class$org$gjt$sp$jedit$browser$BrowserListener == null ? VFSBrowser.class$("org.gjt.sp.jedit.browser.BrowserListener") : class$org$gjt$sp$jedit$browser$BrowserListener)) continue;
            BrowserListener l = (BrowserListener)listeners[i + 1];
            l.filesActivated(this, selectedFiles);
        }
    }

    static boolean pathsEqual(String p1, String p2) {
        if (p1.endsWith("/") || p1.endsWith(File.separator)) {
            p1 = p1.substring(0, p1.length() - 1);
        }
        if (p2.endsWith("/") || p2.endsWith(File.separator)) {
            p2 = p2.substring(0, p2.length() - 1);
        }
        return p1.equals(p2);
    }

    void updateFilenameFilter() {
        try {
            String filter = this.filterField.getText();
            if (filter.length() == 0) {
                filter = "*";
            }
            this.filenameFilter = new RE(MiscUtilities.globToRE(filter), 2);
        }
        catch (Exception e) {
            Log.log(9, this, e);
            Object[] args = new String[]{this.filterField.getText(), e.getMessage()};
            GUIUtilities.error(this, "vfs.browser.bad-filter", args);
        }
    }

    void directoryLoaded(Object node, Object[] loadInfo) {
        VFSManager.runInAWTThread(new DirectoryLoadedAWTRequest(node, loadInfo));
    }

    void filesSelected() {
        VFS.DirectoryEntry[] selectedFiles = this.browserView.getSelectedFiles();
        if (this.mode == 2) {
            for (int i = 0; i < selectedFiles.length; ++i) {
                VFS.DirectoryEntry file = selectedFiles[i];
                Buffer buffer = jEdit.getBuffer(file.path);
                if (buffer == null || this.view == null) continue;
                this.view.setBuffer(buffer);
            }
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] != (class$org$gjt$sp$jedit$browser$BrowserListener == null ? VFSBrowser.class$("org.gjt.sp.jedit.browser.BrowserListener") : class$org$gjt$sp$jedit$browser$BrowserListener)) continue;
            BrowserListener l = (BrowserListener)listeners[i + 1];
            l.filesSelected(this, selectedFiles);
        }
    }

    void endRequest() {
        this.requestRunning = false;
    }

    private JPanel createMenuBar() {
        JPanel menuBar = new JPanel();
        menuBar.setLayout(new BoxLayout(menuBar, 0));
        menuBar.setBorder(new EmptyBorder(0, 1, 0, 3));
        menuBar.add(new CommandsMenuButton());
        menuBar.add(Box.createHorizontalStrut(3));
        this.plugins = new PluginsMenuButton();
        menuBar.add(this.plugins);
        menuBar.add(Box.createHorizontalStrut(3));
        this.favorites = new FavoritesMenuButton();
        menuBar.add(this.favorites);
        return menuBar;
    }

    private Box createToolBar() {
        if (this.mode == 2) {
            return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-browser");
        }
        return GUIUtilities.loadToolBar(actionContext, "vfs.browser.toolbar-dialog");
    }

    private void propertiesChanged() {
        this.showHiddenFiles = jEdit.getBooleanProperty("vfs.browser.showHiddenFiles");
        this.sortMixFilesAndDirs = jEdit.getBooleanProperty("vfs.browser.sortMixFilesAndDirs");
        this.sortIgnoreCase = jEdit.getBooleanProperty("vfs.browser.sortIgnoreCase");
        this.doubleClickClose = jEdit.getBooleanProperty("vfs.browser.doubleClickClose");
        this.browserView.propertiesChanged();
        this.toolbarBox.removeAll();
        if (jEdit.getBooleanProperty("vfs.browser.showToolbar")) {
            Box toolbar = this.createToolBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add(toolbar);
            } else {
                toolbar.add(Box.createGlue());
                this.toolbarBox.add(toolbar);
            }
        }
        if (jEdit.getBooleanProperty("vfs.browser.showMenubar")) {
            JPanel menubar = this.createMenuBar();
            if (this.horizontalLayout) {
                this.toolbarBox.add(Box.createHorizontalStrut(6));
                this.toolbarBox.add((Component)menubar, 0);
            } else {
                menubar.add(Box.createGlue());
                this.toolbarBox.add(menubar);
            }
        } else {
            this.favorites = null;
        }
        this.toolbarBox.add(Box.createGlue());
        this.revalidate();
        if (this.path != null) {
            this.reloadDirectory();
        }
    }

    private boolean startRequest() {
        if (this.requestRunning) {
            Log.log(1, this, new Throwable("For debugging purposes"));
            GUIUtilities.error(this, "browser-multiple-io", null);
            return false;
        }
        this.requestRunning = true;
        return true;
    }

    private void updateFilterEnabled() {
        this.filterField.setEnabled(this.filterCheckbox.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeReloadDirectory(String dir2) {
        if (MiscUtilities.isURL(dir2) && MiscUtilities.getProtocolOfURL(dir2).equals("favorites") && this.favorites != null) {
            this.favorites.popup = null;
        }
        if (this.maybeReloadRequestRunning) {
            return;
        }
        if (this.path != null) {
            try {
                this.maybeReloadRequestRunning = true;
                this.browserView.maybeReloadDirectory(dir2);
            }
            catch (Throwable throwable) {
                VFSManager.runInAWTThread(new Runnable(){

                    public void run() {
                        VFSBrowser.this.maybeReloadRequestRunning = false;
                    }
                });
                throw throwable;
            }
            VFSManager.runInAWTThread(new /* invalid duplicate definition of identical inner class */);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ActionSet builtInActionSet = new ActionSet(null, null, null, (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = VFSBrowser.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResource("browser.actions.xml"));
        builtInActionSet.setLabel(jEdit.getProperty("action-set.browser"));
        builtInActionSet.load();
        actionContext.addActionSet(builtInActionSet);
    }

    static class BrowserActionContext
    extends ActionContext {
        BrowserActionContext() {
        }

        private VFS.DirectoryEntry[] getSelectedFiles(EventObject evt, VFSBrowser browser) {
            Component source = (Component)evt.getSource();
            if (GUIUtilities.getComponentParent(source, class$javax$swing$JList == null ? (class$javax$swing$JList = VFSBrowser.class$("javax.swing.JList")) : class$javax$swing$JList) != null) {
                Object[] selected = browser.getBrowserView().getParentDirectoryList().getSelectedValues();
                VFS.DirectoryEntry[] returnValue = new VFS.DirectoryEntry[selected.length];
                System.arraycopy(selected, 0, returnValue, 0, selected.length);
                return returnValue;
            }
            return browser.getSelectedFiles();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void invokeAction(EventObject evt, EditAction action) {
            block9: {
                VFSBrowser browser = (VFSBrowser)GUIUtilities.getComponentParent((Component)evt.getSource(), class$org$gjt$sp$jedit$browser$VFSBrowser == null ? (class$org$gjt$sp$jedit$browser$VFSBrowser = VFSBrowser.class$("org.gjt.sp.jedit.browser.VFSBrowser")) : class$org$gjt$sp$jedit$browser$VFSBrowser);
                VFS.DirectoryEntry[] files = this.getSelectedFiles(evt, browser);
                NameSpace global = BeanShell.getNameSpace();
                global.setVariable("browser", browser);
                global.setVariable("files", files);
                View view = browser.getView();
                if (view == null) {
                    view = jEdit.getActiveView();
                }
                action.invoke(view);
                Object var8_8 = null;
                try {
                    global.setVariable("browser", null);
                    global.setVariable("files", null);
                }
                catch (UtilEvalError err2) {
                    Log.log(9, this, err2);
                }
                break block9;
                {
                    catch (UtilEvalError err) {
                        Log.log(9, this, err);
                        Object var8_9 = null;
                        try {
                            global.setVariable("browser", null);
                            global.setVariable("files", null);
                        }
                        catch (UtilEvalError err2) {
                            Log.log(9, this, err2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    try {
                        global.setVariable("browser", null);
                        global.setVariable("files", null);
                    }
                    catch (UtilEvalError err2) {
                        Log.log(9, this, err2);
                    }
                    throw throwable;
                }
            }
        }
    }

    class DirectoryLoadedAWTRequest
    implements Runnable {
        Object node;
        Object[] loadInfo;

        DirectoryLoadedAWTRequest(Object node, Object[] loadInfo) {
            this.node = node;
            this.loadInfo = loadInfo;
        }

        public void run() {
            String path = (String)this.loadInfo[0];
            if (path == null) {
                return;
            }
            VFS.DirectoryEntry[] list = (VFS.DirectoryEntry[])this.loadInfo[1];
            if (this.node == null) {
                VFSBrowser.this.path = path;
                if (!VFSBrowser.this.pathField.getText().equals(path)) {
                    VFSBrowser.this.pathField.setText(path);
                }
                if (path.endsWith("/") || path.endsWith(File.separator)) {
                    path = path.substring(0, path.length() - 1);
                }
                HistoryModel.getModel("vfs.browser.path").addItem(path);
            }
            boolean filterEnabled = VFSBrowser.this.filterCheckbox.isSelected();
            ArrayList<VFS.DirectoryEntry> directoryVector = new ArrayList<VFS.DirectoryEntry>();
            int directories = 0;
            int files = 0;
            int invisible = 0;
            if (list != null) {
                for (int i = 0; i < list.length; ++i) {
                    VFS.DirectoryEntry file = list[i];
                    if (file.hidden && !VFSBrowser.this.showHiddenFiles) {
                        ++invisible;
                        continue;
                    }
                    if (file.type == 0 && filterEnabled && VFSBrowser.this.filenameFilter != null && !VFSBrowser.this.filenameFilter.isMatch(file.name)) {
                        ++invisible;
                        continue;
                    }
                    if (file.type == 0) {
                        ++files;
                    } else {
                        ++directories;
                    }
                    directoryVector.add(file);
                }
                MiscUtilities.quicksort(directoryVector, (Comparator)new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
            }
            VFSBrowser.this.browserView.directoryLoaded(this.node, path, directoryVector);
            if (VFSBrowser.this.mode == 3) {
                VFSBrowser.this.filesSelected();
            }
        }

        public String toString() {
            return (String)this.loadInfo[0];
        }
    }

    class FavoritesMenuButton
    extends JButton {
        JPopupMenu popup;

        FavoritesMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.favorites.label"));
            this.setIcon(GUIUtilities.loadIcon("ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        void createPopupMenu() {
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            JMenuItem mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.add-to-favorites.label"));
            mi.setActionCommand("add-to-favorites");
            mi.addActionListener(actionHandler);
            this.popup.add(mi);
            mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.edit-favorites.label"));
            mi.setActionCommand("dir@favorites:");
            mi.addActionListener(actionHandler);
            this.popup.add(mi);
            this.popup.addSeparator();
            Object[] favorites = FavoritesVFS.getFavorites();
            if (favorites.length == 0) {
                mi = new JMenuItem(jEdit.getProperty("vfs.browser.favorites.no-favorites.label"));
                mi.setEnabled(false);
                this.popup.add(mi);
            } else {
                MiscUtilities.quicksort(favorites, (MiscUtilities.Compare)new VFS.DirectoryEntryCompare(VFSBrowser.this.sortMixFilesAndDirs, VFSBrowser.this.sortIgnoreCase));
                for (int i = 0; i < favorites.length; ++i) {
                    Object favorite = favorites[i];
                    mi = new JMenuItem(((VFS.DirectoryEntry)favorite).path);
                    mi.setIcon(FileCellRenderer.getIconForFile((VFS.DirectoryEntry)favorite, false));
                    String cmd = (((VFS.DirectoryEntry)favorite).type == 0 ? "file@" : "dir@") + ((VFS.DirectoryEntry)favorite).path;
                    mi.setActionCommand(cmd);
                    mi.addActionListener(actionHandler);
                    this.popup.add(mi);
                }
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent evt) {
                if (FavoritesMenuButton.this.popup != null && FavoritesMenuButton.this.popup.isVisible()) {
                    FavoritesMenuButton.this.popup.setVisible(false);
                    return;
                }
                if (FavoritesMenuButton.this.popup == null) {
                    FavoritesMenuButton.this.createPopupMenu();
                }
                GUIUtilities.showPopupMenu(FavoritesMenuButton.this.popup, FavoritesMenuButton.this, 0, FavoritesMenuButton.this.getHeight(), false);
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                String actionCommand = evt.getActionCommand();
                if (actionCommand.equals("add-to-favorites")) {
                    VFS.DirectoryEntry[] selected = VFSBrowser.this.getSelectedFiles();
                    if (selected == null || selected.length == 0) {
                        if (VFSBrowser.this.path.equals("favorites:")) {
                            GUIUtilities.error(VFSBrowser.this, "vfs.browser.recurse-favorites", null);
                        } else {
                            FavoritesVFS.addToFavorites(VFSBrowser.this.path, 1);
                        }
                    } else {
                        for (int i = 0; i < selected.length; ++i) {
                            VFS.DirectoryEntry file = selected[i];
                            FavoritesVFS.addToFavorites(file.path, file.type);
                        }
                    }
                } else if (actionCommand.startsWith("dir@")) {
                    VFSBrowser.this.setDirectory(actionCommand.substring(4));
                } else if (actionCommand.startsWith("file@")) {
                    switch (VFSBrowser.this.getMode()) {
                        case 2: {
                            jEdit.openFile(VFSBrowser.this.view, actionCommand.substring(5));
                            break;
                        }
                        default: {
                            VFSBrowser.this.locateFile(actionCommand.substring(5));
                        }
                    }
                }
            }
        }
    }

    class PluginsMenuButton
    extends JButton {
        JPopupMenu popup;

        PluginsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.plugins.label"));
            this.setIcon(GUIUtilities.loadIcon("ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        void updatePopupMenu() {
            this.popup = null;
        }

        private void createPopupMenu() {
            int i;
            if (this.popup != null) {
                return;
            }
            this.popup = new JPopupMenu();
            ActionHandler actionHandler = new ActionHandler();
            if (VFSBrowser.this.getMode() == 2) {
                this.popup.add(GUIUtilities.loadMenuItem("plugin-manager", false));
                this.popup.add(GUIUtilities.loadMenuItem("plugin-options", false));
                this.popup.addSeparator();
            }
            ArrayList<JMenuItem> vec = new ArrayList<JMenuItem>();
            Enumeration e = VFSManager.getFilesystems();
            while (e.hasMoreElements()) {
                VFS vfs = (VFS)e.nextElement();
                if ((vfs.getCapabilities() & 4) == 0) continue;
                JMenuItem menuItem = new JMenuItem(jEdit.getProperty("vfs." + vfs.getName() + ".label"));
                menuItem.setActionCommand(vfs.getName());
                menuItem.addActionListener(actionHandler);
                vec.add(menuItem);
            }
            EditPlugin[] plugins = jEdit.getPlugins();
            for (i = 0; i < plugins.length; ++i) {
                JMenuItem menuItem = plugins[i].createBrowserMenuItems();
                if (menuItem == null) continue;
                vec.add(menuItem);
            }
            if (vec.size() != 0) {
                MiscUtilities.quicksort(vec, (Comparator)new MiscUtilities.MenuItemCompare());
                for (i = 0; i < vec.size(); ++i) {
                    this.popup.add((JMenuItem)vec.get(i));
                }
            } else {
                JMenuItem mi = new JMenuItem(jEdit.getProperty("vfs.browser.plugins.no-plugins.label"));
                mi.setEnabled(false);
                this.popup.add(mi);
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent evt) {
                PluginsMenuButton.this.createPopupMenu();
                if (!PluginsMenuButton.this.popup.isVisible()) {
                    GUIUtilities.showPopupMenu(PluginsMenuButton.this.popup, PluginsMenuButton.this, 0, PluginsMenuButton.this.getHeight(), false);
                } else {
                    PluginsMenuButton.this.popup.setVisible(false);
                }
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                VFS vfs = VFSManager.getVFSByName(evt.getActionCommand());
                String directory = vfs.showBrowseDialog(null, VFSBrowser.this);
                if (directory != null) {
                    VFSBrowser.this.setDirectory(directory);
                }
            }
        }
    }

    class CommandsMenuButton
    extends JButton {
        BrowserCommandsMenu popup;

        CommandsMenuButton() {
            this.setText(jEdit.getProperty("vfs.browser.commands.label"));
            this.setIcon(GUIUtilities.loadIcon("ToolbarMenu.gif"));
            this.setHorizontalTextPosition(10);
            this.popup = new BrowserCommandsMenu(VFSBrowser.this, null);
            this.setRequestFocusEnabled(false);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.addMouseListener(new MouseHandler());
            if (OperatingSystem.isMacOSLF()) {
                this.putClientProperty("JButton.buttonType", "toolbar");
            }
        }

        class MouseHandler
        extends MouseAdapter {
            MouseHandler() {
            }

            public void mousePressed(MouseEvent evt) {
                if (!CommandsMenuButton.this.popup.isVisible()) {
                    CommandsMenuButton.this.popup.update();
                    GUIUtilities.showPopupMenu(CommandsMenuButton.this.popup, CommandsMenuButton.this, 0, CommandsMenuButton.this.getHeight(), false);
                } else {
                    CommandsMenuButton.this.popup.setVisible(false);
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == VFSBrowser.this.pathField || source == VFSBrowser.this.filterField || source == VFSBrowser.this.filterCheckbox) {
                VFSBrowser.this.updateFilterEnabled();
                String path = VFSBrowser.this.pathField.getText();
                if (path != null) {
                    VFSBrowser.this.setDirectory(path);
                }
                VFSBrowser.this.browserView.focusOnFileView();
            }
        }
    }
}

