/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.util.Log;

public abstract class FoldHandler {
    public static final String SERVICE = "org.gjt.sp.jedit.buffer.FoldHandler";
    private String name;
    private static ArrayList foldHandlers = new ArrayList();
    static /* synthetic */ Class class$org$gjt$sp$jedit$buffer$FoldHandler;

    public String getName() {
        return this.name;
    }

    public abstract int getFoldLevel(Buffer var1, int var2, Segment var3);

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static void registerFoldHandler(FoldHandler handler) {
        if (FoldHandler.getFoldHandler(handler.getName()) != null) {
            Log.log(9, class$org$gjt$sp$jedit$buffer$FoldHandler == null ? (class$org$gjt$sp$jedit$buffer$FoldHandler = FoldHandler.class$(SERVICE)) : class$org$gjt$sp$jedit$buffer$FoldHandler, "Cannot register more than one fold handler with the same name");
            return;
        }
        foldHandlers.add(handler);
    }

    public static void unregisterFoldHandler(FoldHandler handler) {
        foldHandlers.remove(handler);
    }

    public static FoldHandler[] getFoldHandlers() {
        FoldHandler[] handlers = new FoldHandler[foldHandlers.size()];
        return foldHandlers.toArray(handlers);
    }

    public static FoldHandler getFoldHandler(String name) {
        FoldHandler handler = (FoldHandler)ServiceManager.getService(SERVICE, name);
        if (handler != null) {
            return handler;
        }
        Iterator i = foldHandlers.iterator();
        while (i.hasNext()) {
            handler = (FoldHandler)i.next();
            if (!name.equals(handler.getName())) continue;
            return handler;
        }
        return null;
    }

    public static String[] getFoldModes() {
        FoldHandler[] handlers = FoldHandler.getFoldHandlers();
        String[] newApi = ServiceManager.getServiceNames(SERVICE);
        String[] foldModes = new String[handlers.length + newApi.length];
        System.arraycopy(newApi, 0, foldModes, 0, newApi.length);
        for (int i = 0; i < handlers.length; ++i) {
            foldModes[i + newApi.length] = handlers[i].getName();
        }
        Arrays.sort(foldModes, new MiscUtilities.StringCompare());
        return foldModes;
    }

    protected FoldHandler(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

