/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class AboutDialog
extends EnhancedDialog {
    private JButton close;

    public AboutDialog(View view) {
        super(view, jEdit.getProperty("about.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        content.add("Center", new AboutPanel());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonPanel.add(Box.createGlue());
        this.close = new JButton(jEdit.getProperty("common.close"));
        this.close.addActionListener(new ActionHandler());
        this.getRootPane().setDefaultButton(this.close);
        buttonPanel.add(this.close);
        buttonPanel.add(Box.createGlue());
        content.add("South", buttonPanel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    static class AboutPanel
    extends JComponent {
        ImageIcon image;
        Vector text;
        int scrollPosition;
        AnimationThread thread;
        int maxWidth;
        FontMetrics fm;
        public static int TOP = 120;
        public static int BOTTOM = 30;

        AboutPanel() {
            this.setFont(UIManager.getFont("Label.font"));
            this.fm = this.getFontMetrics(this.getFont());
            this.setForeground(new Color(96, 96, 96));
            this.image = new ImageIcon(this.getClass().getResource("/org/gjt/sp/jedit/icons/about.png"));
            this.setBorder(new MatteBorder(1, 1, 1, 1, Color.gray));
            this.text = new Vector(50);
            StringTokenizer st = new StringTokenizer(jEdit.getProperty("about.text"), "\n");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                this.text.addElement(line);
                this.maxWidth = Math.max(this.maxWidth, this.fm.stringWidth(line) + 10);
            }
            this.scrollPosition = -250;
            this.thread = new AnimationThread();
        }

        public void paintComponent(Graphics g) {
            g.setColor(new Color(96, 96, 96));
            this.image.paintIcon(this, g, 1, 1);
            FontMetrics fm = g.getFontMetrics();
            Object[] args = new String[]{jEdit.getVersion()};
            String version = jEdit.getProperty("about.version", args);
            g.drawString(version, (this.getWidth() - fm.stringWidth(version)) / 2, this.getHeight() - 5);
            g = g.create((this.getWidth() - this.maxWidth) / 2, TOP, this.maxWidth, this.getHeight() - TOP - BOTTOM);
            int height = fm.getHeight();
            int firstLine = this.scrollPosition / height;
            int firstLineOffset = height - this.scrollPosition % height;
            int lines = (this.getHeight() - TOP - BOTTOM) / height;
            int y = firstLineOffset;
            for (int i = 0; i <= lines; ++i) {
                if (i + firstLine >= 0 && i + firstLine < this.text.size()) {
                    String line = (String)this.text.get(i + firstLine);
                    g.drawString(line, (this.maxWidth - fm.stringWidth(line)) / 2, y);
                }
                y += fm.getHeight();
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(1 + this.image.getIconWidth(), 1 + this.image.getIconHeight());
        }

        public void addNotify() {
            super.addNotify();
            this.thread.start();
        }

        public void removeNotify() {
            super.removeNotify();
            this.thread.kill();
        }

        class AnimationThread
        extends Thread {
            private boolean running = true;
            private long last;

            AnimationThread() {
                super("About box animation thread");
                this.setPriority(1);
            }

            public void kill() {
                this.running = false;
            }

            public void run() {
                FontMetrics fm = AboutPanel.this.getFontMetrics(AboutPanel.this.getFont());
                int max = AboutPanel.this.text.size() * fm.getHeight();
                while (this.running) {
                    AboutPanel.this.scrollPosition += 2;
                    if (AboutPanel.this.scrollPosition > max) {
                        AboutPanel.this.scrollPosition = -250;
                    }
                    if (this.last != 0L) {
                        long frameDelay = System.currentTimeMillis() - this.last;
                        try {
                            Thread.sleep(75L - frameDelay);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    this.last = System.currentTimeMillis();
                    AboutPanel.this.repaint(AboutPanel.this.getWidth() / 2 - AboutPanel.this.maxWidth, TOP, AboutPanel.this.maxWidth * 2, AboutPanel.this.getHeight() - TOP - BOTTOM);
                }
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            AboutDialog.this.dispose();
        }
    }
}

