/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.KeyEventWorkaround;
import org.gjt.sp.util.Log;

public class DefaultInputHandler
extends InputHandler {
    private static Object PREFIX_STR = "PREFIX_STR";
    private Hashtable bindings;
    private Hashtable currentBindings;
    static /* synthetic */ Class class$org$gjt$sp$jedit$gui$DefaultInputHandler;
    static /* synthetic */ Class class$java$awt$event$KeyEvent;

    public DefaultInputHandler(View view) {
        super(view);
        this.bindings = this.currentBindings = new Hashtable();
    }

    public DefaultInputHandler(View view, DefaultInputHandler copy) {
        super(view);
        this.bindings = this.currentBindings = copy.bindings;
    }

    public void addKeyBinding(String keyBinding, String action) {
        this._addKeyBinding(keyBinding, action);
    }

    public void addKeyBinding(String keyBinding, EditAction action) {
        this._addKeyBinding(keyBinding, action);
    }

    public void removeKeyBinding(String keyBinding) {
        Hashtable current = this.bindings;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            String keyCodeStr = st.nextToken();
            KeyEventTranslator.Key keyStroke = KeyEventTranslator.parseKey(keyCodeStr);
            if (keyStroke == null) {
                return;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    current = (Hashtable)o;
                    continue;
                }
                if (o != null) {
                    current.remove(keyStroke);
                    return;
                }
                return;
            }
            current.remove(keyStroke);
        }
    }

    public void removeAllKeyBindings() {
        this.bindings.clear();
    }

    public Object getKeyBinding(String keyBinding) {
        Hashtable current = this.bindings;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            KeyEventTranslator.Key keyStroke = KeyEventTranslator.parseKey(st.nextToken());
            if (keyStroke == null) {
                return null;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    if (!st.hasMoreTokens()) {
                        return o;
                    }
                    current = (Hashtable)o;
                    continue;
                }
                return o;
            }
            return current.get(keyStroke);
        }
        return null;
    }

    public boolean isPrefixActive() {
        return this.bindings != this.currentBindings || super.isPrefixActive();
    }

    public boolean handleKey(KeyEventTranslator.Key keyStroke) {
        Object o;
        char input = '\u0000';
        if (keyStroke.modifiers == null || keyStroke.modifiers.equals("S")) {
            switch (keyStroke.key) {
                case 9: 
                case 10: {
                    input = (char)keyStroke.key;
                    break;
                }
                default: {
                    input = keyStroke.input;
                }
            }
        }
        if (this.readNextChar != null) {
            if (input != '\u0000') {
                this.setCurrentBindings(this.bindings);
                this.invokeReadNextChar(input);
                this.repeatCount = 1;
                return true;
            }
            this.readNextChar = null;
            this.view.getStatus().setMessage(null);
        }
        if ((o = this.currentBindings.get(keyStroke)) == null) {
            if (this.currentBindings != this.bindings) {
                Toolkit.getDefaultToolkit().beep();
                this.repeatCount = 1;
                this.setCurrentBindings(this.bindings);
            }
            if (input != '\u0000') {
                this.userInput(input);
            } else {
                switch (keyStroke.key) {
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 103: 
                    case 104: 
                    case 105: 
                    case 106: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: {
                        KeyEventWorkaround.numericKeypadKey();
                    }
                }
            }
        } else {
            if (o instanceof Hashtable) {
                this.setCurrentBindings((Hashtable)o);
                return true;
            }
            if (o instanceof String) {
                this.setCurrentBindings(this.bindings);
                this.invokeAction((String)o);
                return true;
            }
            if (o instanceof EditAction) {
                this.setCurrentBindings(this.bindings);
                this.invokeAction((EditAction)o);
                return true;
            }
        }
        return false;
    }

    public static char getSymbolicModifierName(int mod) {
        return KeyEventTranslator.getSymbolicModifierName(mod);
    }

    public static String getModifierString(InputEvent evt) {
        return KeyEventTranslator.getModifierString(evt);
    }

    public static KeyStroke parseKeyStroke(String keyStroke) {
        int ch;
        String key;
        if (keyStroke == null) {
            return null;
        }
        int modifiers = 0;
        int index = keyStroke.indexOf(43);
        if (index != -1) {
            block8: for (int i = 0; i < index; ++i) {
                switch (Character.toUpperCase(keyStroke.charAt(i))) {
                    case 'A': {
                        modifiers |= KeyEventTranslator.a;
                        continue block8;
                    }
                    case 'C': {
                        modifiers |= KeyEventTranslator.c;
                        continue block8;
                    }
                    case 'M': {
                        modifiers |= KeyEventTranslator.m;
                        continue block8;
                    }
                    case 'S': {
                        modifiers |= KeyEventTranslator.s;
                    }
                }
            }
        }
        if ((key = keyStroke.substring(index + 1)).length() == 1) {
            char ch2 = key.charAt(0);
            if (modifiers == 0) {
                return KeyStroke.getKeyStroke(ch2);
            }
            return KeyStroke.getKeyStroke((int)Character.toUpperCase(ch2), modifiers);
        }
        if (key.length() == 0) {
            Log.log(9, class$org$gjt$sp$jedit$gui$DefaultInputHandler == null ? (class$org$gjt$sp$jedit$gui$DefaultInputHandler = DefaultInputHandler.class$("org.gjt.sp.jedit.gui.DefaultInputHandler")) : class$org$gjt$sp$jedit$gui$DefaultInputHandler, "Invalid key stroke: " + keyStroke);
            return null;
        }
        try {
            ch = (class$java$awt$event$KeyEvent == null ? (class$java$awt$event$KeyEvent = DefaultInputHandler.class$("java.awt.event.KeyEvent")) : class$java$awt$event$KeyEvent).getField("VK_".concat(key)).getInt(null);
        }
        catch (Exception e) {
            Log.log(9, class$org$gjt$sp$jedit$gui$DefaultInputHandler == null ? (class$org$gjt$sp$jedit$gui$DefaultInputHandler = DefaultInputHandler.class$("org.gjt.sp.jedit.gui.DefaultInputHandler")) : class$org$gjt$sp$jedit$gui$DefaultInputHandler, "Invalid key stroke: " + keyStroke);
            return null;
        }
        return KeyStroke.getKeyStroke(ch, modifiers);
    }

    private void setCurrentBindings(Hashtable bindings) {
        this.view.getStatus().setMessage((String)bindings.get(PREFIX_STR));
        this.currentBindings = bindings;
    }

    public void _addKeyBinding(String keyBinding, Object action) {
        Hashtable current = this.bindings;
        String prefixStr = null;
        StringTokenizer st = new StringTokenizer(keyBinding);
        while (st.hasMoreTokens()) {
            String keyCodeStr = st.nextToken();
            prefixStr = prefixStr == null ? keyCodeStr : prefixStr + " " + keyCodeStr;
            KeyEventTranslator.Key keyStroke = KeyEventTranslator.parseKey(keyCodeStr);
            if (keyStroke == null) {
                return;
            }
            if (st.hasMoreTokens()) {
                Object o = current.get(keyStroke);
                if (o instanceof Hashtable) {
                    current = (Hashtable)o;
                    continue;
                }
                Hashtable<Object, String> hash = new Hashtable<Object, String>();
                hash.put(PREFIX_STR, prefixStr);
                o = hash;
                current.put(keyStroke, o);
                current = (Hashtable)o;
                continue;
            }
            current.put(keyStroke, action);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

