/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class HistoryModel
extends AbstractListModel {
    private static final String TO_ESCAPE = "\r\n\t\\\"'[]";
    private static int max;
    private String name;
    private Vector data;
    private static Hashtable models;
    private static boolean modified;
    private static File history;
    private static long historyModTime;
    static /* synthetic */ Class class$org$gjt$sp$jedit$gui$HistoryModel;

    public HistoryModel(String name) {
        this.name = name;
        this.data = new Vector(max);
    }

    public void addItem(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        modified = true;
        int index = this.data.indexOf(text);
        if (index != -1) {
            this.data.removeElementAt(index);
        }
        this.data.insertElementAt(text, 0);
        while (this.getSize() > max) {
            this.data.removeElementAt(this.data.size() - 1);
        }
    }

    public String getItem(int index) {
        return (String)this.data.elementAt(index);
    }

    public Object getElementAt(int index) {
        return this.getItem(index);
    }

    public void clear() {
        modified = true;
        this.data.removeAllElements();
    }

    public int getSize() {
        return this.data.size();
    }

    public String getName() {
        return this.name;
    }

    public static HistoryModel getModel(String name) {
        HistoryModel model;
        if (models == null) {
            models = new Hashtable();
        }
        if ((model = (HistoryModel)models.get(name)) == null) {
            model = new HistoryModel(name);
            models.put(name, model);
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadHistory() {
        block22: {
            BufferedReader in;
            block21: {
                String line;
                String settingsDirectory = jEdit.getSettingsDirectory();
                if (settingsDirectory == null) {
                    return;
                }
                history = new File(MiscUtilities.constructPath(settingsDirectory, "history"));
                if (!history.exists()) {
                    return;
                }
                historyModTime = history.lastModified();
                Log.log(3, class$org$gjt$sp$jedit$gui$HistoryModel == null ? (class$org$gjt$sp$jedit$gui$HistoryModel = HistoryModel.class$("org.gjt.sp.jedit.gui.HistoryModel")) : class$org$gjt$sp$jedit$gui$HistoryModel, "Loading history");
                if (models == null) {
                    models = new Hashtable();
                }
                in = null;
                in = new BufferedReader(new FileReader(history));
                HistoryModel currentModel = null;
                while ((line = in.readLine()) != null) {
                    if (line.startsWith("[") && line.endsWith("]")) {
                        if (currentModel != null) {
                            models.put(currentModel.getName(), currentModel);
                        }
                        String modelName = MiscUtilities.escapesToChars(line.substring(1, line.length() - 1));
                        currentModel = new HistoryModel(modelName);
                        continue;
                    }
                    if (currentModel == null) {
                        throw new IOException("History data starts before model name");
                    }
                    currentModel.data.addElement(MiscUtilities.escapesToChars(line));
                }
                if (currentModel == null) break block21;
                models.put(currentModel.getName(), currentModel);
            }
            Object var6_7 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block22;
            }
            catch (IOException io2) {}
            break block22;
            {
                catch (FileNotFoundException fnf) {
                    Object var6_8 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block22;
                    }
                    catch (IOException io2) {}
                    break block22;
                }
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$gui$HistoryModel == null ? (class$org$gjt$sp$jedit$gui$HistoryModel = HistoryModel.class$("org.gjt.sp.jedit.gui.HistoryModel")) : class$org$gjt$sp$jedit$gui$HistoryModel, io);
                    Object var6_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block22;
                    }
                    catch (IOException io2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException io2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void saveHistory() {
        File file2;
        block16: {
            if (!modified) {
                return;
            }
            Log.log(3, class$org$gjt$sp$jedit$gui$HistoryModel == null ? (class$org$gjt$sp$jedit$gui$HistoryModel = HistoryModel.class$("org.gjt.sp.jedit.gui.HistoryModel")) : class$org$gjt$sp$jedit$gui$HistoryModel, "Saving history");
            File file1 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "#history#save#"));
            file2 = new File(MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "history"));
            if (file2.exists() && file2.lastModified() != historyModTime) {
                Log.log(7, class$org$gjt$sp$jedit$gui$HistoryModel == null ? (class$org$gjt$sp$jedit$gui$HistoryModel = HistoryModel.class$("org.gjt.sp.jedit.gui.HistoryModel")) : class$org$gjt$sp$jedit$gui$HistoryModel, file2 + " changed on disk; will not save history");
                return;
            }
            jEdit.backupSettingsFile(file2);
            String lineSep = System.getProperty("line.separator");
            BufferedWriter out = null;
            out = new BufferedWriter(new FileWriter(file1));
            if (models != null) {
                Enumeration modelEnum = models.elements();
                while (modelEnum.hasMoreElements()) {
                    HistoryModel model = (HistoryModel)modelEnum.nextElement();
                    if (model.getSize() == 0) continue;
                    out.write(91);
                    out.write(MiscUtilities.charsToEscapes(model.getName(), TO_ESCAPE));
                    out.write(93);
                    out.write(lineSep);
                    for (int i = 0; i < model.getSize(); ++i) {
                        out.write(MiscUtilities.charsToEscapes(model.getItem(i), TO_ESCAPE));
                        out.write(lineSep);
                    }
                }
            }
            out.close();
            file2.delete();
            file1.renameTo(file2);
            modified = false;
            Object var8_8 = null;
            try {
                if (out != null) {
                    out.close();
                }
                break block16;
            }
            catch (IOException e) {}
            break block16;
            {
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$gui$HistoryModel == null ? (class$org$gjt$sp$jedit$gui$HistoryModel = HistoryModel.class$("org.gjt.sp.jedit.gui.HistoryModel")) : class$org$gjt$sp$jedit$gui$HistoryModel, io);
                    Object var8_9 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block16;
                    }
                    catch (IOException e) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        historyModTime = file2.lastModified();
    }

    public static void propertiesChanged() {
        max = jEdit.getIntegerProperty("history", 25);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

