/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.WorkThread;
import org.gjt.sp.util.WorkThreadPool;
import org.gjt.sp.util.WorkThreadProgressListener;

public class IOProgressMonitor
extends JPanel {
    private JLabel caption = new JLabel();
    private ThreadProgress[] threads;
    private WorkThreadHandler workThreadHandler;

    public IOProgressMonitor() {
        super(new BorderLayout());
        this.updateCaption();
        this.add("North", this.caption);
        this.threads = new ThreadProgress[VFSManager.getIOThreadPool().getThreadCount()];
        Box box = new Box(1);
        for (int i = 0; i < this.threads.length; ++i) {
            if (i != 0) {
                box.add(Box.createVerticalStrut(6));
            }
            this.threads[i] = new ThreadProgress(i);
            box.add(this.threads[i]);
        }
        JPanel threadPanel = new JPanel(new BorderLayout());
        threadPanel.setBorder(new EmptyBorder(6, 6, 6, 6));
        threadPanel.add("North", box);
        this.add("Center", new JScrollPane(threadPanel));
        this.workThreadHandler = new WorkThreadHandler();
    }

    public void addNotify() {
        VFSManager.getIOThreadPool().addProgressListener(this.workThreadHandler);
        super.addNotify();
    }

    public void removeNotify() {
        VFSManager.getIOThreadPool().removeProgressListener(this.workThreadHandler);
        super.removeNotify();
    }

    private void updateCaption() {
        Object[] args = new String[]{String.valueOf(VFSManager.getIOThreadPool().getRequestCount())};
        this.caption.setText(jEdit.getProperty("io-progress-monitor.caption", args));
    }

    static /* synthetic */ void access$100(IOProgressMonitor x0) {
        x0.updateCaption();
    }

    static /* synthetic */ ThreadProgress[] access$200(IOProgressMonitor x0) {
        return x0.threads;
    }

    class ThreadProgress
    extends JPanel {
        private int index;
        private JProgressBar progress;
        private JButton abort;

        public ThreadProgress(int index) {
            super(new BorderLayout(12, 12));
            this.index = index;
            Box box = new Box(1);
            box.add(Box.createGlue());
            this.progress = new JProgressBar();
            box.add(this.progress);
            this.progress.setStringPainted(true);
            box.add(Box.createGlue());
            this.add("Center", box);
            this.abort = new JButton(jEdit.getProperty("io-progress-monitor.abort"));
            this.abort.addActionListener(new ActionHandler());
            this.add("East", this.abort);
            this.update();
        }

        public void update() {
            WorkThread thread = VFSManager.getIOThreadPool().getThread(this.index);
            if (thread.isRequestRunning()) {
                this.abort.setEnabled(true);
                String status = thread.getStatus();
                if (status == null) {
                    status = "";
                }
                this.progress.setString(status);
                this.progress.setMaximum(thread.getProgressMaximum());
                this.progress.setValue(thread.getProgressValue());
            } else {
                this.abort.setEnabled(false);
                this.progress.setString(jEdit.getProperty("io-progress-monitor.idle"));
                this.progress.setValue(0);
            }
        }

        class ActionHandler
        implements ActionListener {
            ActionHandler() {
            }

            public void actionPerformed(ActionEvent evt) {
                int result;
                if (evt.getSource() == ThreadProgress.this.abort && (result = GUIUtilities.confirm(IOProgressMonitor.this, "abort", null, 0, 3)) == 0) {
                    VFSManager.getIOThreadPool().getThread(ThreadProgress.this.index).abortCurrentRequest();
                }
            }
        }
    }

    class WorkThreadHandler
    implements WorkThreadProgressListener {
        WorkThreadHandler() {
        }

        public void statusUpdate(WorkThreadPool pool, int index) {
            SwingUtilities.invokeLater(new Runnable(this, index){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ WorkThreadHandler this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                }

                public void run() {
                    IOProgressMonitor.access$100(WorkThreadHandler.access$000(this.this$1));
                    IOProgressMonitor.access$200(WorkThreadHandler.access$000(this.this$1))[this.val$index].update();
                }
            });
        }

        public void progressUpdate(WorkThreadPool pool, int index) {
            SwingUtilities.invokeLater(new Runnable(this, index){
                private final /* synthetic */ int val$index;
                private final /* synthetic */ WorkThreadHandler this$1;
                {
                    this.this$1 = this$1;
                    this.val$index = val$index;
                }

                public void run() {
                    IOProgressMonitor.access$100(WorkThreadHandler.access$000(this.this$1));
                    IOProgressMonitor.access$200(WorkThreadHandler.access$000(this.this$1))[this.val$index].update();
                }
            });
        }

        static /* synthetic */ IOProgressMonitor access$000(WorkThreadHandler x0) {
            return x0.IOProgressMonitor.this;
        }
    }
}

