/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;

public abstract class InputHandler {
    private static final int REPEAT_COUNT_THRESHOLD = 20;
    protected View view;
    protected int repeatCount;
    protected EditAction lastAction;
    protected int lastActionCount;
    protected String readNextChar;

    public InputHandler(View view) {
        this.view = view;
        this.repeatCount = 1;
    }

    public abstract void addKeyBinding(String var1, String var2);

    public abstract void addKeyBinding(String var1, EditAction var2);

    public abstract void removeKeyBinding(String var1);

    public abstract void removeAllKeyBindings();

    public boolean isPrefixActive() {
        return this.readNextChar != null;
    }

    public abstract boolean handleKey(KeyEventTranslator.Key var1);

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        int oldRepeatCount = this.repeatCount;
        this.repeatCount = repeatCount;
        if (oldRepeatCount != repeatCount) {
            this.view.getStatus().setMessage(null);
        }
    }

    public EditAction getLastAction() {
        return this.lastAction;
    }

    public int getLastActionCount() {
        return this.lastActionCount;
    }

    public void readNextChar(String msg, String code) {
        this.view.getStatus().setMessage(msg);
        this.readNextChar = code;
    }

    public void readNextChar(String code) {
        this.readNextChar = code;
    }

    public void resetLastActionCount() {
        this.lastActionCount = 0;
    }

    public void invokeAction(String action) {
        this.invokeAction(jEdit.getAction(action));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(EditAction action) {
        Buffer buffer = this.view.getBuffer();
        if (!action.noRememberLast()) {
            HistoryModel.getModel("action").addItem(action.getName());
            if (this.lastAction == action) {
                ++this.lastActionCount;
            } else {
                this.lastAction = action;
                this.lastActionCount = 1;
            }
        }
        int _repeatCount = this.repeatCount;
        if (action.noRepeat() || _repeatCount == 1) {
            action.invoke(this.view);
        } else {
            String label;
            Object[] pp;
            if (_repeatCount > 20 && GUIUtilities.confirm(this.view, "large-repeat-count", pp = new Object[]{label = (label = action.getLabel()) == null ? action.getName() : GUIUtilities.prettifyMenuLabel(label), new Integer(_repeatCount)}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            try {
                buffer.beginCompoundEdit();
                for (int i = 0; i < _repeatCount; ++i) {
                    action.invoke(this.view);
                }
            }
            finally {
                buffer.endCompoundEdit();
            }
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null && !action.noRecord()) {
            recorder.record(_repeatCount, action.getCode());
        }
        if (_repeatCount != 1) {
            if (this.readNextChar != null) {
                return;
            }
            this.repeatCount = 1;
            this.view.getStatus().setMessage(null);
        }
    }

    public void invokeLastAction() {
        if (this.lastAction == null) {
            this.view.getToolkit().beep();
        } else {
            this.invokeAction(this.lastAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void userInput(char ch) {
        this.lastActionCount = 0;
        JEditTextArea textArea = this.view.getTextArea();
        if (this.repeatCount == 1) {
            textArea.userInput(ch);
        } else {
            Object[] pp;
            if (this.repeatCount > 20 && GUIUtilities.confirm(this.view, "large-repeat-count.user-input", pp = new Object[]{String.valueOf(ch), new Integer(this.repeatCount)}, 2, 0) != 0) {
                this.repeatCount = 1;
                this.view.getStatus().setMessage(null);
                return;
            }
            Buffer buffer = this.view.getBuffer();
            try {
                if (this.repeatCount != 1) {
                    buffer.beginCompoundEdit();
                }
                for (int i = 0; i < this.repeatCount; ++i) {
                    textArea.userInput(ch);
                }
            }
            finally {
                if (this.repeatCount != 1) {
                    buffer.endCompoundEdit();
                }
            }
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            recorder.recordInput(this.repeatCount, ch, textArea.isOverwriteEnabled());
        }
        this.repeatCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeReadNextChar(char ch) {
        int index;
        Buffer buffer = this.view.getBuffer();
        String charStr = MiscUtilities.charsToEscapes(String.valueOf(ch));
        while ((index = this.readNextChar.indexOf("__char__")) != -1) {
            this.readNextChar = this.readNextChar.substring(0, index) + '\'' + charStr + '\'' + this.readNextChar.substring(index + 8);
        }
        Macros.Recorder recorder = this.view.getMacroRecorder();
        if (recorder != null) {
            recorder.record(this.getRepeatCount(), this.readNextChar);
        }
        if (this.getRepeatCount() != 1) {
            try {
                buffer.beginCompoundEdit();
                BeanShell.eval(this.view, BeanShell.getNameSpace(), "for(int i = 1; i < " + this.getRepeatCount() + "; i++)\n{\n" + this.readNextChar + "\n}");
            }
            finally {
                buffer.endCompoundEdit();
            }
        } else {
            BeanShell.eval(this.view, BeanShell.getNameSpace(), this.readNextChar);
        }
        this.readNextChar = null;
        this.view.getStatus().setMessage(null);
    }
}

