/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class TextAreaDialog
extends EnhancedDialog {
    public TextAreaDialog(Frame frame, String title, String caption, Icon icon, String text) {
        super(frame, title, true);
        this.init(caption, icon, text);
    }

    public TextAreaDialog(Frame frame, String name, Throwable t) {
        this(frame, jEdit.getProperty(name + ".title"), jEdit.getProperty(name + ".message"), UIManager.getIcon("OptionPane.errorIcon"), MiscUtilities.throwableToString(t));
    }

    public TextAreaDialog(Dialog frame, String title, String caption, Icon icon, String text) {
        super(frame, title, true);
        this.init(caption, icon, text);
    }

    public TextAreaDialog(Dialog frame, String name, Throwable t) {
        this(frame, jEdit.getProperty(name + ".title"), jEdit.getProperty(name + ".message"), UIManager.getIcon("OptionPane.errorIcon"), MiscUtilities.throwableToString(t));
    }

    private void init(String caption, Icon icon, String text) {
        JPanel content = new JPanel(new BorderLayout(12, 12));
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        Box iconBox = new Box(1);
        iconBox.add(new JLabel(icon));
        iconBox.add(Box.createGlue());
        content.add("West", iconBox);
        JPanel centerPanel = new JPanel(new BorderLayout(6, 6));
        centerPanel.add("North", GUIUtilities.createMultilineLabel(caption));
        JTextArea textArea = new JTextArea(10, 80);
        textArea.setText(text);
        textArea.setLineWrap(true);
        textArea.setCaretPosition(0);
        centerPanel.add("Center", new JScrollPane(textArea));
        content.add("Center", centerPanel);
        Box buttons = new Box(0);
        buttons.add(Box.createGlue());
        JButton ok = new JButton(jEdit.getProperty("common.ok"));
        ok.addActionListener(new ActionHandler());
        buttons.add(ok);
        buttons.add(Box.createGlue());
        content.add("South", buttons);
        this.getRootPane().setDefaultButton(ok);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            TextAreaDialog.this.dispose();
        }
    }
}

