/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;

public class ToolBarManager {
    private Container top;
    private Container bottom;
    private ArrayList topToolBars = new ArrayList();
    private ArrayList bottomToolBars = new ArrayList();

    public ToolBarManager(Container top, Container bottom) {
        this.top = top;
        this.bottom = bottom;
    }

    public void addToolBar(int group, int layer, Component toolbar) {
        Entry entry = new Entry(layer, toolbar);
        if (group == 0) {
            this.addToolBar(this.top, this.topToolBars, entry);
        } else if (group == 1) {
            this.addToolBar(this.bottom, this.bottomToolBars, entry);
        } else {
            throw new InternalError("Invalid tool bar group");
        }
    }

    public void removeToolBar(Component toolbar) {
        this.removeToolBar(this.top, this.topToolBars, toolbar);
        this.removeToolBar(this.bottom, this.bottomToolBars, toolbar);
    }

    private void addToolBar(Container group, ArrayList toolbars, Entry entry) {
        for (int i = 0; i < toolbars.size(); ++i) {
            if (entry.layer <= ((Entry)toolbars.get((int)i)).layer) continue;
            toolbars.add(i, entry);
            group.add(entry.toolbar, i);
            return;
        }
        toolbars.add(entry);
        group.add(entry.toolbar);
    }

    private void removeToolBar(Container group, ArrayList toolbars, Component toolbar) {
        for (int i = 0; i < toolbars.size(); ++i) {
            if (toolbar != ((Entry)toolbars.get((int)i)).toolbar) continue;
            group.remove(toolbar);
            toolbars.remove(i);
            return;
        }
    }

    static class Entry {
        int layer;
        Component toolbar;

        Entry(int layer, Component toolbar) {
            this.layer = layer;
            this.toolbar = toolbar;
        }
    }
}

