/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;

public class ViewRegisters
extends EnhancedDialog {
    private JList registerList;
    private JTextArea contentTextArea;
    private JButton close;

    public ViewRegisters(View view) {
        super(view, jEdit.getProperty("view-registers.title"), true);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(content);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 12, 0, 0));
        JLabel label = new JLabel(jEdit.getProperty("view-registers.register"));
        label.setBorder(new EmptyBorder(0, 0, 3, 0));
        panel.add("North", label);
        DefaultListModel<Object> registerModel = new DefaultListModel<Object>();
        this.registerList = new JList(registerModel);
        this.registerList.setSelectionMode(0);
        this.registerList.setCellRenderer(new Renderer());
        Registers.Register[] registers = Registers.getRegisters();
        int index = 0;
        for (int i = 0; i < registers.length; ++i) {
            String value;
            Registers.Register reg = registers[i];
            if (reg == null || (value = ((Object)reg).toString()) == null || value.length() == 0) continue;
            registerModel.addElement(new Character((char)i));
        }
        if (registerModel.getSize() == 0) {
            registerModel.addElement(jEdit.getProperty("view-registers.none"));
        }
        panel.add("Center", new JScrollPane(this.registerList));
        content.add("West", panel);
        panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(0, 12, 0, 0));
        label = new JLabel(jEdit.getProperty("view-registers.contents"));
        label.setBorder(new EmptyBorder(0, 0, 3, 0));
        panel.add("North", label);
        this.contentTextArea = new JTextArea(10, 80);
        this.contentTextArea.setEditable(false);
        panel.add("Center", new JScrollPane(this.contentTextArea));
        content.add("Center", panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.close = new JButton(jEdit.getProperty("common.close"));
        this.close.addActionListener(new ActionHandler());
        panel.add(Box.createGlue());
        panel.add(this.close);
        panel.add(Box.createGlue());
        this.getRootPane().setDefaultButton(this.close);
        content.add("South", panel);
        this.registerList.addListSelectionListener(new ListHandler());
        this.registerList.setSelectedIndex(index);
        this.pack();
        this.setLocationRelativeTo(view);
        this.setVisible(true);
    }

    public void ok() {
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    class ListHandler
    implements ListSelectionListener {
        ListHandler() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            Object value = ViewRegisters.this.registerList.getSelectedValue();
            if (!(value instanceof Character)) {
                return;
            }
            char name = ((Character)value).charValue();
            Registers.Register reg = Registers.getRegister(name);
            if (reg == null) {
                return;
            }
            ViewRegisters.this.contentTextArea.setText(((Object)reg).toString());
            ViewRegisters.this.contentTextArea.setCaretPosition(0);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ViewRegisters.this.close) {
                ViewRegisters.this.cancel();
            }
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof Character) {
                char name = ((Character)value).charValue();
                String label = name == '\n' ? "\n" : (name == '\t' ? "\t" : (name == '$' ? jEdit.getProperty("view-registers.clipboard") : (name == '%' ? jEdit.getProperty("view-registers.selection") : String.valueOf(name))));
                this.setText(label);
            }
            return this;
        }
    }
}

