/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class HelpIndex {
    private static Object IGNORE = new Object();
    private HashMap words = new HashMap();
    private ArrayList files = new ArrayList();

    public HelpIndex() {
        this.ignoreWord("a");
        this.ignoreWord("an");
        this.ignoreWord("and");
        this.ignoreWord("are");
        this.ignoreWord("as");
        this.ignoreWord("be");
        this.ignoreWord("by");
        this.ignoreWord("can");
        this.ignoreWord("do");
        this.ignoreWord("for");
        this.ignoreWord("from");
        this.ignoreWord("how");
        this.ignoreWord("i");
        this.ignoreWord("if");
        this.ignoreWord("in");
        this.ignoreWord("is");
        this.ignoreWord("it");
        this.ignoreWord("not");
        this.ignoreWord("of");
        this.ignoreWord("on");
        this.ignoreWord("or");
        this.ignoreWord("s");
        this.ignoreWord("that");
        this.ignoreWord("the");
        this.ignoreWord("this");
        this.ignoreWord("to");
        this.ignoreWord("will");
        this.ignoreWord("with");
        this.ignoreWord("you");
    }

    public void indexEditorHelp() {
        try {
            String jEditHome = jEdit.getJEditHome();
            if (jEditHome != null) {
                this.indexDirectory(MiscUtilities.constructPath(jEditHome, "doc", "users-guide"));
                this.indexDirectory(MiscUtilities.constructPath(jEditHome, "doc", "FAQ"));
                this.indexDirectory(MiscUtilities.constructPath(jEditHome, "doc", "news42"));
            }
        }
        catch (Throwable e) {
            Log.log(9, this, "Error indexing editor help");
            Log.log(9, this, e);
        }
        PluginJAR[] jars = jEdit.getPluginJARs();
        for (int i = 0; i < jars.length; ++i) {
            try {
                this.indexJAR(jars[i].getZipFile());
                continue;
            }
            catch (Throwable e) {
                Log.log(9, this, "Error indexing JAR: " + jars[i].getPath());
                Log.log(9, this, e);
            }
        }
        Log.log(1, this, "Indexed " + this.words.size() + " words");
    }

    public void indexDirectory(String dir2) throws Exception {
        String[] files = VFSManager.getFileVFS()._listDirectory(null, dir2, "*.{html,txt}", true, null);
        for (int i = 0; i < files.length; ++i) {
            this.indexURL(files[i]);
        }
    }

    public void indexJAR(ZipFile jar) throws Exception {
        Enumeration<? extends ZipEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            String lname = name.toLowerCase();
            if (!lname.endsWith(".html")) continue;
            String url = "jeditresource:/" + MiscUtilities.getFileName(jar.getName()) + "!/" + name;
            Log.log(1, this, url);
            this.indexStream(jar.getInputStream(entry), url);
        }
    }

    public void indexURL(String url) throws Exception {
        InputStream _in;
        if (MiscUtilities.isURL(url)) {
            _in = new URL(url).openStream();
        } else {
            _in = new FileInputStream(url);
            url = "file:" + url;
        }
        this.indexStream(_in, url);
    }

    public Word lookupWord(String word) {
        Object o = this.words.get(word);
        if (o == IGNORE) {
            return null;
        }
        return (Word)o;
    }

    public HelpFile getFile(int index) {
        return (HelpFile)this.files.get(index);
    }

    private void ignoreWord(String word) {
        this.words.put(word, IGNORE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexStream(InputStream _in, String fileName) throws Exception {
        HelpFile file = new HelpFile(fileName);
        this.files.add(file);
        int index = this.files.size() - 1;
        StringBuffer titleText = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(_in));
        try {
            int c;
            StringBuffer word = new StringBuffer();
            boolean insideTag = false;
            boolean insideEntity = false;
            boolean title = false;
            while ((c = in.read()) != -1) {
                char ch = (char)c;
                if (insideTag) {
                    if (ch == '>') {
                        if (word.toString().equals("title")) {
                            title = true;
                        }
                        insideTag = false;
                        word.setLength(0);
                        continue;
                    }
                    word.append(ch);
                    continue;
                }
                if (insideEntity) {
                    if (ch != ';') continue;
                    insideEntity = false;
                    continue;
                }
                if (ch == '<') {
                    if (title) {
                        title = false;
                    }
                    if (word.length() != 0) {
                        this.addWord(word.toString(), index, title);
                        word.setLength(0);
                    }
                    insideTag = true;
                    continue;
                }
                if (ch == '&') {
                    insideEntity = true;
                    continue;
                }
                if (title) {
                    titleText.append(ch);
                    continue;
                }
                if (!Character.isLetterOrDigit(ch)) {
                    if (word.length() == 0) continue;
                    this.addWord(word.toString(), index, title);
                    word.setLength(0);
                    continue;
                }
                word.append(ch);
            }
        }
        finally {
            in.close();
        }
        file.title = titleText.length() == 0 ? fileName : titleText.toString();
    }

    private void addWord(String word, int file, boolean title) {
        Object o = this.words.get(word = word.toLowerCase());
        if (o == IGNORE) {
            return;
        }
        if (o == null) {
            this.words.put(word, new Word(word, file, title));
        } else {
            ((Word)o).addOccurrence(file, title);
        }
    }

    static class HelpFile {
        String file;
        String title;

        HelpFile(String file) {
            this.file = file;
        }

        public String toString() {
            return this.title;
        }

        public boolean equals(Object o) {
            if (o instanceof HelpFile) {
                return ((HelpFile)o).file.equals(this.file);
            }
            return false;
        }
    }

    static class Word {
        static final int TITLE_OCCUR = 10;
        String word;
        int occurCount = 0;
        Occurrence[] occurrences;

        Word(String word, int file, boolean title) {
            this.word = word;
            this.occurrences = new Occurrence[5];
            this.addOccurrence(file, title);
        }

        void addOccurrence(int file, boolean title) {
            for (int i = 0; i < this.occurCount; ++i) {
                if (this.occurrences[i].file != file) continue;
                this.occurrences[i].count = this.occurrences[i].count + (title ? 10 : 1);
                return;
            }
            if (this.occurCount >= this.occurrences.length) {
                Occurrence[] newOccur = new Occurrence[this.occurrences.length * 2];
                System.arraycopy(this.occurrences, 0, newOccur, 0, this.occurCount);
                this.occurrences = newOccur;
            }
            this.occurrences[this.occurCount++] = new Occurrence(file, title);
        }

        static class Occurrence {
            int file;
            int count;

            Occurrence(int file, boolean title) {
                this.file = file;
                this.count = title ? 10 : 1;
            }
        }
    }
}

