/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import com.microstar.xml.HandlerBase;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Stack;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

class HelpTOCPanel
extends JPanel {
    private HelpViewer helpViewer;
    private DefaultTreeModel tocModel;
    private DefaultMutableTreeNode tocRoot;
    private JTree toc;
    private Hashtable nodes;

    HelpTOCPanel(HelpViewer helpViewer) {
        super(new BorderLayout());
        this.helpViewer = helpViewer;
        this.nodes = new Hashtable();
        this.toc = new TOCTree();
        if (!OperatingSystem.isMacOSLF()) {
            this.toc.putClientProperty("JTree.lineStyle", "Angled");
        }
        this.toc.setCellRenderer(new TOCCellRenderer());
        this.toc.setEditable(false);
        this.toc.setShowsRootHandles(true);
        this.add("Center", new JScrollPane(this.toc));
        this.load();
    }

    void selectNode(String shortURL) {
        if (this.tocModel == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.nodes.get(shortURL);
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(this.tocModel.getPathToRoot(node));
        this.toc.expandPath(path);
        this.toc.setSelectionPath(path);
        this.toc.scrollPathToVisible(path);
    }

    void load() {
        DefaultTreeModel empty = new DefaultTreeModel(new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.loading")));
        this.toc.setModel(empty);
        this.toc.setRootVisible(true);
        VFSManager.runInWorkThread(new Runnable(){

            public void run() {
                HelpTOCPanel.this.createTOC();
                HelpTOCPanel.this.tocModel.reload(HelpTOCPanel.this.tocRoot);
                HelpTOCPanel.this.toc.setModel(HelpTOCPanel.this.tocModel);
                HelpTOCPanel.this.toc.setRootVisible(false);
                for (int i = 0; i < HelpTOCPanel.this.tocRoot.getChildCount(); ++i) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)HelpTOCPanel.this.tocRoot.getChildAt(i);
                    HelpTOCPanel.this.toc.expandPath(new TreePath(node.getPath()));
                }
                if (HelpTOCPanel.this.helpViewer.getShortURL() != null) {
                    HelpTOCPanel.this.selectNode(HelpTOCPanel.this.helpViewer.getShortURL());
                }
            }
        });
    }

    private DefaultMutableTreeNode createNode(String href, String title) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new HelpNode(href, title), true);
        this.nodes.put(href, node);
        return node;
    }

    private void createTOC() {
        EditPlugin[] plugins = jEdit.getPlugins();
        Arrays.sort(plugins, new PluginCompare());
        this.tocRoot = new DefaultMutableTreeNode();
        this.tocRoot.add(this.createNode("welcome.html", jEdit.getProperty("helpviewer.toc.welcome")));
        this.tocRoot.add(this.createNode("README.txt", jEdit.getProperty("helpviewer.toc.readme")));
        this.tocRoot.add(this.createNode("CHANGES.txt", jEdit.getProperty("helpviewer.toc.changes")));
        this.tocRoot.add(this.createNode("TODO.txt", jEdit.getProperty("helpviewer.toc.todo")));
        this.tocRoot.add(this.createNode("COPYING.txt", jEdit.getProperty("helpviewer.toc.copying")));
        this.tocRoot.add(this.createNode("COPYING.DOC.txt", jEdit.getProperty("helpviewer.toc.copying-doc")));
        this.tocRoot.add(this.createNode("Apache.LICENSE.txt", jEdit.getProperty("helpviewer.toc.copying-apache")));
        this.tocRoot.add(this.createNode("COPYING.PLUGINS.txt", jEdit.getProperty("helpviewer.toc.copying-plugins")));
        this.loadTOC(this.tocRoot, "news42/toc.xml");
        this.loadTOC(this.tocRoot, "users-guide/toc.xml");
        this.loadTOC(this.tocRoot, "FAQ/toc.xml");
        this.loadTOC(this.tocRoot, "api/toc.xml");
        DefaultMutableTreeNode pluginTree = new DefaultMutableTreeNode(jEdit.getProperty("helpviewer.toc.plugins"), true);
        for (int i = 0; i < plugins.length; ++i) {
            EditPlugin plugin = plugins[i];
            String name = plugin.getClassName();
            String docs = jEdit.getProperty("plugin." + name + ".docs");
            String label = jEdit.getProperty("plugin." + name + ".name");
            if (docs == null || label == null || docs == null) continue;
            String path = plugin.getPluginJAR().getClassLoader().getResourceAsPath(docs);
            pluginTree.add(this.createNode(path, label));
        }
        if (pluginTree.getChildCount() != 0) {
            this.tocRoot.add(pluginTree);
        } else {
            pluginTree = null;
        }
        this.tocModel = new DefaultTreeModel(this.tocRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void loadTOC(DefaultMutableTreeNode root, String path) {
        block14: {
            TOCHandler h = new TOCHandler(root, MiscUtilities.getParentOfPath(path));
            XmlParser parser = new XmlParser();
            Reader in = null;
            parser.setHandler(h);
            in = new InputStreamReader(new URL(this.helpViewer.getBaseURL() + '/' + path).openStream());
            parser.parse(null, null, in);
            Object var10_6 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block14;
            }
            catch (IOException io) {
                Log.log(9, this, io);
            }
            break block14;
            {
                catch (XmlException xe) {
                    int line = xe.getLine();
                    String message = xe.getMessage();
                    Log.log(9, this, path + ':' + line + ": " + message);
                    Object var10_7 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                    }
                    break block14;
                }
                catch (Exception e) {
                    Log.log(9, this, e);
                    Object var10_8 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (IOException io) {
                        Log.log(9, this, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, this, io);
                }
                throw throwable;
            }
        }
    }

    static class PluginCompare
    implements Comparator {
        PluginCompare() {
        }

        public int compare(Object o1, Object o2) {
            EditPlugin p1 = (EditPlugin)o1;
            EditPlugin p2 = (EditPlugin)o2;
            return MiscUtilities.compareStrings(jEdit.getProperty("plugin." + p1.getClassName() + ".name"), jEdit.getProperty("plugin." + p2.getClassName() + ".name"), true);
        }
    }

    class TOCCellRenderer
    extends DefaultTreeCellRenderer {
        EmptyBorder border = new EmptyBorder(1, 0, 1, 1);

        TOCCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            this.setIcon(leaf ? FileCellRenderer.fileIcon : (expanded ? FileCellRenderer.openDirIcon : FileCellRenderer.dirIcon));
            this.setBorder(this.border);
            return this;
        }
    }

    class TOCTree
    extends JTree {
        TOCTree() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        public final String getToolTipText(MouseEvent evt) {
            Rectangle cellRect;
            TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
            if (path != null && (cellRect = this.getPathBounds(path)) != null && !this.cellRectIsVisible(cellRect)) {
                return path.getLastPathComponent().toString();
            }
            return null;
        }

        protected void processMouseEvent(MouseEvent evt) {
            switch (evt.getID()) {
                case 500: {
                    TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
                    if (path != null) {
                        Object obj;
                        if (!this.isPathSelected(path)) {
                            this.setSelectionPath(path);
                        }
                        if (!((obj = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof HelpNode)) {
                            this.expandPath(path);
                            return;
                        }
                        HelpNode node = (HelpNode)obj;
                        HelpTOCPanel.this.helpViewer.gotoURL(node.href, true);
                    }
                    super.processMouseEvent(evt);
                    break;
                }
                default: {
                    super.processMouseEvent(evt);
                }
            }
        }

        private boolean cellRectIsVisible(Rectangle cellRect) {
            Rectangle vr = this.getVisibleRect();
            return vr.contains(cellRect.x, cellRect.y) && vr.contains(cellRect.x + cellRect.width, cellRect.y + cellRect.height);
        }
    }

    class TOCHandler
    extends HandlerBase {
        String dir;
        private String tag;
        private String title;
        private String href;
        private DefaultMutableTreeNode node;
        private Stack nodes = new Stack();

        TOCHandler(DefaultMutableTreeNode root, String dir2) {
            this.node = root;
            this.dir = dir2;
        }

        public void attribute(String aname, String value, boolean isSpecified) {
            if (aname.equals("HREF")) {
                this.href = value;
            }
        }

        public void charData(char[] c, int off, int len) {
            if (this.tag.equals("TITLE")) {
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < len; ++i) {
                    char ch = c[off + i];
                    if (ch != ' ' && Character.isWhitespace(ch)) continue;
                    buf.append(ch);
                }
                this.title = buf.toString();
            }
        }

        public void startElement(String name) {
            this.tag = name;
        }

        public void endElement(String name) {
            if (name == null) {
                return;
            }
            if (name.equals("TITLE")) {
                DefaultMutableTreeNode newNode = HelpTOCPanel.this.createNode(this.dir + this.href, this.title);
                this.node.add(newNode);
                this.nodes.push(this.node);
                this.node = newNode;
            } else if (name.equals("ENTRY")) {
                this.node = (DefaultMutableTreeNode)this.nodes.pop();
            }
        }
    }

    static class HelpNode {
        String href;
        String title;

        HelpNode(String href, String title) {
            this.href = href;
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

