/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.help;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.help.HelpSearchPanel;
import org.gjt.sp.jedit.help.HelpTOCPanel;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.util.Log;

public class HelpViewer
extends JFrame
implements EBComponent {
    private String baseURL;
    private String shortURL;
    private JButton back;
    private JButton forward;
    private JEditorPane viewer;
    private JLabel title;
    private JSplitPane splitter;
    private String[] history;
    private int historyPos;
    private HelpTOCPanel toc;
    private boolean queuedTOCReload;

    public HelpViewer() {
        this("welcome.html");
    }

    public HelpViewer(URL url) {
        this(url.toString());
    }

    public HelpViewer(String url) {
        super(jEdit.getProperty("helpviewer.title"));
        this.setIconImage(GUIUtilities.getEditorIcon());
        try {
            this.baseURL = new File(MiscUtilities.constructPath(jEdit.getJEditHome(), "doc")).toURL().toString();
        }
        catch (MalformedURLException mu) {
            Log.log(9, this, mu);
        }
        this.history = new String[25];
        ActionHandler actionListener = new ActionHandler();
        JTabbedPane tabs = new JTabbedPane();
        this.toc = new HelpTOCPanel(this);
        tabs.addTab(jEdit.getProperty("helpviewer.toc.label"), this.toc);
        tabs.addTab(jEdit.getProperty("helpviewer.search.label"), new HelpSearchPanel(this));
        tabs.setMinimumSize(new Dimension(0, 0));
        JPanel rightPanel = new JPanel(new BorderLayout());
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        this.title = new JLabel();
        toolBar.add(this.title);
        toolBar.add(Box.createGlue());
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        buttons.setBorder(new EmptyBorder(0, 12, 0, 0));
        this.back = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("helpviewer.back.icon")));
        this.back.setToolTipText(jEdit.getProperty("helpviewer.back.label"));
        this.back.addActionListener(actionListener);
        toolBar.add(this.back);
        this.forward = new RolloverButton(GUIUtilities.loadIcon(jEdit.getProperty("helpviewer.forward.icon")));
        this.forward.addActionListener(actionListener);
        this.forward.setToolTipText(jEdit.getProperty("helpviewer.forward.label"));
        toolBar.add(this.forward);
        this.back.setPreferredSize(this.forward.getPreferredSize());
        rightPanel.add("North", toolBar);
        this.viewer = new JEditorPane();
        this.viewer.setEditable(false);
        this.viewer.addHyperlinkListener(new LinkHandler());
        this.viewer.setFont(new Font("Monospaced", 0, 12));
        this.viewer.addPropertyChangeListener(new PropertyChangeHandler());
        rightPanel.add("Center", new JScrollPane(this.viewer));
        this.splitter = new JSplitPane(1, tabs, rightPanel);
        this.splitter.setBorder(null);
        this.getContentPane().add("Center", this.splitter);
        this.gotoURL(url, true);
        this.setDefaultCloseOperation(2);
        this.getRootPane().setPreferredSize(new Dimension(750, 500));
        this.pack();
        GUIUtilities.loadGeometry(this, "helpviewer");
        EditBus.addToBus(this);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.splitter.setDividerLocation(jEdit.getIntegerProperty("helpviewer.splitter", 250));
                HelpViewer.this.viewer.requestFocus();
            }
        });
    }

    public void gotoURL(String url, boolean addToHistory) {
        String shortURL;
        if (MiscUtilities.isURL(url)) {
            if (url.startsWith(this.baseURL)) {
                shortURL = url.substring(this.baseURL.length());
                if (shortURL.startsWith("/")) {
                    shortURL = shortURL.substring(1);
                }
            } else {
                shortURL = url;
            }
        } else {
            shortURL = url;
            url = this.baseURL.endsWith("/") ? this.baseURL + url : this.baseURL + '/' + url;
        }
        this.viewer.setCursor(Cursor.getDefaultCursor());
        URL _url = null;
        try {
            _url = new URL(url);
            if (!_url.equals(this.viewer.getPage())) {
                this.title.setText(jEdit.getProperty("helpviewer.loading"));
            }
            this.viewer.setPage(_url);
            if (addToHistory) {
                this.history[this.historyPos] = url;
                if (this.historyPos + 1 == this.history.length) {
                    System.arraycopy(this.history, 1, this.history, 0, this.history.length - 1);
                    this.history[this.historyPos] = null;
                } else {
                    ++this.historyPos;
                }
            }
        }
        catch (MalformedURLException mf) {
            Log.log(9, this, mf);
            Object[] args = new String[]{url, mf.getMessage()};
            GUIUtilities.error(this, "badurl", args);
            return;
        }
        catch (IOException io) {
            Log.log(9, this, io);
            Object[] args = new String[]{url, io.toString()};
            GUIUtilities.error(this, "read-error", args);
            return;
        }
        this.shortURL = shortURL;
        if (shortURL != null) {
            this.toc.selectNode(shortURL);
        }
    }

    public void dispose() {
        EditBus.removeFromBus(this);
        jEdit.setIntegerProperty("helpviewer.splitter", this.splitter.getDividerLocation());
        GUIUtilities.saveGeometry(this, "helpviewer");
        super.dispose();
    }

    public void handleMessage(EBMessage msg) {
        PluginUpdate pmsg;
        if (msg instanceof PluginUpdate && ((pmsg = (PluginUpdate)msg).getWhat() == PluginUpdate.LOADED || pmsg.getWhat() == PluginUpdate.UNLOADED) && !pmsg.isExiting()) {
            if (!this.queuedTOCReload) {
                this.queueTOCReload();
            }
            this.queuedTOCReload = true;
        }
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    String getShortURL() {
        return this.shortURL;
    }

    public void queueTOCReload() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HelpViewer.this.queuedTOCReload = false;
                HelpViewer.this.toc.load();
            }
        });
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("page".equals(evt.getPropertyName())) {
                String titleStr = (String)HelpViewer.this.viewer.getDocument().getProperty("title");
                if (titleStr == null) {
                    titleStr = MiscUtilities.getFileName(HelpViewer.this.viewer.getPage().toString());
                }
                HelpViewer.this.title.setText(titleStr);
            }
        }
    }

    class LinkHandler
    implements HyperlinkListener {
        LinkHandler() {
        }

        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (evt instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)HelpViewer.this.viewer.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)evt);
                } else {
                    URL url = evt.getURL();
                    if (url != null) {
                        HelpViewer.this.gotoURL(url.toString(), true);
                    }
                }
            } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                HelpViewer.this.viewer.setCursor(Cursor.getPredefinedCursor(12));
            } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                HelpViewer.this.viewer.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == HelpViewer.this.back) {
                if (HelpViewer.this.historyPos <= 1) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    String url = HelpViewer.this.history[--HelpViewer.this.historyPos - 1];
                    HelpViewer.this.gotoURL(url, false);
                }
            } else if (source == HelpViewer.this.forward) {
                if (HelpViewer.this.history.length - HelpViewer.this.historyPos <= 1) {
                    HelpViewer.this.getToolkit().beep();
                } else {
                    String url = HelpViewer.this.history[HelpViewer.this.historyPos];
                    if (url == null) {
                        HelpViewer.this.getToolkit().beep();
                    } else {
                        HelpViewer.this.historyPos++;
                        HelpViewer.this.gotoURL(url, false);
                    }
                }
            }
        }
    }
}

