/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import bsh.UtilEvalError;
import com.microstar.xml.XmlException;
import com.microstar.xml.XmlParser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import org.gjt.sp.jedit.Abbrevs;
import org.gjt.sp.jedit.ActionContext;
import org.gjt.sp.jedit.ActionSet;
import org.gjt.sp.jedit.Autosave;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.EditServer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.JARClassLoader;
import org.gjt.sp.jedit.Macros;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.ModeCatalogHandler;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.PropertyManager;
import org.gjt.sp.jedit.Registers;
import org.gjt.sp.jedit.ServiceManager;
import org.gjt.sp.jedit.SettingsReloader;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.KillRing;
import org.gjt.sp.jedit.gui.ActionBar;
import org.gjt.sp.jedit.gui.CloseDialog;
import org.gjt.sp.jedit.gui.DefaultInputHandler;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.gui.ErrorListDialog;
import org.gjt.sp.jedit.gui.FilesChangedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.TipOfTheDay;
import org.gjt.sp.jedit.help.HelpViewer;
import org.gjt.sp.jedit.io.FavoritesVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.DynamicMenuChanged;
import org.gjt.sp.jedit.msg.EditorExitRequested;
import org.gjt.sp.jedit.msg.EditorExiting;
import org.gjt.sp.jedit.msg.EditorStarted;
import org.gjt.sp.jedit.msg.PluginUpdate;
import org.gjt.sp.jedit.msg.PropertiesChanged;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.syntax.XModeHandler;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class jEdit {
    private static String jEditHome;
    private static String settingsDirectory;
    private static String jarCacheDirectory;
    private static long propsModTime;
    private static PropertyManager propMgr;
    private static EditServer server;
    private static boolean background;
    private static ActionContext actionContext;
    private static ActionSet builtInActionSet;
    private static Vector pluginErrors;
    private static Object pluginErrorLock;
    private static Vector jars;
    private static Vector modes;
    private static boolean saveCaret;
    private static InputHandler inputHandler;
    private static boolean sortBuffers;
    private static boolean sortByName;
    private static int bufferCount;
    private static Buffer buffersFirst;
    private static Buffer buffersLast;
    private static Map bufferHash;
    private static Object bufferListLock;
    private static int viewCount;
    private static View viewsFirst;
    private static View viewsLast;
    private static View activeView;
    private static boolean startupDone;
    private static Thread mainThread;
    static /* synthetic */ Class class$org$gjt$sp$jedit$jEdit;

    public static String getVersion() {
        return MiscUtilities.buildToVersion(jEdit.getBuild());
    }

    public static String getBuild() {
        return "04.02.99.00";
    }

    public static void main(String[] args) {
        String path;
        File file;
        BufferedWriter stream;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.compareTo("1.3") < 0) {
            System.err.println("You are running Java version " + javaVersion + ".");
            System.err.println("jEdit requires Java 1.3 or later.");
            System.exit(1);
        }
        mainThread = Thread.currentThread();
        settingsDirectory = ".jedit";
        background = OperatingSystem.isMacOS();
        boolean endOpts = false;
        int level = 7;
        String portFile = "server";
        boolean restore = true;
        boolean newView = true;
        boolean newPlainView = false;
        boolean gui = true;
        boolean loadPlugins = true;
        boolean runStartupScripts = true;
        boolean quit = false;
        boolean wait = false;
        String userDir = System.getProperty("user.dir");
        String scriptFile = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.length() == 0) {
                args[i] = null;
                continue;
            }
            if (!arg.startsWith("-") || endOpts) continue;
            if (arg.equals("--")) {
                endOpts = true;
            } else if (arg.equals("-usage")) {
                jEdit.version();
                System.err.println();
                jEdit.usage();
                System.exit(1);
            } else if (arg.equals("-version")) {
                jEdit.version();
                System.exit(1);
            } else if (arg.startsWith("-log=")) {
                try {
                    level = Integer.parseInt(arg.substring("-log=".length()));
                }
                catch (NumberFormatException nf) {
                    System.err.println("Malformed option: " + arg);
                }
            } else if (arg.equals("-nosettings")) {
                settingsDirectory = null;
            } else if (arg.startsWith("-settings=")) {
                settingsDirectory = arg.substring(10);
            } else if (arg.startsWith("-noserver")) {
                portFile = null;
            } else if (arg.equals("-server")) {
                portFile = "server";
            } else if (arg.startsWith("-server=")) {
                portFile = arg.substring(8);
            } else if (arg.startsWith("-background")) {
                background = true;
            } else if (arg.startsWith("-nobackground")) {
                background = false;
            } else if (arg.equals("-gui")) {
                gui = true;
            } else if (arg.equals("-nogui")) {
                gui = false;
            } else if (arg.equals("-newview")) {
                newView = true;
            } else if (arg.equals("-newplainview")) {
                newPlainView = true;
            } else if (arg.equals("-reuseview")) {
                newView = false;
                newPlainView = false;
            } else if (arg.equals("-restore")) {
                restore = true;
            } else if (arg.equals("-norestore")) {
                restore = false;
            } else if (arg.equals("-plugins")) {
                loadPlugins = true;
            } else if (arg.equals("-noplugins")) {
                loadPlugins = false;
            } else if (arg.equals("-startupscripts")) {
                runStartupScripts = true;
            } else if (arg.equals("-nostartupscripts")) {
                runStartupScripts = false;
            } else if (arg.startsWith("-run=")) {
                scriptFile = arg.substring(5);
            } else if (arg.equals("-wait")) {
                wait = true;
            } else if (arg.equals("-quit")) {
                quit = true;
            } else {
                System.err.println("Unknown option: " + arg);
                jEdit.usage();
                System.exit(1);
            }
            args[i] = null;
        }
        if (settingsDirectory != null) {
            settingsDirectory = MiscUtilities.constructPath(System.getProperty("user.home"), settingsDirectory);
            settingsDirectory = MiscUtilities.resolveSymlinks(settingsDirectory);
        }
        portFile = settingsDirectory != null && portFile != null ? MiscUtilities.constructPath(settingsDirectory, portFile) : null;
        Log.init(true, level);
        if (portFile != null && new File(portFile).exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(portFile));
                String check = in.readLine();
                if (!check.equals("b")) {
                    throw new Exception("Wrong port file format");
                }
                int port = Integer.parseInt(in.readLine());
                int key = Integer.parseInt(in.readLine());
                Socket socket = new Socket(InetAddress.getByName("127.0.0.1"), port);
                DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                out.writeInt(key);
                String script = quit ? "socket.close();\njEdit.exit(null,true);\n" : jEdit.makeServerScript(wait, restore, newView, newPlainView, args, scriptFile);
                out.writeUTF(script);
                Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Waiting for server");
                try {
                    socket.getInputStream().read();
                }
                catch (Exception e) {
                    // empty catch block
                }
                in.close();
                out.close();
                System.exit(0);
            }
            catch (Exception e) {
                Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "An error occurred while connecting to the jEdit server instance.");
                Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "This probably means that jEdit crashed and/or exited abnormally");
                Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "the last time it was run.");
                Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "If you don't know what this means, don't worry.");
                Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
            }
        }
        if (quit) {
            System.exit(0);
        }
        if (!new File(settingsDirectory, "nosplash").exists()) {
            GUIUtilities.showSplashScreen();
        }
        if (settingsDirectory != null) {
            File _macrosDirectory;
            File _settingsDirectory = new File(settingsDirectory);
            if (!_settingsDirectory.exists()) {
                _settingsDirectory.mkdirs();
            }
            if (!(_macrosDirectory = new File(settingsDirectory, "macros")).exists()) {
                _macrosDirectory.mkdir();
            }
            String logPath = MiscUtilities.constructPath(settingsDirectory, "activity.log");
            jEdit.backupSettingsFile(new File(logPath));
            try {
                stream = new BufferedWriter(new FileWriter(logPath));
                String lineSep = System.getProperty("line.separator");
                stream.write("Log file created on " + new Date());
                stream.write(lineSep);
                stream.write("IMPORTANT:");
                stream.write(lineSep);
                stream.write("Because updating this file after every log message would kill");
                stream.write(lineSep);
                stream.write("performance, it will be *incomplete* unless you invoke the");
                stream.write(lineSep);
                stream.write("Utilities->Troubleshooting->Update Activity Log on Disk command!");
                stream.write(lineSep);
            }
            catch (Exception e) {
                e.printStackTrace();
                stream = null;
            }
        } else {
            stream = null;
        }
        Log.setLogWriter(stream);
        Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "jEdit version " + jEdit.getVersion());
        Log.log(3, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Settings directory is " + settingsDirectory);
        jEdit.initMisc();
        jEdit.initSystemProperties();
        GUIUtilities.advanceSplashProgress();
        GUIUtilities.init();
        BeanShell.init();
        if (jEditHome != null) {
            jEdit.initSiteProperties();
        }
        jEdit.initUserProperties();
        if (portFile != null) {
            server = new EditServer(portFile);
            if (!server.isOK()) {
                server = null;
            }
        } else if (background) {
            background = false;
            Log.log(7, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "You cannot specify both the -background and -noserver switches");
        }
        jEdit.initPLAF();
        VFSManager.init();
        jEdit.initResources();
        SearchAndReplace.load();
        GUIUtilities.advanceSplashProgress();
        if (loadPlugins) {
            jEdit.initPlugins();
        }
        HistoryModel.loadHistory();
        BufferHistory.load();
        KillRing.load();
        jEdit.propertiesChanged();
        GUIUtilities.advanceSplashProgress();
        sortBuffers = jEdit.getBooleanProperty("sortBuffers");
        sortByName = jEdit.getBooleanProperty("sortByName");
        jEdit.reloadModes();
        GUIUtilities.advanceSplashProgress();
        if (OperatingSystem.hasJava14()) {
            try {
                ClassLoader loader = (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getClassLoader();
                Class<?> clazz = loader != null ? loader.loadClass("org.gjt.sp.jedit.Java14") : Class.forName("org.gjt.sp.jedit.Java14");
                Method meth = clazz.getMethod("init", new Class[0]);
                meth.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
                System.exit(1);
            }
        }
        for (int i = 0; i < jars.size(); ++i) {
            ((PluginJAR)jars.elementAt(i)).activatePluginIfNecessary();
        }
        Macros.loadMacros();
        Macros.getMacroActionSet().initKeyBindings();
        if (runStartupScripts && jEditHome != null && (file = new File(path = MiscUtilities.constructPath(jEditHome, "startup"))).exists()) {
            jEdit.runStartupScripts(file);
        }
        if (runStartupScripts && settingsDirectory != null) {
            path = MiscUtilities.constructPath(settingsDirectory, "startup");
            file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            } else {
                jEdit.runStartupScripts(file);
            }
        }
        if (scriptFile != null) {
            scriptFile = MiscUtilities.constructPath(userDir, scriptFile);
            try {
                BeanShell.getNameSpace().setVariable("args", args);
            }
            catch (UtilEvalError e) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
            }
            BeanShell.runScript(null, scriptFile, null, false);
        }
        GUIUtilities.advanceSplashProgress();
        jEdit.finishStartup(gui, restore, userDir, args);
    }

    public static final Properties getProperties() {
        return propMgr.getProperties();
    }

    public static final String getProperty(String name) {
        return propMgr.getProperty(name);
    }

    public static final String getProperty(String name, String def) {
        String value = propMgr.getProperty(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    public static final String getProperty(String name, Object[] args) {
        if (name == null) {
            return null;
        }
        if (args == null) {
            return jEdit.getProperty(name);
        }
        String value = jEdit.getProperty(name);
        if (value == null) {
            return null;
        }
        return MessageFormat.format(value, args);
    }

    public static final boolean getBooleanProperty(String name) {
        return jEdit.getBooleanProperty(name, false);
    }

    public static final boolean getBooleanProperty(String name, boolean def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        if (value.equals("true") || value.equals("yes") || value.equals("on")) {
            return true;
        }
        if (value.equals("false") || value.equals("no") || value.equals("off")) {
            return false;
        }
        return def;
    }

    public static final int getIntegerProperty(String name, int def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nf) {
            return def;
        }
    }

    public static double getDoubleProperty(String name, double def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        try {
            return Double.parseDouble(value.trim());
        }
        catch (NumberFormatException nf) {
            return def;
        }
    }

    public static final Font getFontProperty(String name) {
        return jEdit.getFontProperty(name, null);
    }

    public static final Font getFontProperty(String name, Font def) {
        int style;
        int size;
        String family = jEdit.getProperty(name);
        String sizeString = jEdit.getProperty(name + "size");
        String styleString = jEdit.getProperty(name + "style");
        if (family == null || sizeString == null || styleString == null) {
            return def;
        }
        try {
            size = Integer.parseInt(sizeString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        try {
            style = Integer.parseInt(styleString);
        }
        catch (NumberFormatException nf) {
            return def;
        }
        return new Font(family, style, size);
    }

    public static Color getColorProperty(String name) {
        return jEdit.getColorProperty(name, Color.black);
    }

    public static Color getColorProperty(String name, Color def) {
        String value = jEdit.getProperty(name);
        if (value == null) {
            return def;
        }
        return GUIUtilities.parseColor(value, def);
    }

    public static void setColorProperty(String name, Color value) {
        jEdit.setProperty(name, GUIUtilities.getColorHexString(value));
    }

    public static final void setProperty(String name, String value) {
        propMgr.setProperty(name, value);
    }

    public static final void setTemporaryProperty(String name, String value) {
        propMgr.setTemporaryProperty(name, value);
    }

    public static final void setBooleanProperty(String name, boolean value) {
        jEdit.setProperty(name, value ? "true" : "false");
    }

    public static final void setIntegerProperty(String name, int value) {
        jEdit.setProperty(name, String.valueOf(value));
    }

    public static final void setDoubleProperty(String name, double value) {
        jEdit.setProperty(name, String.valueOf(value));
    }

    public static final void setFontProperty(String name, Font value) {
        jEdit.setProperty(name, value.getFamily());
        jEdit.setIntegerProperty(name + "size", value.getSize());
        jEdit.setIntegerProperty(name + "style", value.getStyle());
    }

    public static final void unsetProperty(String name) {
        propMgr.unsetProperty(name);
    }

    public static final void resetProperty(String name) {
        propMgr.resetProperty(name);
    }

    public static void propertiesChanged() {
        jEdit.initKeyBindings();
        Autosave.setInterval(jEdit.getIntegerProperty("autosave", 30));
        saveCaret = jEdit.getBooleanProperty("saveCaret");
        UIDefaults defaults = UIManager.getDefaults();
        Font font = jEdit.getFontProperty("view.font");
        defaults.put("TextArea.font", font);
        defaults.put("TextPane.font", font);
        ToolTipManager.sharedInstance().setEnabled(jEdit.getBooleanProperty("showTooltips"));
        jEdit.initProxy();
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            buffer.resetCachedProperties();
            buffer.propertiesChanged();
            buffer = buffer.next;
        }
        HistoryModel.propertiesChanged();
        KillRing.propertiesChanged();
        EditBus.send(new PropertiesChanged(null));
    }

    public static String[] getNotLoadedPluginJARs() {
        String userPluginDir;
        String systemPluginDir;
        String[] list;
        Vector returnValue = new Vector();
        if (jEditHome != null && (list = new File(systemPluginDir = MiscUtilities.constructPath(jEditHome, "jars")).list()) != null) {
            jEdit.getNotLoadedPluginJARs(returnValue, systemPluginDir, list);
        }
        if (settingsDirectory != null && (list = new File(userPluginDir = MiscUtilities.constructPath(settingsDirectory, "jars")).list()) != null) {
            jEdit.getNotLoadedPluginJARs(returnValue, userPluginDir, list);
        }
        Object[] _returnValue = new String[returnValue.size()];
        returnValue.copyInto(_returnValue);
        return _returnValue;
    }

    public static EditPlugin getPlugin(String name) {
        return jEdit.getPlugin(name, false);
    }

    public static EditPlugin getPlugin(String name, boolean loadIfNecessary) {
        EditPlugin[] plugins = jEdit.getPlugins();
        EditPlugin plugin = null;
        for (int i = 0; i < plugins.length; ++i) {
            if (plugins[i].getClassName().equals(name)) {
                plugin = plugins[i];
            }
            if (!loadIfNecessary || !(plugin instanceof EditPlugin.Deferred)) continue;
            plugin.getPluginJAR().activatePlugin();
            plugin = plugin.getPluginJAR().getPlugin();
            break;
        }
        return plugin;
    }

    public static EditPlugin[] getPlugins() {
        Vector<EditPlugin> vector = new Vector<EditPlugin>();
        for (int i = 0; i < jars.size(); ++i) {
            EditPlugin plugin = ((PluginJAR)jars.elementAt(i)).getPlugin();
            if (plugin == null) continue;
            vector.add(plugin);
        }
        Object[] array = new EditPlugin[vector.size()];
        vector.copyInto(array);
        return array;
    }

    public static PluginJAR[] getPluginJARs() {
        Object[] array = new PluginJAR[jars.size()];
        jars.copyInto(array);
        return array;
    }

    public static PluginJAR getPluginJAR(String path) {
        for (int i = 0; i < jars.size(); ++i) {
            PluginJAR jar = (PluginJAR)jars.elementAt(i);
            if (!jar.getPath().equals(path)) continue;
            return jar;
        }
        return null;
    }

    public static void addPluginJAR(String path) {
        EditPlugin.JAR jar = new EditPlugin.JAR(new File(path));
        jars.addElement(jar);
        jar.init();
        EditBus.send(new PluginUpdate(jar, PluginUpdate.LOADED, false));
        if (!jEdit.isMainThread()) {
            EditBus.send(new DynamicMenuChanged("plugins"));
            jEdit.initKeyBindings();
        }
    }

    private static void addPluginJARsFromDirectory(String directory) {
        Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Loading plugins from " + directory);
        File file = new File(directory);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        String[] plugins = file.list();
        if (plugins == null) {
            return;
        }
        for (int i = 0; i < plugins.length; ++i) {
            String plugin = plugins[i];
            if (!plugin.toLowerCase().endsWith(".jar")) continue;
            String path = MiscUtilities.constructPath(directory, plugin);
            if (plugin.equals("EditBuddy.jar") || plugin.equals("PluginManager.jar") || plugin.equals("Firewall.jar") || plugin.equals("Tidy.jar") || plugin.equals("DragAndDrop.jar")) {
                jEdit.pluginError(path, "plugin-error.obsolete", null);
                continue;
            }
            jEdit.addPluginJAR(path);
        }
    }

    public static void removePluginJAR(PluginJAR jar, boolean exit) {
        if (exit) {
            jar.uninit(true);
        } else {
            jar.uninit(false);
            jars.removeElement(jar);
            jEdit.initKeyBindings();
        }
        EditBus.send(new PluginUpdate(jar, PluginUpdate.UNLOADED, exit));
        if (!jEdit.isMainThread() && !exit) {
            EditBus.send(new DynamicMenuChanged("plugins"));
        }
    }

    public static ActionContext getActionContext() {
        return actionContext;
    }

    public static void addActionSet(ActionSet actionSet) {
        actionContext.addActionSet(actionSet);
    }

    public static void removeActionSet(ActionSet actionSet) {
        actionContext.removeActionSet(actionSet);
    }

    public static ActionSet getBuiltInActionSet() {
        return builtInActionSet;
    }

    public static ActionSet[] getActionSets() {
        return actionContext.getActionSets();
    }

    public static EditAction getAction(String name) {
        return actionContext.getAction(name);
    }

    public static ActionSet getActionSetForAction(String action) {
        return actionContext.getActionSetForAction(action);
    }

    public static ActionSet getActionSetForAction(EditAction action) {
        return actionContext.getActionSetForAction(action.getName());
    }

    public static EditAction[] getActions() {
        String[] names = actionContext.getActionNames();
        EditAction[] actions = new EditAction[names.length];
        for (int i = 0; i < actions.length; ++i) {
            actions[i] = actionContext.getAction(names[i]);
            if (actions[i] != null) continue;
            Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? jEdit.class$("org.gjt.sp.jedit.jEdit") : class$org$gjt$sp$jedit$jEdit, "wtf: " + names[i]);
        }
        return actions;
    }

    public static String[] getActionNames() {
        return actionContext.getActionNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void reloadModes() {
        block17: {
            File userCatalog;
            block16: {
                modes = new Vector(50);
                if (jEditHome == null) {
                    jEdit.loadModeCatalog("/modes/catalog", true);
                } else {
                    jEdit.loadModeCatalog(MiscUtilities.constructPath(jEditHome, "modes", "catalog"), false);
                }
                if (settingsDirectory == null) break block17;
                File userModeDir = new File(MiscUtilities.constructPath(settingsDirectory, "modes"));
                if (!userModeDir.exists()) {
                    userModeDir.mkdirs();
                }
                if (!(userCatalog = new File(MiscUtilities.constructPath(settingsDirectory, "modes", "catalog"))).exists()) {
                    FileWriter out = null;
                    out = new FileWriter(userCatalog);
                    out.write(jEdit.getProperty("defaultCatalog"));
                    out.close();
                    Object var5_3 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block16;
                    }
                    catch (IOException e) {}
                    break block16;
                    {
                        catch (IOException io) {
                            Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
                            var5_3 = null;
                            try {
                                if (out != null) {
                                    out.close();
                                }
                                break block16;
                            }
                            catch (IOException e) {}
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_4 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            jEdit.loadModeCatalog(userCatalog.getPath(), false);
        }
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            buffer.setMode();
            buffer = buffer.next;
        }
    }

    public static Mode getMode(String name) {
        for (int i = 0; i < modes.size(); ++i) {
            Mode mode = (Mode)modes.elementAt(i);
            if (!mode.getName().equals(name)) continue;
            return mode;
        }
        return null;
    }

    public static Mode[] getModes() {
        Object[] array = new Mode[modes.size()];
        modes.copyInto(array);
        return array;
    }

    public static Buffer openFiles(View view, String parent, String[] args) {
        Buffer retVal = null;
        Buffer lastBuffer = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg == null) continue;
            if (arg.startsWith("+line:") || arg.startsWith("+marker:")) {
                if (lastBuffer == null) continue;
                jEdit.gotoMarker(view, lastBuffer, arg);
                continue;
            }
            lastBuffer = jEdit.openFile(null, parent, arg, false, null);
            if (retVal != null || lastBuffer == null) continue;
            retVal = lastBuffer;
        }
        if (view != null && retVal != null) {
            view.setBuffer(retVal);
        }
        return retVal;
    }

    public static Buffer openFile(View view, String path) {
        return jEdit.openFile(view, null, path, false, new Hashtable());
    }

    public static Buffer openFile(View view, String parent, String path, boolean readOnly, boolean newFile) {
        return jEdit.openFile(view, parent, path, newFile, new Hashtable());
    }

    public static Buffer openFile(View view, String parent, String path, boolean readOnly, boolean newFile, Hashtable props) {
        return jEdit.openFile(view, parent, path, newFile, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openFile(View view, String parent, String path, boolean newFile, Hashtable props) {
        Buffer newBuffer;
        PerspectiveManager.setPerspectiveDirty(true);
        if (view != null && parent == null) {
            parent = view.getBuffer().getDirectory();
        }
        if (MiscUtilities.isURL(path) && MiscUtilities.getProtocolOfURL(path).equals("file")) {
            path = path.substring(5);
        }
        path = MiscUtilities.constructPath(parent, path);
        Object object = bufferListLock;
        synchronized (object) {
            BufferHistory.Entry entry;
            Buffer buffer = jEdit.getBuffer(path);
            if (buffer != null) {
                if (view != null) {
                    view.setBuffer(buffer);
                }
                return buffer;
            }
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            if ((entry = BufferHistory.getEntry(path)) != null && saveCaret && props.get("Buffer__caret") == null) {
                props.put("Buffer__caret", new Integer(entry.caret));
            }
            if (entry != null && props.get("encoding") == null && entry.encoding != null) {
                props.put("encoding", entry.encoding);
            }
            if (!(newBuffer = new Buffer(path, newFile, false, props)).load(view, false)) {
                return null;
            }
            jEdit.addBufferToList(newBuffer);
        }
        EditBus.send(new BufferUpdate(newBuffer, view, BufferUpdate.CREATED));
        if (view != null) {
            view.setBuffer(newBuffer);
        }
        return newBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer openTemporary(View view, String parent, String path, boolean newFile) {
        if (view != null && parent == null) {
            parent = view.getBuffer().getDirectory();
        }
        if (MiscUtilities.isURL(path) && MiscUtilities.getProtocolOfURL(path).equals("file")) {
            path = path.substring(5);
        }
        path = MiscUtilities.constructPath(parent, path);
        Object object = bufferListLock;
        synchronized (object) {
            Buffer buffer = jEdit.getBuffer(path);
            if (buffer != null) {
                return buffer;
            }
            buffer = new Buffer(path, newFile, true, new Hashtable());
            if (!buffer.load(view, false)) {
                return null;
            }
            return buffer;
        }
    }

    public static void commitTemporary(Buffer buffer) {
        if (!buffer.isTemporary()) {
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        jEdit.addBufferToList(buffer);
        buffer.commitTemporary();
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.CREATED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOAD_STARTED));
        EditBus.send(new BufferUpdate(buffer, null, BufferUpdate.LOADED));
    }

    public static Buffer newFile(View view) {
        String path;
        if (view != null && view.getBuffer() != null) {
            path = view.getBuffer().getDirectory();
            VFS vfs = VFSManager.getVFSForPath(path);
            if ((vfs.getCapabilities() & 2) == 0) {
                path = System.getProperty("user.home");
            }
        } else {
            path = null;
        }
        return jEdit.newFile(view, path);
    }

    public static Buffer newFile(View view, String dir2) {
        if (dir2 != null && buffersFirst != null && buffersFirst == buffersLast && buffersFirst.isUntitled() && !buffersFirst.isDirty()) {
            jEdit.closeBuffer(view, buffersFirst);
            return buffersFirst;
        }
        int untitledCount = 0;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.getName().startsWith("Untitled-")) {
                try {
                    untitledCount = Math.max(untitledCount, Integer.parseInt(buffer.getName().substring(9)));
                }
                catch (NumberFormatException nf) {
                    // empty catch block
                }
            }
            buffer = buffer.next;
        }
        return jEdit.openFile(view, dir2, "Untitled-" + (untitledCount + 1), true, null);
    }

    public static boolean closeBuffer(View view, Buffer buffer) {
        if (buffer.isPerformingIO()) {
            VFSManager.waitForRequests();
            if (VFSManager.errorOccurred()) {
                return false;
            }
        }
        if (buffer.isDirty()) {
            Object[] args = new Object[]{buffer.getName()};
            int result = GUIUtilities.confirm(view, "notsaved", args, 1, 2);
            if (result == 0) {
                if (!buffer.save(view, null, true)) {
                    return false;
                }
                VFSManager.waitForRequests();
                if (buffer.getBooleanProperty("BufferIORequest__error")) {
                    return false;
                }
            } else if (result != 1) {
                return false;
            }
        }
        jEdit._closeBuffer(view, buffer);
        return true;
    }

    public static void _closeBuffer(View view, Buffer buffer) {
        String path;
        if (buffer.isClosed()) {
            return;
        }
        PerspectiveManager.setPerspectiveDirty(true);
        if (!buffer.isNewFile()) {
            Integer _caret;
            if (view != null) {
                view.getEditPane().saveCaretInfo();
            }
            int caret = (_caret = (Integer)buffer.getProperty("Buffer__caret")) == null ? 0 : _caret;
            BufferHistory.setEntry(buffer.getPath(), caret, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"));
        }
        if ((VFSManager.getVFSForPath(path = buffer.getSymlinkPath()).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        bufferHash.remove(path);
        jEdit.removeBufferFromList(buffer);
        buffer.close();
        DisplayManager.bufferClosed(buffer);
        EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
        if (buffersFirst == null && buffersLast == null) {
            jEdit.newFile(view);
        }
    }

    public static boolean closeAllBuffers(View view) {
        return jEdit.closeAllBuffers(view, false);
    }

    public static boolean closeAllBuffers(View view, boolean isExiting) {
        boolean ok;
        if (view != null) {
            view.getEditPane().saveCaretInfo();
        }
        boolean dirty = false;
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                dirty = true;
                break;
            }
            buffer = buffer.next;
        }
        if (dirty && !(ok = new CloseDialog(view).isOK())) {
            return false;
        }
        VFSManager.waitForRequests();
        if (VFSManager.errorOccurred()) {
            return false;
        }
        buffer = buffersFirst;
        buffersLast = null;
        buffersFirst = null;
        bufferHash.clear();
        bufferCount = 0;
        while (buffer != null) {
            if (!buffer.isNewFile()) {
                Integer _caret = (Integer)buffer.getProperty("Buffer__caret");
                int caret = _caret == null ? 0 : _caret;
                BufferHistory.setEntry(buffer.getPath(), caret, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"));
            }
            buffer.close();
            DisplayManager.bufferClosed(buffer);
            if (!isExiting) {
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
            }
            buffer = buffer.next;
        }
        if (!isExiting) {
            jEdit.newFile(view);
        }
        PerspectiveManager.setPerspectiveDirty(true);
        return true;
    }

    public static void saveAllBuffers(View view) {
        jEdit.saveAllBuffers(view, jEdit.getBooleanProperty("confirmSaveAll"));
    }

    public static void saveAllBuffers(View view, boolean confirm) {
        int result;
        if (confirm && (result = GUIUtilities.confirm(view, "saveall", null, 0, 3)) != 0) {
            return;
        }
        Buffer current = view.getBuffer();
        Buffer buffer = buffersFirst;
        while (buffer != null) {
            if (buffer.isDirty()) {
                if (buffer.isNewFile()) {
                    view.setBuffer(buffer);
                }
                buffer.save(view, null, true);
            }
            buffer = buffer.next;
        }
        view.setBuffer(current);
    }

    public static void reloadAllBuffers(View view, boolean confirm) {
        int result;
        boolean hasDirty = false;
        Buffer[] buffers = jEdit.getBuffers();
        for (int i = 0; i < buffers.length && !hasDirty; ++i) {
            hasDirty = buffers[i].isDirty();
        }
        if (confirm && hasDirty && (result = GUIUtilities.confirm(view, "reload-all", null, 0, 3)) != 0) {
            return;
        }
        View _view = viewsFirst;
        while (_view != null) {
            EditPane[] panes = _view.getEditPanes();
            for (int i = 0; i < panes.length; ++i) {
                panes[i].saveCaretInfo();
            }
            _view = _view.next;
        }
        for (int i = 0; i < buffers.length; ++i) {
            Buffer buffer = buffers[i];
            buffer.load(view, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer _getBuffer(String path) {
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        Object object = bufferListLock;
        synchronized (object) {
            return (Buffer)bufferHash.get(path);
        }
    }

    public static Buffer getBuffer(String path) {
        return jEdit._getBuffer(MiscUtilities.resolveSymlinks(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Buffer[] getBuffers() {
        Object object = bufferListLock;
        synchronized (object) {
            Buffer[] buffers = new Buffer[bufferCount];
            Buffer buffer = buffersFirst;
            for (int i = 0; i < bufferCount; ++i) {
                buffers[i] = buffer;
                buffer = buffer.next;
            }
            return buffers;
        }
    }

    public static int getBufferCount() {
        return bufferCount;
    }

    public static Buffer getFirstBuffer() {
        return buffersFirst;
    }

    public static Buffer getLastBuffer() {
        return buffersLast;
    }

    public static void checkBufferStatus(View view) {
        boolean showDialogSetting = jEdit.getBooleanProperty("autoReloadDialog");
        boolean autoReloadSetting = jEdit.getBooleanProperty("autoReload");
        View _view = viewsFirst;
        while (_view != null) {
            EditPane[] editPanes = _view.getEditPanes();
            for (int i = 0; i < editPanes.length; ++i) {
                editPanes[i].saveCaretInfo();
            }
            _view = _view.next;
        }
        Buffer buffer = buffersFirst;
        int[] states = new int[bufferCount];
        int i = 0;
        boolean show = false;
        while (buffer != null) {
            states[i] = buffer.checkFileStatus(view);
            switch (states[i]) {
                case 1: {
                    if (autoReloadSetting && showDialogSetting && !buffer.isDirty()) {
                        buffer.load(view, true);
                    }
                }
                case 2: {
                    show = true;
                }
            }
            buffer = buffer.next;
            ++i;
        }
        if (show && showDialogSetting) {
            new FilesChangedDialog(view, states, autoReloadSetting);
        }
    }

    public static InputHandler getInputHandler() {
        return inputHandler;
    }

    public static View newView(View view) {
        return jEdit.newView(view, null, false);
    }

    public static View newView(View view, Buffer buffer) {
        return jEdit.newView(view, buffer, false);
    }

    public static View newView(View view, Buffer buffer, boolean plainView) {
        View.ViewConfig config = view != null && plainView == view.isPlainView() ? view.getViewConfig() : new View.ViewConfig(plainView);
        return jEdit.newView(view, buffer, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static View newView(View view, Buffer buffer, View.ViewConfig config) {
        PerspectiveManager.setPerspectiveDirty(true);
        try {
            if (view != null) {
                view.showWaitCursor();
                view.getEditPane().saveCaretInfo();
            }
            View newView = new View(buffer, config);
            jEdit.addViewToList(newView);
            if (!config.plainView) {
                DockableWindowManager wm = newView.getDockableWindowManager();
                if (config.top != null && config.top.length() != 0) {
                    wm.showDockableWindow(config.top);
                }
                if (config.left != null && config.left.length() != 0) {
                    wm.showDockableWindow(config.left);
                }
                if (config.bottom != null && config.bottom.length() != 0) {
                    wm.showDockableWindow(config.bottom);
                }
                if (config.right != null && config.right.length() != 0) {
                    wm.showDockableWindow(config.right);
                }
            }
            newView.pack();
            if (config.width != 0 && config.height != 0) {
                Rectangle desired = new Rectangle(config.x, config.y, config.width, config.height);
                if (OperatingSystem.isX11() && Debug.GEOMETRY_WORKAROUND) {
                    new GUIUtilities.UnixWorkaround(newView, "view", desired, config.extState);
                } else {
                    newView.setBounds(desired);
                    GUIUtilities.setExtendedState(newView, config.extState);
                }
            } else {
                GUIUtilities.centerOnScreen(newView);
            }
            EditBus.send(new ViewUpdate(newView, ViewUpdate.CREATED));
            newView.setVisible(true);
            if (newView == viewsFirst) {
                newView.getTextArea().requestFocus();
                if (settingsDirectory != null && jEdit.getBooleanProperty("firstTime")) {
                    new HelpViewer();
                } else if (jEdit.getBooleanProperty("tip.show")) {
                    new TipOfTheDay(newView);
                }
                jEdit.setBooleanProperty("firstTime", false);
            } else {
                GUIUtilities.requestFocus(newView, newView.getTextArea());
            }
            View view2 = newView;
            return view2;
        }
        finally {
            if (view != null) {
                view.hideWaitCursor();
            }
        }
    }

    public static void closeView(View view) {
        jEdit.closeView(view, true);
    }

    public static View[] getViews() {
        View[] views = new View[viewCount];
        View view = viewsFirst;
        for (int i = 0; i < viewCount; ++i) {
            views[i] = view;
            view = view.next;
        }
        return views;
    }

    public static int getViewCount() {
        return viewCount;
    }

    public static View getFirstView() {
        return viewsFirst;
    }

    public static View getLastView() {
        return viewsLast;
    }

    public static View getActiveView() {
        if (activeView == null) {
            return viewsFirst;
        }
        return activeView;
    }

    public static boolean isMainThread() {
        return Thread.currentThread() == mainThread;
    }

    public static boolean isBackgroundModeEnabled() {
        return background;
    }

    public static void showMemoryDialog(View view) {
        Runtime rt = Runtime.getRuntime();
        int before = (int)(rt.freeMemory() / 1024L);
        System.gc();
        int after = (int)(rt.freeMemory() / 1024L);
        int total = (int)(rt.totalMemory() / 1024L);
        JProgressBar progress = new JProgressBar(0, total);
        progress.setValue(total - after);
        progress.setStringPainted(true);
        progress.setString(jEdit.getProperty("memory-status.use", new Object[]{new Integer(total - after), new Integer(total)}));
        Object[] message = new Object[]{jEdit.getProperty("memory-status.gc", new Object[]{new Integer(after - before)}), Box.createVerticalStrut(12), progress, Box.createVerticalStrut(6)};
        JOptionPane.showMessageDialog(view, message, jEdit.getProperty("memory-status.title"), 1);
    }

    public static String getJEditHome() {
        return jEditHome;
    }

    public static String getSettingsDirectory() {
        return settingsDirectory;
    }

    public static String getJARCacheDirectory() {
        return jarCacheDirectory;
    }

    public static void backupSettingsFile(File file) {
        if (settingsDirectory == null) {
            return;
        }
        String backupDir = MiscUtilities.constructPath(settingsDirectory, "settings-backup");
        File dir2 = new File(backupDir);
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        MiscUtilities.saveBackup(file, 5, null, "~", backupDir);
    }

    public static void saveSettings() {
        if (settingsDirectory == null) {
            return;
        }
        Abbrevs.save();
        FavoritesVFS.saveFavorites();
        HistoryModel.saveHistory();
        Registers.saveRegisters();
        SearchAndReplace.save();
        BufferHistory.save();
        KillRing.save();
        File file1 = new File(MiscUtilities.constructPath(settingsDirectory, "#properties#save#"));
        File file2 = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
        if (file2.exists() && file2.lastModified() != propsModTime) {
            Log.log(7, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, file2 + " changed" + " on disk; will not save user properties");
        } else {
            jEdit.backupSettingsFile(file2);
            try {
                FileOutputStream out = new FileOutputStream(file1);
                propMgr.saveUserProps(out);
                file2.delete();
                file1.renameTo(file2);
            }
            catch (IOException io) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
            }
            propsModTime = file2.lastModified();
        }
    }

    public static void exit(View view, boolean reallyExit) {
        if (view == null) {
            view = activeView;
        }
        VFSManager.waitForRequests();
        EditBus.send(new EditorExitRequested(view));
        boolean bl = !background;
        PerspectiveManager.savePerspective(false);
        if (!jEdit.closeAllBuffers(view, reallyExit |= bl)) {
            return;
        }
        if (!reallyExit) {
            view = viewsFirst;
            while (view != null) {
                jEdit.closeView(view, false);
                view = view.next;
            }
            jEdit.saveSettings();
        } else {
            if (view != null) {
                view.close();
            }
            Autosave.stop();
            if (server != null) {
                server.stopServer();
            }
            PluginJAR[] plugins = jEdit.getPluginJARs();
            for (int i = 0; i < plugins.length; ++i) {
                jEdit.removePluginJAR(plugins[i], true);
            }
            EditBus.send(new EditorExiting(null));
            jEdit.saveSettings();
            Log.closeStream();
            System.exit(0);
        }
    }

    public static EditServer getEditServer() {
        return server;
    }

    static void updatePosition(String oldPath, Buffer buffer) {
        if ((VFSManager.getVFSForPath(oldPath).getCapabilities() & 0x80) != 0) {
            oldPath = oldPath.toLowerCase();
        }
        bufferHash.remove(oldPath);
        String path = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(path).getCapabilities() & 0x80) != 0) {
            path = path.toLowerCase();
        }
        bufferHash.put(path, buffer);
        if (sortBuffers) {
            jEdit.removeBufferFromList(buffer);
            jEdit.addBufferToList(buffer);
        }
    }

    public static void addMode(Mode mode) {
        modes.addElement(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static void loadMode(Mode mode) {
        block12: {
            final String fileName = (String)mode.getProperty("file");
            Log.log(5, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Loading edit mode " + fileName);
            final XmlParser parser = new XmlParser();
            XModeHandler xmh = new XModeHandler(mode.getName()){

                public void error(String what, Object subst) {
                    String msg;
                    int line = parser.getLineNumber();
                    int column = parser.getColumnNumber();
                    if (subst == null) {
                        msg = jEdit.getProperty("xmode-error." + what);
                    } else {
                        msg = jEdit.getProperty("xmode-error." + what, new String[]{subst.toString()});
                        if (subst instanceof Throwable) {
                            Log.log(9, this, subst);
                        }
                    }
                    Object[] args = new Object[]{fileName, new Integer(line), new Integer(column), msg};
                    GUIUtilities.error(null, "xmode-error", args);
                }

                public TokenMarker getTokenMarker(String modeName) {
                    Mode mode = jEdit.getMode(modeName);
                    if (mode == null) {
                        return null;
                    }
                    return mode.getTokenMarker();
                }
            };
            mode.setTokenMarker(xmh.getTokenMarker());
            BufferedReader grammar = null;
            parser.setHandler(xmh);
            grammar = new BufferedReader(new FileReader(fileName));
            parser.parse(null, null, grammar);
            mode.setProperties(xmh.getModeProperties());
            Object var11_5 = null;
            try {
                if (grammar != null) {
                    ((Reader)grammar).close();
                }
                break block12;
            }
            catch (IOException io) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
            }
            break block12;
            {
                catch (Throwable e) {
                    Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
                    if (e instanceof XmlException) {
                        XmlException xe = (XmlException)e;
                        int line = xe.getLine();
                        String message = xe.getMessage();
                        Object[] args = new Object[]{fileName, new Integer(line), null, message};
                        GUIUtilities.error(null, "xmode-error", args);
                    }
                    Object var11_6 = null;
                    try {
                        if (grammar != null) {
                            ((Reader)grammar).close();
                        }
                        break block12;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_7 = null;
                try {
                    if (grammar != null) {
                        ((Reader)grammar).close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
                }
                throw throwable;
            }
        }
    }

    static void addPluginProps(Properties map) {
        propMgr.addPluginProps(map);
    }

    static void removePluginProps(Properties map) {
        propMgr.removePluginProps(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pluginError(String path, String messageProp, Object[] args) {
        Object object = pluginErrorLock;
        synchronized (object) {
            if (pluginErrors == null) {
                pluginErrors = new Vector();
            }
            ErrorListDialog.ErrorEntry newEntry = new ErrorListDialog.ErrorEntry(path, messageProp, args);
            for (int i = 0; i < pluginErrors.size(); ++i) {
                if (!pluginErrors.get(i).equals(newEntry)) continue;
                return;
            }
            pluginErrors.addElement(newEntry);
            if (startupDone) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        jEdit.showPluginErrorDialog();
                    }
                });
            }
        }
    }

    static void setActiveView(View view) {
        activeView = view;
    }

    private jEdit() {
    }

    private static void usage() {
        System.out.println("Usage: jedit [<options>] [<files>]");
        System.out.println("\t<file> +marker:<marker>: Positions caret at marker <marker>");
        System.out.println("\t<file> +line:<line>: Positions caret at line number <line>");
        System.out.println("\t--: End of options");
        System.out.println("\t-background: Run in background mode");
        System.out.println("\t-nobackground: Disable background mode (default)");
        System.out.println("\t-gui: Only if running in background mode; open initial view (default)");
        System.out.println("\t-nogui: Only if running in background mode; don't open initial view");
        System.out.println("\t-log=<level>: Log messages with level equal to or higher than this to");
        System.out.println("\t standard error. <level> must be between 1 and 9. Default is 7.");
        System.out.println("\t-newplainview: Client instance opens a new plain view");
        System.out.println("\t-newview: Client instance opens a new view (default)");
        System.out.println("\t-plugins: Load plugins (default)");
        System.out.println("\t-noplugins: Don't load any plugins");
        System.out.println("\t-restore: Restore previously open files (default)");
        System.out.println("\t-norestore: Don't restore previously open files");
        System.out.println("\t-reuseview: Client instance reuses existing view");
        System.out.println("\t-quit: Quit a running instance");
        System.out.println("\t-run=<script>: Run the specified BeanShell script");
        System.out.println("\t-server: Read/write server info from/to $HOME/.jedit/server (default)");
        System.out.println("\t-server=<name>: Read/write server info from/to $HOME/.jedit/<name>");
        System.out.println("\t-noserver: Don't start edit server");
        System.out.println("\t-settings=<path>: Load user-specific settings from <path>");
        System.out.println("\t-nosettings: Don't load user-specific settings");
        System.out.println("\t-startupscripts: Run startup scripts (default)");
        System.out.println("\t-nostartupscripts: Don't run startup scripts");
        System.out.println("\t-usage: Print this message and exit");
        System.out.println("\t-version: Print jEdit version and exit");
        System.out.println("\t-wait: Wait until the user closes the specified buffer in the server");
        System.out.println("\t instance. Does nothing if passed to the initial jEdit instance.");
        System.out.println();
        System.out.println("Report bugs to Slava Pestov <slava@jedit.org>.");
    }

    private static void version() {
        System.out.println("jEdit " + jEdit.getVersion());
    }

    private static String makeServerScript(boolean wait, boolean restore, boolean newView, boolean newPlainView, String[] args, String scriptFile) {
        StringBuffer script = new StringBuffer();
        String userDir = System.getProperty("user.dir");
        script.append("parent = \"");
        script.append(MiscUtilities.charsToEscapes(userDir));
        script.append("\";\n");
        script.append("args = new String[");
        script.append(args.length);
        script.append("];\n");
        for (int i = 0; i < args.length; ++i) {
            script.append("args[");
            script.append(i);
            script.append("] = ");
            if (args[i] == null) {
                script.append("null");
            } else {
                script.append('\"');
                script.append(MiscUtilities.charsToEscapes(args[i]));
                script.append('\"');
            }
            script.append(";\n");
        }
        script.append("view = jEdit.getLastView();\n");
        script.append("buffer = EditServer.handleClient(" + restore + "," + newView + "," + newPlainView + ",parent,args);\n");
        script.append("if(buffer != null && " + wait + ") {\n");
        script.append("\tbuffer.setWaitSocket(socket);\n");
        script.append("\tdoNotCloseSocket = true;\n");
        script.append("}\n");
        script.append("if(view != jEdit.getLastView() && " + wait + ") {\n");
        script.append("\tjEdit.getLastView().setWaitSocket(socket);\n");
        script.append("\tdoNotCloseSocket = true;\n");
        script.append("}\n");
        script.append("if(doNotCloseSocket == void)\n");
        script.append("\tsocket.close();\n");
        if (scriptFile != null) {
            scriptFile = MiscUtilities.constructPath(userDir, scriptFile);
            script.append("BeanShell.runScript(view,\"" + MiscUtilities.charsToEscapes(scriptFile) + "\",null,this.namespace);\n");
        }
        return script.toString();
    }

    private static void initMisc() {
        jars = new Vector();
        actionContext = new ActionContext(){

            public void invokeAction(EventObject evt, EditAction action) {
                ActionBar actionBar;
                View view = GUIUtilities.getView((Component)evt.getSource());
                boolean actionBarVisible = view.getActionBar() == null || !view.getActionBar().isShowing() ? false : view.getActionBar().isVisible();
                view.getInputHandler().invokeAction(action);
                if (actionBarVisible && (actionBar = view.getActionBar()) != null) {
                    view.removeToolBar(actionBar);
                }
            }
        };
        bufferHash = new HashMap();
        inputHandler = new DefaultInputHandler(null);
        System.getProperties().put("java.protocol.handler.pkgs", "org.gjt.sp.jedit.proto|" + System.getProperty("java.protocol.handler.pkgs", ""));
        String userAgent = "jEdit/" + jEdit.getVersion() + " (Java " + System.getProperty("java.version") + ". " + System.getProperty("java.vendor") + "; " + System.getProperty("os.arch") + ")";
        System.getProperties().put("http.agent", userAgent);
        jEditHome = System.getProperty("jedit.home");
        if (jEditHome == null) {
            String classpath = System.getProperty("java.class.path");
            int index = classpath.toLowerCase().indexOf("jedit.jar");
            int start = classpath.lastIndexOf(File.pathSeparator, index) + 1;
            if (classpath.equalsIgnoreCase("jedit.jar")) {
                jEditHome = System.getProperty("user.dir");
            } else if (index > start) {
                jEditHome = classpath.substring(start, index - 1);
            } else {
                jEditHome = System.getProperty("user.dir");
                Log.log(7, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "jedit.jar not in class path!");
                Log.log(7, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Assuming jEdit is installed in " + jEditHome + ".");
                Log.log(7, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Override with jedit.home system property.");
            }
        }
        jEditHome = MiscUtilities.resolveSymlinks(jEditHome);
        Log.log(3, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "jEdit home directory is " + jEditHome);
        if (settingsDirectory != null) {
            jarCacheDirectory = MiscUtilities.constructPath(settingsDirectory, "jars-cache");
            new File(jarCacheDirectory).mkdirs();
        }
        EditBus.addToBus(new SettingsReloader());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.currentThread().setContextClassLoader(new JARClassLoader());
            }
        });
    }

    private static void initSystemProperties() {
        propMgr = new PropertyManager();
        try {
            propMgr.loadSystemProps((class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResourceAsStream("/org/gjt/sp/jedit/jedit.props"));
            propMgr.loadSystemProps((class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResourceAsStream("/org/gjt/sp/jedit/jedit_gui.props"));
            propMgr.loadSystemProps((class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResourceAsStream("/org/gjt/sp/jedit/jedit_keys.props"));
        }
        catch (Exception e) {
            Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Error while loading system properties!");
            Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "One of the following property files could not be loaded:\n- jedit.props\n- jedit_gui.props\n- jedit_keys.props\njedit.jar is probably corrupt.");
            Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
            System.exit(1);
        }
    }

    private static void initSiteProperties() {
        String siteSettingsDirectory = MiscUtilities.constructPath(jEditHome, "properties");
        File siteSettings = new File(siteSettingsDirectory);
        if (!siteSettings.exists() || !siteSettings.isDirectory()) {
            return;
        }
        Object[] snippets = siteSettings.list();
        if (snippets == null) {
            return;
        }
        MiscUtilities.quicksort(snippets, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        for (int i = 0; i < snippets.length; ++i) {
            Object snippet = snippets[i];
            if (!((String)snippet).toLowerCase().endsWith(".props")) continue;
            try {
                String path = MiscUtilities.constructPath(siteSettingsDirectory, (String)snippet);
                Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? jEdit.class$("org.gjt.sp.jedit.jEdit") : class$org$gjt$sp$jedit$jEdit, "Loading site snippet: " + path);
                propMgr.loadSiteProps(new FileInputStream(new File(path)));
                continue;
            }
            catch (FileNotFoundException fnf) {
                Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? jEdit.class$("org.gjt.sp.jedit.jEdit") : class$org$gjt$sp$jedit$jEdit, fnf);
                continue;
            }
            catch (IOException e) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? jEdit.class$("org.gjt.sp.jedit.jEdit") : class$org$gjt$sp$jedit$jEdit, "Cannot load site snippet " + (String)snippet);
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? jEdit.class$("org.gjt.sp.jedit.jEdit") : class$org$gjt$sp$jedit$jEdit, e);
            }
        }
    }

    private static void initResources() {
        builtInActionSet = new ActionSet(null, null, null, (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResource("actions.xml"));
        builtInActionSet.setLabel(jEdit.getProperty("action-set.jEdit"));
        builtInActionSet.load();
        actionContext.addActionSet(builtInActionSet);
        DockableWindowManager.loadDockableWindows(null, (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResource("dockables.xml"), null);
        ServiceManager.loadServices(null, (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResource("services.xml"), null);
    }

    private static void initPlugins() {
        if (jEditHome != null) {
            jEdit.addPluginJARsFromDirectory(MiscUtilities.constructPath(jEditHome, "jars"));
        }
        if (settingsDirectory != null) {
            File jarsDirectory = new File(settingsDirectory, "jars");
            if (!jarsDirectory.exists()) {
                jarsDirectory.mkdir();
            }
            jEdit.addPluginJARsFromDirectory(jarsDirectory.getPath());
        }
        PluginJAR[] jars = jEdit.getPluginJARs();
        for (int i = 0; i < jars.length; ++i) {
            jars[i].checkDependencies();
        }
    }

    private static void initUserProperties() {
        if (settingsDirectory != null) {
            File file = new File(MiscUtilities.constructPath(settingsDirectory, "properties"));
            propsModTime = file.lastModified();
            try {
                propMgr.loadUserProps(new FileInputStream(file));
            }
            catch (FileNotFoundException fnf) {
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
            }
        }
    }

    private static String fontStyleToString(int style) {
        if (style == 0) {
            return "PLAIN";
        }
        if (style == 1) {
            return "BOLD";
        }
        if (style == 2) {
            return "ITALIC";
        }
        if (style == 3) {
            return "BOLDITALIC";
        }
        throw new RuntimeException("Invalid style: " + style);
    }

    private static String fontToString(Font font) {
        return font.getFamily() + "-" + jEdit.fontStyleToString(font.getStyle()) + "-" + font.getSize();
    }

    private static void initPLAF() {
        Font secondaryFont;
        Font primaryFont = jEdit.getFontProperty("metal.primary.font");
        if (primaryFont != null) {
            String primaryFontString = jEdit.fontToString(primaryFont);
            System.getProperties().put("swing.plaf.metal.controlFont", primaryFontString);
            System.getProperties().put("swing.plaf.metal.menuFont", primaryFontString);
        }
        if ((secondaryFont = jEdit.getFontProperty("metal.secondary.font")) != null) {
            String secondaryFontString = jEdit.fontToString(secondaryFont);
            System.getProperties().put("swing.plaf.metal.systemFont", secondaryFontString);
            System.getProperties().put("swing.plaf.metal.userFont", secondaryFontString);
        }
        try {
            String lf = jEdit.getProperty("lookAndFeel");
            if (lf != null && lf.length() != 0) {
                UIManager.setLookAndFeel(lf);
            } else if (OperatingSystem.isMacOS()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
        }
        UIDefaults defaults = UIManager.getDefaults();
        if (jEdit.getBooleanProperty("textColors")) {
            ColorUIResource background = new ColorUIResource(jEdit.getColorProperty("view.bgColor"));
            ColorUIResource foreground = new ColorUIResource(jEdit.getColorProperty("view.fgColor"));
            ColorUIResource caretColor = new ColorUIResource(jEdit.getColorProperty("view.caretColor"));
            ColorUIResource selectionColor = new ColorUIResource(jEdit.getColorProperty("view.selectionColor"));
            String[] prefixes = new String[]{"TextField", "TextArea", "List", "Table"};
            for (int i = 0; i < prefixes.length; ++i) {
                String prefix = prefixes[i];
                defaults.put(prefix + ".disabledBackground", background);
                defaults.put(prefix + ".background", background);
                defaults.put(prefix + ".disabledForeground", foreground);
                defaults.put(prefix + ".foreground", foreground);
                defaults.put(prefix + ".caretForeground", caretColor);
                defaults.put(prefix + ".selectionForeground", foreground);
                defaults.put(prefix + ".selectionBackground", selectionColor);
            }
            defaults.put("Tree.background", background);
            defaults.put("Tree.foreground", foreground);
            defaults.put("Tree.textBackground", background);
            defaults.put("Tree.textForeground", foreground);
            defaults.put("Tree.selectionForeground", foreground);
            defaults.put("Tree.selectionBackground", selectionColor);
        }
        defaults.remove("SplitPane.border");
        defaults.remove("SplitPaneDivider.border");
    }

    private static void runStartupScripts(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        Object[] snippets = directory.listFiles();
        if (snippets == null) {
            return;
        }
        MiscUtilities.quicksort(snippets, (MiscUtilities.Compare)new MiscUtilities.StringICaseCompare());
        for (int i = 0; i < snippets.length; ++i) {
            Object snippet = snippets[i];
            Macros.Handler handler = Macros.getHandlerForPathName(((File)snippet).getPath());
            if (handler == null) continue;
            try {
                Macros.Macro newMacro = handler.createMacro(((File)snippet).getName(), ((File)snippet).getPath());
                handler.runMacro(null, newMacro, false);
                continue;
            }
            catch (Exception e) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? jEdit.class$("org.gjt.sp.jedit.jEdit") : class$org$gjt$sp$jedit$jEdit, e);
            }
        }
    }

    private static void initProxy() {
        boolean socksEnabled = jEdit.getBooleanProperty("socks.enabled");
        if (!socksEnabled) {
            Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "SOCKS proxy disabled");
            System.getProperties().remove("socksProxyHost");
            System.getProperties().remove("socksProxyPort");
        } else {
            String socksPort;
            String socksHost = jEdit.getProperty("firewall.socks.host");
            if (socksHost != null) {
                System.setProperty("socksProxyHost", socksHost);
                Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "SOCKS proxy enabled: " + socksHost);
            }
            if ((socksPort = jEdit.getProperty("firewall.socks.port")) != null) {
                System.setProperty("socksProxyPort", socksPort);
            }
        }
        boolean httpEnabled = jEdit.getBooleanProperty("firewall.enabled");
        if (!httpEnabled) {
            Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "HTTP proxy disabled");
            System.getProperties().remove("proxySet");
            System.getProperties().remove("proxyHost");
            System.getProperties().remove("proxyPort");
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
            System.getProperties().remove("http.nonProxyHosts");
            Authenticator.setDefault(null);
        } else {
            String nonProxyHosts;
            String host = jEdit.getProperty("firewall.host");
            if (host == null) {
                return;
            }
            System.setProperty("http.proxyHost", host);
            Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "HTTP proxy enabled: " + host);
            String port = jEdit.getProperty("firewall.port");
            if (port != null) {
                System.setProperty("http.proxyPort", port);
            }
            if ((nonProxyHosts = jEdit.getProperty("firewall.nonProxyHosts")) != null) {
                System.setProperty("http.nonProxyHosts", nonProxyHosts);
            }
            String username = jEdit.getProperty("firewall.user");
            String password = jEdit.getProperty("firewall.password");
            if (password == null) {
                password = "";
            }
            if (username == null || username.length() == 0) {
                Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "HTTP proxy without user");
                Authenticator.setDefault(new FirewallAuthenticator(null));
            } else {
                Log.log(1, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "HTTP proxy user: " + username);
                PasswordAuthentication pw = new PasswordAuthentication(username, password.toCharArray());
                Authenticator.setDefault(new FirewallAuthenticator(pw));
            }
        }
    }

    private static void finishStartup(final boolean gui, final boolean restore, final String userDir, final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                boolean restoreFiles;
                Buffer buffer = jEdit.openFiles(null, userDir, args);
                int count = jEdit.getBufferCount();
                if (count == 0) {
                    jEdit.newFile(null);
                }
                View view = null;
                boolean bl = restoreFiles = restore && jEdit.getBooleanProperty("restore") && (jEdit.getBufferCount() == 0 || jEdit.getBooleanProperty("restore.cli"));
                if (gui || count != 0) {
                    view = PerspectiveManager.loadPerspective(restoreFiles);
                    if (view == null) {
                        view = jEdit.newView(null, buffer);
                    } else if (buffer != null) {
                        view.setBuffer(buffer);
                    }
                }
                EditBus.send(new EditorStarted(null));
                VFSManager.start();
                if (server != null) {
                    server.start();
                }
                GUIUtilities.hideSplashScreen();
                Log.log(3, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Startup complete");
                if (pluginErrors != null) {
                    jEdit.showPluginErrorDialog();
                }
                startupDone = true;
                Toolkit.getDefaultToolkit();
            }
        });
    }

    private static void showPluginErrorDialog() {
        if (pluginErrors == null) {
            return;
        }
        String caption = jEdit.getProperty("plugin-error.caption" + (pluginErrors.size() == 1 ? "-1" : ""));
        JFrame frame = PluginManager.getInstance() == null ? viewsFirst : PluginManager.getInstance();
        new ErrorListDialog(frame, jEdit.getProperty("plugin-error.title"), caption, pluginErrors, true);
        pluginErrors = null;
    }

    private static void getNotLoadedPluginJARs(Vector returnValue, String dir2, String[] list) {
        block0: for (int i = 0; i < list.length; ++i) {
            String name = list[i];
            if (!name.toLowerCase().endsWith(".jar")) continue;
            String path = MiscUtilities.constructPath(dir2, name);
            for (int j = 0; j < jars.size(); ++j) {
                PluginJAR jar = (PluginJAR)jars.elementAt(j);
                String jarPath = jar.getPath();
                String jarName = MiscUtilities.getFileName(jarPath);
                if (path.equals(jarPath) || !new File(jarPath).exists() && name.equals(jarName)) continue block0;
            }
            returnValue.addElement(path);
        }
    }

    private static void gotoMarker(final View view, final Buffer buffer, final String marker) {
        VFSManager.runInAWTThread(new Runnable(){

            /*
             * WARNING - void declaration
             */
            public void run() {
                void var1_4;
                int pos;
                if (marker.startsWith("+line:")) {
                    try {
                        int line = Integer.parseInt(marker.substring(6));
                        pos = buffer.getLineStartOffset(line - 1);
                    }
                    catch (Exception e) {
                        return;
                    }
                } else if (marker.startsWith("+marker:")) {
                    if (marker.length() != 9) {
                        return;
                    }
                    Marker m = buffer.getMarker(marker.charAt(8));
                    if (m == null) {
                        return;
                    }
                    pos = m.getPosition();
                } else {
                    throw new InternalError();
                }
                if (view != null && view.getBuffer() == buffer) {
                    view.getTextArea().setCaretPosition((int)var1_4);
                } else {
                    buffer.setIntegerProperty("Buffer__caret", (int)var1_4);
                    buffer.unsetProperty("Buffer__scrollVert");
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addBufferToList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            String symlinkPath = buffer.getSymlinkPath();
            if ((VFSManager.getVFSForPath(symlinkPath).getCapabilities() & 0x80) != 0) {
                symlinkPath = symlinkPath.toLowerCase();
            }
            if (viewCount <= 1 && buffersFirst != null && buffersFirst == buffersLast && buffersFirst.isUntitled() && !buffersFirst.isDirty()) {
                Buffer oldBuffersFirst = buffersFirst;
                buffersFirst = buffersLast = buffer;
                DisplayManager.bufferClosed(oldBuffersFirst);
                EditBus.send(new BufferUpdate(oldBuffersFirst, null, BufferUpdate.CLOSED));
                bufferHash.clear();
                bufferHash.put(symlinkPath, buffer);
                return;
            }
            ++bufferCount;
            bufferHash.put(symlinkPath, buffer);
            if (buffersFirst == null) {
                buffersFirst = buffersLast = buffer;
                return;
            }
            if (sortBuffers) {
                String str12;
                String str11;
                if (sortByName) {
                    str11 = buffer.getName();
                    str12 = buffer.getDirectory();
                } else {
                    str11 = buffer.getDirectory();
                    str12 = buffer.getName();
                }
                Buffer _buffer = buffersFirst;
                while (_buffer != null) {
                    String str22;
                    String str21;
                    if (sortByName) {
                        str21 = _buffer.getName();
                        str22 = _buffer.getDirectory();
                    } else {
                        str21 = _buffer.getDirectory();
                        str22 = _buffer.getName();
                    }
                    int comp = MiscUtilities.compareStrings(str11, str21, true);
                    if (comp < 0 || comp == 0 && MiscUtilities.compareStrings(str12, str22, true) < 0) {
                        buffer.next = _buffer;
                        buffer.prev = _buffer.prev;
                        _buffer.prev = buffer;
                        if (_buffer != buffersFirst) {
                            buffer.prev.next = buffer;
                        } else {
                            buffersFirst = buffer;
                        }
                        return;
                    }
                    _buffer = _buffer.next;
                }
            }
            buffer.prev = buffersLast;
            buffer.next = null;
            jEdit.buffersLast.next = buffer;
            buffersLast = buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBufferFromList(Buffer buffer) {
        Object object = bufferListLock;
        synchronized (object) {
            --bufferCount;
            boolean caseInsensitiveFilesystem = OperatingSystem.isDOSDerived() || OperatingSystem.isMacOS();
            String path = buffer.getPath();
            if (caseInsensitiveFilesystem) {
                path = path.toLowerCase();
            }
            bufferHash.remove(path);
            if (buffer == buffersFirst && buffer == buffersLast) {
                buffersLast = null;
                buffersFirst = null;
                return;
            }
            if (buffer == buffersFirst) {
                buffersFirst = buffer.next;
                buffer.next.prev = null;
            } else {
                buffer.prev.next = buffer.next;
            }
            if (buffer == buffersLast) {
                buffersLast = jEdit.buffersLast.prev;
                buffer.prev.next = null;
            } else {
                buffer.next.prev = buffer.prev;
            }
            buffer.prev = null;
            buffer.next = null;
        }
    }

    private static void addViewToList(View view) {
        ++viewCount;
        if (viewsFirst == null) {
            viewsFirst = viewsLast = view;
        } else {
            view.prev = viewsLast;
            jEdit.viewsLast.next = view;
            viewsLast = view;
        }
    }

    private static void removeViewFromList(View view) {
        --viewCount;
        if (viewsFirst == viewsLast) {
            viewsLast = null;
            viewsFirst = null;
            return;
        }
        if (view == viewsFirst) {
            viewsFirst = view.next;
            view.next.prev = null;
        } else {
            view.prev.next = view.next;
        }
        if (view == viewsLast) {
            viewsLast = jEdit.viewsLast.prev;
            view.prev.next = null;
        } else {
            view.next.prev = view.prev;
        }
    }

    private static void closeView(View view, boolean callExit) {
        PerspectiveManager.setPerspectiveDirty(true);
        if (viewsFirst == viewsLast && callExit) {
            jEdit.exit(view, false);
        } else {
            EditBus.send(new ViewUpdate(view, ViewUpdate.CLOSED));
            view.close();
            jEdit.removeViewFromList(view);
            if (view == activeView) {
                activeView = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadModeCatalog(String path, boolean resource) {
        block14: {
            Log.log(3, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, "Loading mode catalog file " + path);
            ModeCatalogHandler handler = new ModeCatalogHandler(MiscUtilities.getParentOfPath(path), resource);
            XmlParser parser = new XmlParser();
            parser.setHandler(handler);
            Reader in = null;
            InputStream _in = resource ? (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResourceAsStream(path) : new FileInputStream(path);
            in = new BufferedReader(new InputStreamReader(_in));
            parser.parse(null, null, in);
            Object var9_8 = null;
            try {
                if (in != null) {
                    in.close();
                }
                break block14;
            }
            catch (IOException io) {
                Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
            }
            break block14;
            {
                catch (XmlException xe) {
                    int line = xe.getLine();
                    String message = xe.getMessage();
                    Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, path + ":" + line + ": " + message);
                    Object var9_9 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
                    }
                    break block14;
                }
                catch (Exception e) {
                    Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, e);
                    Object var9_10 = null;
                    try {
                        if (in != null) {
                            in.close();
                        }
                        break block14;
                    }
                    catch (IOException io) {
                        Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (IOException io) {
                    Log.log(9, class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = jEdit.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit, io);
                }
                throw throwable;
            }
        }
    }

    private static void initKeyBindings() {
        inputHandler.removeAllKeyBindings();
        ActionSet[] actionSets = jEdit.getActionSets();
        for (int i = 0; i < actionSets.length; ++i) {
            actionSets[i].initKeyBindings();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        pluginErrorLock = new Object();
        bufferListLock = new Object();
    }

    static class FirewallAuthenticator
    extends Authenticator {
        PasswordAuthentication pw;

        public FirewallAuthenticator(PasswordAuthentication pw) {
            this.pw = pw;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.pw;
        }
    }
}

