/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.EditPlugin;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;
import org.gjt.sp.util.Log;

public class PluginsProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return false;
    }

    public void update(JMenu menu) {
        int i;
        int count = 0;
        List[] letters = new List[26];
        for (int i2 = 0; i2 < letters.length; ++i2) {
            letters[i2] = new ArrayList();
        }
        Vector pluginMenuItems = new Vector();
        PluginJAR[] pluginArray = jEdit.getPluginJARs();
        for (i = 0; i < pluginArray.length; ++i) {
            PluginJAR jar = pluginArray[i];
            EditPlugin plugin = jar.getPlugin();
            if (plugin == null) continue;
            JMenuItem menuItem = plugin.createMenuItems();
            if (menuItem != null) {
                this.addToLetterMap(letters, menuItem);
                ++count;
                continue;
            }
            if (jEdit.getProperty("plugin." + plugin.getClassName() + ".activate") != null) continue;
            try {
                pluginMenuItems.clear();
                plugin.createMenuItems(pluginMenuItems);
                Iterator iter = pluginMenuItems.iterator();
                while (iter.hasNext()) {
                    this.addToLetterMap(letters, (JMenuItem)iter.next());
                    ++count;
                }
                continue;
            }
            catch (Throwable t) {
                Log.log(9, this, "Error creating menu items for plugin");
                Log.log(9, this, t);
            }
        }
        if (count == 0) {
            JMenuItem menuItem = new JMenuItem(jEdit.getProperty("no-plugins.label"));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            return;
        }
        for (i = 0; i < letters.length; ++i) {
            List list = letters[i];
            Collections.sort(list, new MiscUtilities.MenuItemCompare());
        }
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        if (count <= maxItems) {
            for (int i3 = 0; i3 < letters.length; ++i3) {
                Iterator iter = letters[i3].iterator();
                while (iter.hasNext()) {
                    menu.add((JMenuItem)iter.next());
                }
            }
            return;
        }
        count = 0;
        char first = 'A';
        JMenu submenu = new JMenu();
        menu.add(submenu);
        for (int i4 = 0; i4 < letters.length; ++i4) {
            List letter = letters[i4];
            if (count + letter.size() > maxItems && count != 0) {
                char last = (char)(i4 + 65 - 1);
                if (last == first) {
                    submenu.setText(String.valueOf(first));
                } else {
                    submenu.setText(first + " - " + last);
                }
                first = (char)(i4 + 65);
                count = 0;
                submenu = null;
            }
            Iterator iter = letter.iterator();
            while (iter.hasNext()) {
                if (submenu == null) {
                    submenu = new JMenu();
                    menu.add(submenu);
                }
                submenu.add((JMenuItem)iter.next());
            }
            count += letter.size();
        }
        if (submenu != null) {
            char last = 'Z';
            if (last == first) {
                submenu.setText(String.valueOf(first));
            } else {
                submenu.setText(first + " - " + last);
            }
        }
    }

    private void addToLetterMap(List[] letters, JMenuItem item) {
        char ch = item.getText().charAt(0);
        if ((ch = Character.toUpperCase(ch)) < 'A' || ch > 'Z') {
            Log.log(9, this, "Plugin menu item label must begin with A - Z, or a - z: " + item.getText());
        } else {
            letters[ch - 65].add(item);
        }
    }
}

