/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.FileCellRenderer;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class RecentFilesProvider
implements DynamicMenuProvider {
    public boolean updateEveryTime() {
        return false;
    }

    public void update(JMenu menu) {
        final View view = GUIUtilities.getView(menu);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                jEdit.openFile(view, evt.getActionCommand());
                view.getStatus().setMessage(null);
            }
        };
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseEntered(MouseEvent evt) {
                view.getStatus().setMessage(((JMenuItem)evt.getSource()).getActionCommand());
            }

            public void mouseExited(MouseEvent evt) {
                view.getStatus().setMessage(null);
            }
        };
        List recentVector = BufferHistory.getHistory();
        if (recentVector.size() == 0) {
            JMenuItem menuItem = new JMenuItem(jEdit.getProperty("no-recent-files.label"));
            menuItem.setEnabled(false);
            menu.add(menuItem);
            return;
        }
        Vector<JMenuItem> menuItems = new Vector<JMenuItem>();
        boolean sort = jEdit.getBooleanProperty("sortRecent");
        int maxItems = jEdit.getIntegerProperty("menu.spillover", 20);
        Iterator iter = recentVector.iterator();
        while (iter.hasNext()) {
            String path = ((BufferHistory.Entry)iter.next()).path;
            JMenuItem menuItem = new JMenuItem(MiscUtilities.getFileName(path));
            menuItem.setActionCommand(path);
            menuItem.addActionListener(actionListener);
            menuItem.addMouseListener(mouseListener);
            menuItem.setIcon(FileCellRenderer.fileIcon);
            if (sort) {
                menuItems.addElement(menuItem);
                continue;
            }
            if (menu.getMenuComponentCount() >= maxItems && iter.hasNext()) {
                JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                menu.add(newMenu);
                menu = newMenu;
            }
            menu.add(menuItem);
        }
        if (sort) {
            MiscUtilities.quicksort(menuItems, (MiscUtilities.Compare)new MiscUtilities.MenuItemCompare());
            for (int i = 0; i < menuItems.size(); ++i) {
                if (menu.getMenuComponentCount() >= maxItems && i != 0) {
                    JMenu newMenu = new JMenu(jEdit.getProperty("common.more"));
                    menu.add(newMenu);
                    menu = newMenu;
                }
                menu.add((JMenuItem)menuItems.elementAt(i));
            }
        }
    }
}

