/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.options.Abbrev;

class AbbrevsModel
extends AbstractTableModel {
    Vector abbrevs = new Vector();
    int lastSort;

    AbbrevsModel(Hashtable abbrevHash) {
        if (abbrevHash != null) {
            Enumeration abbrevEnum = abbrevHash.keys();
            Enumeration expandEnum = abbrevHash.elements();
            while (abbrevEnum.hasMoreElements()) {
                this.abbrevs.addElement(new Abbrev((String)abbrevEnum.nextElement(), (String)expandEnum.nextElement()));
            }
            this.sort(0);
        }
    }

    void sort(int col) {
        this.lastSort = col;
        MiscUtilities.quicksort(this.abbrevs, (MiscUtilities.Compare)new AbbrevCompare(col));
        this.fireTableDataChanged();
    }

    void add(String abbrev, String expansion) {
        this.abbrevs.addElement(new Abbrev(abbrev, expansion));
        this.sort(this.lastSort);
    }

    void remove(int index) {
        this.abbrevs.removeElementAt(index);
        this.fireTableStructureChanged();
    }

    public Hashtable toHashtable() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (int i = 0; i < this.abbrevs.size(); ++i) {
            Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(i);
            if (abbrev.abbrev.length() <= 0 || abbrev.expand.length() <= 0) continue;
            hash.put(abbrev.abbrev, abbrev.expand);
        }
        return hash;
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.abbrevs.size();
    }

    public Object getValueAt(int row, int col) {
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(row);
        switch (col) {
            case 0: {
                return abbrev.abbrev;
            }
            case 1: {
                return abbrev.expand;
            }
        }
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object value, int row, int col) {
        if (value == null) {
            value = "";
        }
        Abbrev abbrev = (Abbrev)this.abbrevs.elementAt(row);
        if (col == 0) {
            abbrev.abbrev = (String)value;
        } else {
            abbrev.expand = (String)value;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.abbrevs.abbrev");
            }
            case 1: {
                return jEdit.getProperty("options.abbrevs.expand");
            }
        }
        return null;
    }

    class AbbrevCompare
    implements MiscUtilities.Compare {
        int col;

        AbbrevCompare(int col) {
            this.col = col;
        }

        public int compare(Object obj1, Object obj2) {
            Abbrev a1 = (Abbrev)obj1;
            Abbrev a2 = (Abbrev)obj2;
            if (this.col == 0) {
                String abbrev1 = a1.abbrev.toLowerCase();
                String abbrev2 = a2.abbrev.toLowerCase();
                return MiscUtilities.compareStrings(abbrev1, abbrev2, true);
            }
            String expand1 = a1.expand.toLowerCase();
            String expand2 = a2.expand.toLowerCase();
            return MiscUtilities.compareStrings(expand1, expand2, true);
        }
    }
}

