/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.gui.FontSelector;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class AppearanceOptionPane
extends AbstractOptionPane {
    private UIManager.LookAndFeelInfo[] lfs;
    private JComboBox lookAndFeel;
    private FontSelector primaryFont;
    private FontSelector secondaryFont;
    private JTextField history;
    private JTextField menuSpillover;
    private JCheckBox showTips;
    private JCheckBox showSplash;
    private JCheckBox textColors;
    private JCheckBox decorateFrames;
    private JCheckBox decorateDialogs;

    public AppearanceOptionPane() {
        super("appearance");
    }

    protected void _init() {
        this.addComponent(new JLabel(jEdit.getProperty("options.appearance.lf.note")));
        this.lfs = UIManager.getInstalledLookAndFeels();
        String[] names = new String[this.lfs.length];
        String lf = UIManager.getLookAndFeel().getClass().getName();
        int index = 0;
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.lfs[i].getName();
            if (!lf.equals(this.lfs[i].getClassName())) continue;
            index = i;
        }
        this.lookAndFeel = new JComboBox<String>(names);
        this.lookAndFeel.setSelectedIndex(index);
        this.lookAndFeel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AppearanceOptionPane.this.updateEnabled();
            }
        });
        this.addComponent(jEdit.getProperty("options.appearance.lf"), (Component)this.lookAndFeel);
        this.primaryFont = new FontSelector(jEdit.getFontProperty("metal.primary.font"));
        this.addComponent(jEdit.getProperty("options.appearance.primaryFont"), (Component)this.primaryFont);
        this.secondaryFont = new FontSelector(jEdit.getFontProperty("metal.secondary.font"));
        this.addComponent(jEdit.getProperty("options.appearance.secondaryFont"), (Component)this.secondaryFont);
        this.updateEnabled();
        this.history = new JTextField(jEdit.getProperty("history"));
        this.addComponent(jEdit.getProperty("options.appearance.history"), (Component)this.history);
        this.menuSpillover = new JTextField(jEdit.getProperty("menu.spillover"));
        this.addComponent(jEdit.getProperty("options.appearance.menuSpillover"), (Component)this.menuSpillover);
        this.addSeparator("options.appearance.startup.label");
        this.showSplash = new JCheckBox(jEdit.getProperty("options.appearance.showSplash"));
        String settingsDirectory = jEdit.getSettingsDirectory();
        if (settingsDirectory == null) {
            this.showSplash.setSelected(true);
        } else {
            this.showSplash.setSelected(!new File(settingsDirectory, "nosplash").exists());
        }
        this.addComponent(this.showSplash);
        this.showTips = new JCheckBox(jEdit.getProperty("options.appearance.showTips"));
        this.showTips.setSelected(jEdit.getBooleanProperty("tip.show"));
        this.addComponent(this.showTips);
        this.addSeparator("options.appearance.experimental.label");
        this.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("options.appearance.experimental.caption")));
        this.textColors = new JCheckBox(jEdit.getProperty("options.appearance.textColors"));
        this.textColors.setSelected(jEdit.getBooleanProperty("textColors"));
        this.addComponent(this.textColors);
        this.decorateFrames = new JCheckBox(jEdit.getProperty("options.appearance.decorateFrames"));
        this.decorateFrames.setSelected(jEdit.getBooleanProperty("decorate.frames"));
        this.decorateDialogs = new JCheckBox(jEdit.getProperty("options.appearance.decorateDialogs"));
        this.decorateDialogs.setSelected(jEdit.getBooleanProperty("decorate.dialogs"));
        if (OperatingSystem.hasJava14()) {
            this.addComponent(this.decorateFrames);
            this.addComponent(this.decorateDialogs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void _save() {
        block14: {
            String lf = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
            jEdit.setProperty("lookAndFeel", lf);
            jEdit.setFontProperty("metal.primary.font", this.primaryFont.getFont());
            jEdit.setFontProperty("metal.secondary.font", this.secondaryFont.getFont());
            jEdit.setProperty("history", this.history.getText());
            jEdit.setProperty("menu.spillover", this.menuSpillover.getText());
            jEdit.setBooleanProperty("tip.show", this.showTips.isSelected());
            String settingsDirectory = jEdit.getSettingsDirectory();
            if (settingsDirectory != null) {
                FileOutputStream out;
                File file = new File(settingsDirectory, "nosplash");
                if (this.showSplash.isSelected()) {
                    file.delete();
                } else {
                    out = null;
                    out = new FileOutputStream(file);
                    out.write(10);
                    out.close();
                    Object var7_5 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                        break block14;
                    }
                    catch (IOException e) {}
                }
                break block14;
                {
                    catch (IOException io) {
                        Log.log(9, this, io);
                        Object var7_6 = null;
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block14;
                        }
                        catch (IOException e) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        jEdit.setBooleanProperty("textColors", this.textColors.isSelected());
        jEdit.setBooleanProperty("decorate.frames", this.decorateFrames.isSelected());
        jEdit.setBooleanProperty("decorate.dialogs", this.decorateDialogs.isSelected());
    }

    private void updateEnabled() {
        String className = this.lfs[this.lookAndFeel.getSelectedIndex()].getClassName();
        if (className.equals("javax.swing.plaf.metal.MetalLookAndFeel") || className.equals("com.incors.plaf.kunststoff.KunststoffLookAndFeel")) {
            this.primaryFont.setEnabled(true);
            this.secondaryFont.setEnabled(true);
        } else {
            this.primaryFont.setEnabled(false);
            this.secondaryFont.setEnabled(false);
        }
    }
}

