/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.gui.DockableWindowManager;
import org.gjt.sp.jedit.jEdit;

class WindowTableModel
extends AbstractTableModel {
    private Vector windows = new Vector();
    static /* synthetic */ Class class$java$lang$String;

    WindowTableModel() {
        String[] dockables = DockableWindowManager.getRegisteredDockableWindows();
        for (int i = 0; i < dockables.length; ++i) {
            this.windows.addElement(new Entry(dockables[i]));
        }
        this.sort();
    }

    public void sort() {
        MiscUtilities.quicksort(this.windows, (MiscUtilities.Compare)new WindowCompare());
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.windows.size();
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 0: 
            case 1: {
                return class$java$lang$String == null ? (class$java$lang$String = WindowTableModel.class$("java.lang.String")) : class$java$lang$String;
            }
        }
        throw new InternalError();
    }

    public Object getValueAt(int row, int col) {
        Entry window = (Entry)this.windows.elementAt(row);
        switch (col) {
            case 0: {
                return window.title;
            }
            case 1: {
                return window.dockPosition;
            }
        }
        throw new InternalError();
    }

    public boolean isCellEditable(int row, int col) {
        return col != 0;
    }

    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            return;
        }
        Entry window = (Entry)this.windows.elementAt(row);
        switch (col) {
            case 1: {
                window.dockPosition = (String)value;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        this.fireTableRowsUpdated(row, row);
    }

    public String getColumnName(int index) {
        switch (index) {
            case 0: {
                return jEdit.getProperty("options.docking.title");
            }
            case 1: {
                return jEdit.getProperty("options.docking.dockPosition");
            }
        }
        throw new InternalError();
    }

    public void save() {
        for (int i = 0; i < this.windows.size(); ++i) {
            ((Entry)this.windows.elementAt(i)).save();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WindowCompare
    implements MiscUtilities.Compare {
        WindowCompare() {
        }

        public int compare(Object obj1, Object obj2) {
            Entry e1 = (Entry)obj1;
            Entry e2 = (Entry)obj2;
            return MiscUtilities.compareStrings(e1.title, e2.title, true);
        }
    }

    class Entry {
        String name;
        String title;
        String dockPosition;

        Entry(String name) {
            this.name = name;
            this.title = jEdit.getProperty(name + ".title");
            if (this.title == null) {
                this.title = name;
            }
            this.dockPosition = jEdit.getProperty(name + ".dock-position");
            if (this.dockPosition == null) {
                this.dockPosition = "floating";
            }
        }

        void save() {
            jEdit.setProperty(this.name + ".dock-position", this.dockPosition);
        }
    }
}

