/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.pluginmgr;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginList;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.jedit.pluginmgr.PluginManagerProgress;
import org.gjt.sp.jedit.pluginmgr.Roster;

class InstallPanel
extends JPanel {
    private JTable table;
    private PluginTableModel pluginModel;
    private PluginManager window;
    private PluginInfoBox infoBox;
    private boolean updates;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Boolean;

    InstallPanel(PluginManager window, boolean updates) {
        super(new BorderLayout(12, 12));
        this.window = window;
        this.updates = updates;
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        final JSplitPane split = new JSplitPane(0, true);
        this.pluginModel = new PluginTableModel();
        this.table = new JTable(this.pluginModel);
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setRowHeight(this.table.getRowHeight() + 2);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        this.table.setRequestFocusEnabled(false);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = InstallPanel.class$("java.lang.Object")) : class$java$lang$Object, new TextRenderer((DefaultTableCellRenderer)this.table.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = InstallPanel.class$("java.lang.Object")) : class$java$lang$Object)));
        TableColumn col1 = this.table.getColumnModel().getColumn(0);
        TableColumn col2 = this.table.getColumnModel().getColumn(1);
        TableColumn col3 = this.table.getColumnModel().getColumn(2);
        TableColumn col4 = this.table.getColumnModel().getColumn(3);
        TableColumn col5 = this.table.getColumnModel().getColumn(4);
        col1.setPreferredWidth(30);
        col1.setMinWidth(30);
        col1.setMaxWidth(30);
        col1.setResizable(false);
        col2.setPreferredWidth(180);
        col3.setPreferredWidth(130);
        col4.setPreferredWidth(70);
        col5.setPreferredWidth(70);
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        header.addMouseListener(new HeaderMouseHandler());
        JScrollPane scrollpane = new JScrollPane(this.table);
        scrollpane.getViewport().setBackground(this.table.getBackground());
        split.setTopComponent(scrollpane);
        this.infoBox = new PluginInfoBox();
        JScrollPane infoPane = new JScrollPane(this.infoBox);
        infoPane.setPreferredSize(new Dimension(500, 100));
        split.setBottomComponent(infoPane);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                split.setDividerLocation(0.75);
            }
        });
        this.add("Center", split);
        Box buttons = new Box(0);
        buttons.add(new InstallButton());
        buttons.add(Box.createHorizontalStrut(12));
        buttons.add(new SelectallButton());
        buttons.add(Box.createGlue());
        buttons.add(new SizeLabel());
        this.add("South", buttons);
    }

    public void updateModel() {
        this.pluginModel.clear();
        this.infoBox.setText(jEdit.getProperty("plugin-manager.list-download"));
        VFSManager.runInAWTThread(new Runnable(){

            public void run() {
                InstallPanel.this.infoBox.setText(null);
                InstallPanel.this.pluginModel.update();
            }
        });
    }

    private String formatSize(int size) {
        NumberFormat df = NumberFormat.getInstance();
        df.setMaximumFractionDigits(1);
        df.setMinimumFractionDigits(0);
        String sizeText = size < 0x100000 ? size / 1024 + "KB" : df.format((double)size / 1048576.0) + "MB";
        return sizeText;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class TextRenderer
    extends DefaultTableCellRenderer {
        private DefaultTableCellRenderer tcr;

        public TextRenderer(DefaultTableCellRenderer tcr) {
            this.tcr = tcr;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.tcr.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    }

    class HeaderMouseHandler
    extends MouseAdapter {
        HeaderMouseHandler() {
        }

        public void mouseClicked(MouseEvent evt) {
            switch (InstallPanel.this.table.getTableHeader().columnAtPoint(evt.getPoint())) {
                case 1: {
                    InstallPanel.this.pluginModel.sort(0);
                    break;
                }
                case 2: {
                    InstallPanel.this.pluginModel.sort(1);
                    break;
                }
            }
        }
    }

    static class EntryCompare
    implements Comparator {
        public static final int NAME = 0;
        public static final int CATEGORY = 1;
        private int type;

        public EntryCompare(int type) {
            this.type = type;
        }

        public int compare(Object o1, Object o2) {
            Entry e1 = (Entry)o1;
            Entry e2 = (Entry)o2;
            if (this.type == 0) {
                return e1.name.compareToIgnoreCase(e2.name);
            }
            int result = e1.set.compareToIgnoreCase(e2.set);
            if (result == 0) {
                return e1.name.compareToIgnoreCase(e2.name);
            }
            return result;
        }
    }

    class InstallButton
    extends JButton
    implements ActionListener,
    TableModelListener {
        public InstallButton() {
            super(jEdit.getProperty("install-plugins.install"));
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.addActionListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent evt) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            boolean downloadSource = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            boolean installUser = jEdit.getBooleanProperty("plugin-manager.installUser");
            Roster roster = new Roster();
            String installDirectory = installUser ? MiscUtilities.constructPath(jEdit.getSettingsDirectory(), "jars") : MiscUtilities.constructPath(jEdit.getJEditHome(), "jars");
            int length = InstallPanel.this.pluginModel.getRowCount();
            int instcount = 0;
            for (int i = 0; i < length; ++i) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                if (!entry.install) continue;
                entry.plugin.install(roster, installDirectory, downloadSource);
                if (InstallPanel.this.updates) {
                    entry.plugin.getCompatibleBranch().satisfyDependencies(roster, installDirectory, downloadSource);
                }
                ++instcount;
            }
            if (roster.isEmpty()) {
                return;
            }
            boolean cancel = false;
            if (InstallPanel.this.updates && roster.getOperationCount() > instcount && GUIUtilities.confirm(InstallPanel.this.window, "install-plugins.depend", null, 2, 2) == 2) {
                cancel = true;
            }
            if (!cancel) {
                new PluginManagerProgress(InstallPanel.this.window, roster);
                roster.performOperationsInAWTThread(InstallPanel.this.window);
                InstallPanel.this.pluginModel.update();
            }
        }

        public void tableChanged(TableModelEvent e) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            if (e.getType() == 0) {
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    if (!((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setEnabled(true);
                    return;
                }
                this.setEnabled(false);
            }
        }
    }

    class SelectallButton
    extends JCheckBox
    implements ActionListener,
    TableModelListener {
        public SelectallButton() {
            super(jEdit.getProperty("install-plugins.select-all"));
            this.addActionListener(this);
            InstallPanel.this.pluginModel.addTableModelListener(this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent evt) {
            InstallPanel.this.pluginModel.setSelectAll(this.isSelected());
        }

        public void tableChanged(TableModelEvent e) {
            if (InstallPanel.this.pluginModel.isDownloadingList()) {
                return;
            }
            this.setEnabled(InstallPanel.this.pluginModel.getRowCount() != 0);
            if (e.getType() == 0) {
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    if (((Boolean)InstallPanel.this.pluginModel.getValueAt(i, 0)).booleanValue()) continue;
                    this.setSelected(false);
                    return;
                }
                if (length > 0) {
                    this.setSelected(true);
                }
            }
        }
    }

    class SizeLabel
    extends JLabel
    implements TableModelListener {
        private int size = 0;

        public SizeLabel() {
            this.setText(jEdit.getProperty("install-plugins.totalSize") + InstallPanel.this.formatSize(this.size));
            InstallPanel.this.pluginModel.addTableModelListener(this);
        }

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                if (InstallPanel.this.pluginModel.isDownloadingList()) {
                    return;
                }
                this.size = 0;
                int length = InstallPanel.this.pluginModel.getRowCount();
                for (int i = 0; i < length; ++i) {
                    Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(i);
                    if (!entry.install) continue;
                    this.size += entry.size;
                }
                this.setText(jEdit.getProperty("install-plugins.totalSize") + InstallPanel.this.formatSize(this.size));
            }
        }
    }

    class PluginInfoBox
    extends JTextArea
    implements ListSelectionListener {
        public PluginInfoBox() {
            this.setEditable(false);
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
            InstallPanel.this.table.getSelectionModel().addListSelectionListener(this);
        }

        public void valueChanged(ListSelectionEvent e) {
            String text = "";
            if (InstallPanel.this.table.getSelectedRowCount() == 1) {
                Entry entry = (Entry)InstallPanel.this.pluginModel.entries.get(InstallPanel.this.table.getSelectedRow());
                text = jEdit.getProperty("install-plugins.info", new String[]{entry.author, entry.date, entry.description});
            }
            this.setText(text);
            this.setCaretPosition(0);
        }
    }

    class Entry {
        String name;
        String version;
        String author;
        String date;
        String description;
        String set;
        int size;
        boolean install;
        PluginList.Plugin plugin;
        LinkedList parents = new LinkedList();

        Entry(PluginList.Plugin plugin, String set) {
            PluginList.Branch branch = plugin.getCompatibleBranch();
            boolean downloadSource = jEdit.getBooleanProperty("plugin-manager.downloadSource");
            int size = downloadSource ? branch.downloadSourceSize : branch.downloadSize;
            this.name = plugin.name;
            this.author = plugin.author;
            this.version = branch.version;
            this.size = size;
            this.date = branch.date;
            this.description = plugin.description;
            this.set = set;
            this.install = false;
            this.plugin = plugin;
        }

        String getParentString() {
            StringBuffer buf = new StringBuffer();
            Iterator iter = this.parents.iterator();
            while (iter.hasNext()) {
                buf.append(((Entry)iter.next()).name);
                if (!iter.hasNext()) continue;
                buf.append('\n');
            }
            return buf.toString();
        }
    }

    class PluginTableModel
    extends AbstractTableModel {
        private ArrayList entries = new ArrayList();
        private int sortType = 1;

        PluginTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return class$java$lang$Boolean == null ? (class$java$lang$Boolean = InstallPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    return class$java$lang$Object == null ? (class$java$lang$Object = InstallPanel.class$("java.lang.Object")) : class$java$lang$Object;
                }
            }
            throw new Error("Column out of range");
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return " " + jEdit.getProperty("install-plugins.info.name");
                }
                case 2: {
                    return " " + jEdit.getProperty("install-plugins.info.category");
                }
                case 3: {
                    return " " + jEdit.getProperty("install-plugins.info.version");
                }
                case 4: {
                    return " " + jEdit.getProperty("install-plugins.info.size");
                }
            }
            throw new Error("Column out of range");
        }

        public int getRowCount() {
            return this.entries.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            Object obj = this.entries.get(rowIndex);
            if (obj instanceof String) {
                if (columnIndex == 1) {
                    return obj;
                }
                return null;
            }
            Entry entry = (Entry)obj;
            switch (columnIndex) {
                case 0: {
                    return new Boolean(entry.install);
                }
                case 1: {
                    return entry.name;
                }
                case 2: {
                    return entry.set;
                }
                case 3: {
                    return entry.version;
                }
                case 4: {
                    return InstallPanel.this.formatSize(entry.size);
                }
            }
            throw new Error("Column out of range");
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public void setSelectAll(boolean b) {
            if (this.isDownloadingList()) {
                return;
            }
            int length = this.getRowCount();
            for (int i = 0; i < length; ++i) {
                if (b) {
                    this.setValueAt(Boolean.TRUE, i, 0);
                    continue;
                }
                Entry entry = (Entry)this.entries.get(i);
                entry.parents = new LinkedList();
                entry.install = false;
            }
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void setSortType(int type) {
            this.sortType = type;
            this.sort(type);
        }

        public void setValueAt(Object aValue, int row, int column) {
            if (column != 0) {
                return;
            }
            Object obj = this.entries.get(row);
            if (obj instanceof String) {
                return;
            }
            Entry entry = (Entry)obj;
            Vector deps = entry.plugin.getCompatibleBranch().deps;
            boolean value = (Boolean)aValue;
            if (!value && entry.parents.size() > 0) {
                Object[] args = new String[]{entry.name, entry.getParentString()};
                int result = GUIUtilities.confirm(InstallPanel.this.window, "plugin-manager.dependency", args, 2, 2);
                if (result != 0) {
                    return;
                }
                Iterator parentsIter = entry.parents.iterator();
                while (parentsIter.hasNext()) {
                    ((Entry)parentsIter.next()).install = false;
                }
                this.fireTableRowsUpdated(0, this.getRowCount() - 1);
            }
            for (int i = 0; i < deps.size(); ++i) {
                PluginList.Dependency dep = (PluginList.Dependency)deps.elementAt(i);
                if (!dep.what.equals("plugin")) continue;
                for (int j = 0; j < this.entries.size(); ++j) {
                    Entry temp = (Entry)this.entries.get(j);
                    if (temp.plugin != dep.plugin) continue;
                    if (value) {
                        temp.parents.add(entry);
                        this.setValueAt(Boolean.TRUE, j, 0);
                        continue;
                    }
                    temp.parents.remove(entry);
                }
            }
            entry.install = Boolean.TRUE.equals(aValue);
            this.fireTableCellUpdated(row, column);
        }

        public void sort(int type) {
            this.sortType = type;
            if (this.isDownloadingList()) {
                return;
            }
            Collections.sort(this.entries, new EntryCompare(type));
            this.fireTableChanged(new TableModelEvent(this));
        }

        private boolean isDownloadingList() {
            return this.entries.size() == 1 && this.entries.get(0) instanceof String;
        }

        public void clear() {
            this.entries = new ArrayList();
            this.fireTableChanged(new TableModelEvent(this));
        }

        public void update() {
            PluginList pluginList = InstallPanel.this.window.getPluginList();
            if (pluginList == null) {
                return;
            }
            this.entries = new ArrayList();
            for (int i = 0; i < pluginList.pluginSets.size(); ++i) {
                PluginList.PluginSet set = (PluginList.PluginSet)pluginList.pluginSets.get(i);
                for (int j = 0; j < set.plugins.size(); ++j) {
                    PluginList.Plugin plugin = (PluginList.Plugin)pluginList.pluginHash.get(set.plugins.get(j));
                    PluginList.Branch branch = plugin.getCompatibleBranch();
                    String installedVersion = plugin.getInstalledVersion();
                    if (InstallPanel.this.updates) {
                        if (branch == null || !branch.canSatisfyDependencies() || installedVersion == null || MiscUtilities.compareStrings(branch.version, installedVersion, false) <= 0) continue;
                        this.entries.add(new Entry(plugin, set.name));
                        continue;
                    }
                    if (installedVersion != null || !plugin.canBeInstalled()) continue;
                    this.entries.add(new Entry(plugin, set.name));
                }
            }
            this.sort(this.sortType);
            this.fireTableChanged(new TableModelEvent(this));
        }
    }
}

