/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.proto.jeditresource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.PluginJAR;
import org.gjt.sp.jedit.jEdit;

public class PluginResURLConnection
extends URLConnection {
    private InputStream in;
    private String plugin;
    private String resource;
    static /* synthetic */ Class class$org$gjt$sp$jedit$jEdit;

    public PluginResURLConnection(URL url) throws IOException {
        super(url);
        String file = url.getFile();
        int index = file.indexOf(33, 0);
        if (index == -1) {
            this.plugin = null;
            this.resource = file;
        } else {
            int start = file.charAt(0) == '/' ? 1 : 0;
            this.plugin = file.substring(start, index);
            this.resource = file.substring(index + 1);
        }
        if (this.plugin != null && this.resource.startsWith("/")) {
            this.resource = this.resource.substring(1);
        }
    }

    public void connect() throws IOException {
        if (!this.connected) {
            if (this.plugin == null) {
                this.in = (class$org$gjt$sp$jedit$jEdit == null ? (class$org$gjt$sp$jedit$jEdit = PluginResURLConnection.class$("org.gjt.sp.jedit.jEdit")) : class$org$gjt$sp$jedit$jEdit).getResourceAsStream(this.resource);
            } else {
                PluginJAR[] plugins = jEdit.getPluginJARs();
                for (int i = 0; i < plugins.length; ++i) {
                    PluginJAR jar = plugins[i];
                    if (!MiscUtilities.getFileName(jar.getPath()).equalsIgnoreCase(this.plugin)) continue;
                    this.in = jar.getClassLoader().getResourceAsStream(this.resource);
                    break;
                }
            }
            if (this.in == null) {
                throw new IOException("Resource not found: " + this.resource);
            }
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.in;
    }

    public String getHeaderField(String name) {
        if (name.equals("content-type")) {
            String lcResource = this.resource.toLowerCase();
            if (lcResource.endsWith(".html")) {
                return "text/html";
            }
            if (lcResource.endsWith(".txt")) {
                return "text/plain";
            }
            if (lcResource.endsWith(".rtf")) {
                return "text/rtf";
            }
            if (lcResource.endsWith(".gif")) {
                return "image/gif";
            }
            if (lcResource.endsWith(".jpg") || lcResource.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            return null;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

