/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import gnu.regexp.CharIndexed;
import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import gnu.regexp.RESyntax;
import org.gjt.sp.jedit.search.SearchMatcher;

public class RESearchMatcher
extends SearchMatcher {
    public static final RESyntax RE_SYNTAX_JEDIT = new RESyntax(RESyntax.RE_SYNTAX_PERL5).set(2).setLineSeparator("\n");
    private RE re;

    public RESearchMatcher(String search, boolean ignoreCase) throws REException {
        this.re = new RE(search, (ignoreCase ? 2 : 0) | 8, RE_SYNTAX_JEDIT);
        this.returnValue = new SearchMatcher.Match();
    }

    public SearchMatcher.Match nextMatch(CharIndexed text, boolean start, boolean end, boolean firstTime, boolean reverse) {
        REMatch match;
        int flags = 0;
        if (!start) {
            flags |= 0x10;
        }
        if (!end) {
            flags |= 0x20;
        }
        if ((match = this.re.getMatch(text, 0, flags)) == null) {
            return null;
        }
        this.returnValue.substitutions = new String[this.re.getNumSubs() + 1];
        for (int i = 0; i < this.returnValue.substitutions.length; ++i) {
            this.returnValue.substitutions[i] = match.toString(i);
        }
        int _start = match.getStartIndex();
        int _end = match.getEndIndex();
        if (!firstTime && _start == 0 && _end == 0) {
            text.move(1);
            if (text.charAt(0) == '\uffff') {
                return null;
            }
            match = this.re.getMatch(text, 0, flags | 0x10);
            if (match == null) {
                return null;
            }
            _start = match.getStartIndex() + 1;
            _end = match.getEndIndex() + 1;
        }
        this.returnValue.start = _start;
        this.returnValue.end = _end;
        return this.returnValue;
    }
}

