/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchDialog;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.Log;

public class SearchBar
extends JPanel {
    private View view;
    private HistoryTextField find;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox hyperSearch;
    private Timer timer;
    private RolloverButton close;
    private int searchStart;
    private boolean searchReverse;
    private boolean temp;

    public SearchBar(final View view, boolean temp) {
        this.setLayout(new BoxLayout(this, 0));
        this.view = view;
        this.add(Box.createHorizontalStrut(2));
        JLabel label = new JLabel(jEdit.getProperty("view.search.find"));
        this.add(label);
        this.add(Box.createHorizontalStrut(12));
        this.find = new HistoryTextField("find");
        this.add(this.find);
        this.find.setSelectAllOnFocus(true);
        Dimension max = this.find.getPreferredSize();
        max.width = Integer.MAX_VALUE;
        this.find.setMaximumSize(max);
        ActionHandler actionHandler = new ActionHandler();
        this.find.addKeyListener(new KeyHandler());
        this.find.addActionListener(actionHandler);
        this.find.getDocument().addDocumentListener(new DocumentHandler());
        Insets margin = new Insets(1, 1, 1, 1);
        this.add(Box.createHorizontalStrut(12));
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.case"));
        this.add(this.ignoreCase);
        this.ignoreCase.addActionListener(actionHandler);
        this.ignoreCase.setMargin(margin);
        this.ignoreCase.setRequestFocusEnabled(false);
        this.add(Box.createHorizontalStrut(2));
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"));
        this.add(this.regexp);
        this.regexp.addActionListener(actionHandler);
        this.regexp.setMargin(margin);
        this.regexp.setRequestFocusEnabled(false);
        this.add(Box.createHorizontalStrut(2));
        this.hyperSearch = new JCheckBox(jEdit.getProperty("search.hypersearch"));
        this.add(this.hyperSearch);
        this.hyperSearch.addActionListener(actionHandler);
        this.hyperSearch.setMargin(margin);
        this.hyperSearch.setRequestFocusEnabled(false);
        this.update();
        this.timer = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!SearchBar.this.incrementalSearch(SearchBar.this.searchStart, SearchBar.this.searchReverse) && !SearchBar.this.incrementalSearch(SearchBar.this.searchReverse ? view.getBuffer().getLength() : 0, SearchBar.this.searchReverse)) {
                    view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                }
            }
        });
        this.temp = temp;
        this.propertiesChanged();
    }

    public HistoryTextField getField() {
        return this.find;
    }

    public void setHyperSearch(boolean hyperSearch) {
        jEdit.setBooleanProperty("view.search.hypersearch.toggle", hyperSearch);
        this.hyperSearch.setSelected(hyperSearch);
    }

    public void update() {
        this.ignoreCase.setSelected(SearchAndReplace.getIgnoreCase());
        this.regexp.setSelected(SearchAndReplace.getRegexp());
        this.hyperSearch.setSelected(jEdit.getBooleanProperty("view.search.hypersearch.toggle"));
    }

    public void propertiesChanged() {
        if (this.temp) {
            if (this.close == null) {
                this.close = new RolloverButton(GUIUtilities.loadIcon("closebox.gif"));
                this.close.addActionListener(new ActionHandler());
                this.close.setToolTipText(jEdit.getProperty("view.search.close-tooltip"));
            }
            this.add(this.close);
        } else if (this.close != null) {
            this.remove(this.close);
        }
    }

    private void find(boolean reverse) {
        this.timer.stop();
        String text = this.find.getText();
        if (text.length() == 0) {
            jEdit.setBooleanProperty("search.hypersearch.toggle", this.hyperSearch.isSelected());
            SearchDialog.showSearchDialog(this.view, null, 0);
        } else if (this.hyperSearch.isSelected()) {
            if (this.temp) {
                this.view.removeToolBar(this);
            } else {
                this.find.setText(null);
            }
            SearchAndReplace.setSearchString(text);
            SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
            SearchAndReplace.hyperSearch(this.view);
        } else {
            if (reverse && SearchAndReplace.getRegexp()) {
                GUIUtilities.error(this.view, "regexp-reverse", null);
                return;
            }
            JEditTextArea textArea = this.view.getTextArea();
            Selection s = textArea.getSelectionAtOffset(textArea.getCaretPosition());
            int start = s == null ? textArea.getCaretPosition() : (reverse ? s.getStart() : s.getEnd());
            if (!this.incrementalSearch(start, reverse)) {
                if (!this.incrementalSearch(reverse ? this.view.getBuffer().getLength() : 0, reverse)) {
                    this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.search-not-found"));
                } else {
                    this.view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.auto-wrap"));
                    if (jEdit.getBooleanProperty("search.beepOnSearchAutoWrap")) {
                        this.getToolkit().beep();
                    }
                }
            }
        }
    }

    private boolean incrementalSearch(int start, boolean reverse) {
        SearchAndReplace.setSearchFileSet(new CurrentBufferSet());
        SearchAndReplace.setSearchString(this.find.getText());
        SearchAndReplace.setReverseSearch(reverse);
        try {
            if (SearchAndReplace.find(this.view, this.view.getBuffer(), start, false, reverse)) {
                return true;
            }
        }
        catch (Exception e) {
            Log.log(1, this, e);
            return true;
        }
        return false;
    }

    private void timerIncrementalSearch(int start, boolean reverse) {
        this.searchStart = start;
        this.searchReverse = reverse;
        this.timer.stop();
        this.timer.setRepeats(false);
        this.timer.setInitialDelay(150);
        this.timer.start();
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent evt) {
            switch (evt.getKeyCode()) {
                case 27: {
                    if (SearchBar.this.temp) {
                        SearchBar.this.view.removeToolBar(SearchBar.this);
                    }
                    evt.consume();
                    SearchBar.this.view.getEditPane().focusOnTextArea();
                    break;
                }
                case 10: {
                    if (!evt.isShiftDown()) break;
                    evt.consume();
                    SearchBar.this.find(true);
                }
            }
        }
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent evt) {
            if (!SearchBar.this.hyperSearch.isSelected()) {
                JEditTextArea textArea = SearchBar.this.view.getTextArea();
                Selection s = textArea.getSelectionAtOffset(textArea.getCaretPosition());
                int start = s == null ? textArea.getCaretPosition() : s.getStart();
                SearchBar.this.timerIncrementalSearch(start, false);
            }
        }

        public void removeUpdate(DocumentEvent evt) {
            String text;
            if (!SearchBar.this.hyperSearch.isSelected() && (text = SearchBar.this.find.getText()).length() != 0) {
                if (SearchBar.this.regexp.isSelected()) {
                    SearchBar.this.timerIncrementalSearch(0, false);
                } else {
                    JEditTextArea textArea = SearchBar.this.view.getTextArea();
                    Selection s = textArea.getSelectionAtOffset(textArea.getCaretPosition());
                    int start = s == null ? textArea.getCaretPosition() : s.getStart();
                    SearchBar.this.timerIncrementalSearch(start, true);
                }
            }
        }

        public void changedUpdate(DocumentEvent evt) {
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SearchBar.this.find) {
                SearchBar.this.find(false);
            } else if (source == SearchBar.this.hyperSearch) {
                jEdit.setBooleanProperty("view.search.hypersearch.toggle", SearchBar.this.hyperSearch.isSelected());
                SearchBar.this.update();
            } else if (source == SearchBar.this.ignoreCase) {
                SearchAndReplace.setIgnoreCase(SearchBar.this.ignoreCase.isSelected());
            } else if (source == SearchBar.this.regexp) {
                SearchAndReplace.setRegexp(SearchBar.this.regexp.isSelected());
            } else if (source == SearchBar.this.close) {
                SearchBar.this.view.removeToolBar(SearchBar.this);
                SearchBar.this.view.getEditPane().focusOnTextArea();
            }
        }
    }
}

