/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.search;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.EBComponent;
import org.gjt.sp.jedit.EBMessage;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.gui.HistoryModel;
import org.gjt.sp.jedit.gui.HistoryTextField;
import org.gjt.sp.jedit.gui.VariableGridLayout;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.SearchSettingsChanged;
import org.gjt.sp.jedit.search.AllBufferSet;
import org.gjt.sp.jedit.search.CurrentBufferSet;
import org.gjt.sp.jedit.search.DirectoryListSet;
import org.gjt.sp.jedit.search.SearchAndReplace;
import org.gjt.sp.jedit.search.SearchFileSet;

public class SearchDialog
extends EnhancedDialog
implements EBComponent {
    public static final int CURRENT_BUFFER = 0;
    public static final int ALL_BUFFERS = 1;
    public static final int DIRECTORY = 2;
    private static HashMap viewHash = new HashMap();
    private View view;
    private HistoryTextField find;
    private HistoryTextField replace;
    private JRadioButton stringReplace;
    private JRadioButton beanShellReplace;
    private JCheckBox keepDialog;
    private JCheckBox ignoreCase;
    private JCheckBox regexp;
    private JCheckBox hyperSearch;
    private JCheckBox wrap;
    private JRadioButton searchBack;
    private JRadioButton searchForward;
    private JRadioButton searchSelection;
    private JRadioButton searchCurrentBuffer;
    private JRadioButton searchAllBuffers;
    private JRadioButton searchDirectory;
    private HistoryTextField filter;
    private HistoryTextField directory;
    private JCheckBox searchSubDirectories;
    private JButton choose;
    private JButton synchronize;
    private JButton findBtn;
    private JButton replaceAndFindBtn;
    private JButton replaceAllBtn;
    private JButton closeBtn;
    private boolean saving;

    public static SearchDialog getSearchDialog(View view) {
        if (Debug.DISABLE_SEARCH_DIALOG_POOL) {
            return new SearchDialog(view);
        }
        return (SearchDialog)viewHash.get(view);
    }

    public static void preloadSearchDialog(View view) {
        if (Debug.DISABLE_SEARCH_DIALOG_POOL) {
            return;
        }
        SearchDialog dialog = new SearchDialog(view);
        viewHash.put(view, dialog);
    }

    public static void showSearchDialog(View view, String searchString, int searchIn) {
        SearchDialog dialog = SearchDialog.getSearchDialog(view);
        dialog.setSearchString(searchString, searchIn);
        GUIUtilities.requestFocus(dialog, dialog.find);
        if (OperatingSystem.isUnix() && !OperatingSystem.isMacOS()) {
            dialog.setVisible(false);
        }
        dialog.setVisible(true);
        dialog.toFront();
        dialog.requestFocus();
    }

    public void setSearchString(String searchString, int searchIn) {
        this.find.setText(null);
        this.replace.setText(null);
        if (searchString == null) {
            this.searchCurrentBuffer.setSelected(true);
        } else if (searchString.indexOf(10) == -1) {
            this.find.setText(searchString);
            this.find.selectAll();
            this.searchCurrentBuffer.setSelected(true);
        } else if (searchIn == 0) {
            this.searchSelection.setSelected(true);
            this.hyperSearch.setSelected(true);
        }
        if (searchIn == 0) {
            if (!this.searchSelection.isSelected()) {
                this.searchCurrentBuffer.setSelected(true);
                this.hyperSearch.setSelected(jEdit.getBooleanProperty("search.hypersearch.toggle"));
            }
        } else if (searchIn == 1) {
            this.searchAllBuffers.setSelected(true);
            this.hyperSearch.setSelected(true);
        } else if (searchIn == 2) {
            SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
            if (fileset instanceof DirectoryListSet) {
                this.filter.setText(((DirectoryListSet)fileset).getFileFilter());
                this.directory.setText(((DirectoryListSet)fileset).getDirectory());
                this.searchSubDirectories.setSelected(((DirectoryListSet)fileset).isRecursive());
            }
            this.hyperSearch.setSelected(true);
            this.searchDirectory.setSelected(true);
        }
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ok() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.save(false)) {
                return;
            }
            if (this.searchSelection.isSelected() && this.view.getTextArea().getSelectionCount() == 0) {
                GUIUtilities.error(this.view, "search-no-selection", null);
                return;
            }
            if (this.hyperSearch.isSelected() || this.searchSelection.isSelected()) {
                if (SearchAndReplace.hyperSearch(this.view, this.searchSelection.isSelected())) {
                    this.closeOrKeepDialog();
                }
            } else if (SearchAndReplace.find(this.view)) {
                this.closeOrKeepDialog();
            } else {
                this.toFront();
                this.requestFocus();
                this.find.requestFocus();
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public void cancel() {
        this.save(true);
        GUIUtilities.saveGeometry(this, "search");
        this.setVisible(false);
    }

    public void handleMessage(EBMessage msg) {
        if (msg instanceof SearchSettingsChanged && !this.saving) {
            this.load();
        }
    }

    public void dispose() {
        EditBus.removeFromBus(this);
        viewHash.remove(this.view);
        super.dispose();
    }

    private SearchDialog(View view) {
        super(view, jEdit.getProperty("search.title"), false);
        this.view = view;
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(new EmptyBorder(0, 12, 12, 12));
        this.setContentPane(content);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add("North", this.createFieldPanel());
        centerPanel.add("Center", this.createSearchSettingsPanel());
        content.add("Center", centerPanel);
        content.add("South", this.createMultiFilePanel());
        content.add("East", this.createButtonsPanel());
        this.pack();
        jEdit.unsetProperty("search.width");
        jEdit.unsetProperty("search.d-width");
        jEdit.unsetProperty("search.height");
        jEdit.unsetProperty("search.d-height");
        GUIUtilities.loadGeometry(this, "search");
        this.load();
        EditBus.addToBus(this);
    }

    private JPanel createFieldPanel() {
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        JPanel fieldPanel = new JPanel(new VariableGridLayout(2, 1));
        fieldPanel.setBorder(new EmptyBorder(0, 0, 12, 12));
        JLabel label = new JLabel(jEdit.getProperty("search.find"));
        label.setDisplayedMnemonic(jEdit.getProperty("search.find.mnemonic").charAt(0));
        this.find = new HistoryTextField("find");
        this.find.setColumns(25);
        this.find.addActionListener(actionHandler);
        label.setLabelFor(this.find);
        label.setBorder(new EmptyBorder(12, 0, 2, 0));
        fieldPanel.add(label);
        fieldPanel.add(this.find);
        label = new JLabel(jEdit.getProperty("search.replace"));
        label.setDisplayedMnemonic(jEdit.getProperty("search.replace.mnemonic").charAt(0));
        label.setBorder(new EmptyBorder(12, 0, 0, 0));
        fieldPanel.add(label);
        ButtonGroup grp = new ButtonGroup();
        ReplaceActionHandler replaceActionHandler = new ReplaceActionHandler();
        Box replaceModeBox = new Box(0);
        this.stringReplace = new MyJRadioButton(jEdit.getProperty("search.string-replace-btn"));
        this.stringReplace.addActionListener(replaceActionHandler);
        grp.add(this.stringReplace);
        replaceModeBox.add(this.stringReplace);
        replaceModeBox.add(Box.createHorizontalStrut(12));
        this.beanShellReplace = new MyJRadioButton(jEdit.getProperty("search.beanshell-replace-btn"));
        this.beanShellReplace.addActionListener(replaceActionHandler);
        grp.add(this.beanShellReplace);
        replaceModeBox.add(this.beanShellReplace);
        fieldPanel.add(replaceModeBox);
        fieldPanel.add(Box.createVerticalStrut(3));
        this.replace = new HistoryTextField("replace");
        this.replace.addActionListener(actionHandler);
        label.setLabelFor(this.replace);
        fieldPanel.add(this.replace);
        return fieldPanel;
    }

    private JPanel createSearchSettingsPanel() {
        JPanel searchSettings = new JPanel(new VariableGridLayout(2, 3));
        searchSettings.setBorder(new EmptyBorder(0, 0, 12, 12));
        SettingsActionHandler actionHandler = new SettingsActionHandler();
        ButtonGroup fileset = new ButtonGroup();
        ButtonGroup direction = new ButtonGroup();
        searchSettings.add(new JLabel(jEdit.getProperty("search.fileset")));
        searchSettings.add(new JLabel(jEdit.getProperty("search.settings")));
        searchSettings.add(new JLabel(jEdit.getProperty("search.direction")));
        this.searchSelection = new JRadioButton(jEdit.getProperty("search.selection"));
        this.searchSelection.setMnemonic(jEdit.getProperty("search.selection.mnemonic").charAt(0));
        fileset.add(this.searchSelection);
        searchSettings.add(this.searchSelection);
        this.searchSelection.addActionListener(actionHandler);
        this.keepDialog = new JCheckBox(jEdit.getProperty("search.keep"));
        this.keepDialog.setMnemonic(jEdit.getProperty("search.keep.mnemonic").charAt(0));
        searchSettings.add(this.keepDialog);
        this.searchBack = new JRadioButton(jEdit.getProperty("search.back"));
        this.searchBack.setMnemonic(jEdit.getProperty("search.back.mnemonic").charAt(0));
        direction.add(this.searchBack);
        searchSettings.add(this.searchBack);
        this.searchBack.addActionListener(actionHandler);
        this.searchCurrentBuffer = new JRadioButton(jEdit.getProperty("search.current"));
        this.searchCurrentBuffer.setMnemonic(jEdit.getProperty("search.current.mnemonic").charAt(0));
        fileset.add(this.searchCurrentBuffer);
        searchSettings.add(this.searchCurrentBuffer);
        this.searchCurrentBuffer.addActionListener(actionHandler);
        this.ignoreCase = new JCheckBox(jEdit.getProperty("search.case"));
        this.ignoreCase.setMnemonic(jEdit.getProperty("search.case.mnemonic").charAt(0));
        searchSettings.add(this.ignoreCase);
        this.ignoreCase.addActionListener(actionHandler);
        this.searchForward = new JRadioButton(jEdit.getProperty("search.forward"));
        this.searchForward.setMnemonic(jEdit.getProperty("search.forward.mnemonic").charAt(0));
        direction.add(this.searchForward);
        searchSettings.add(this.searchForward);
        this.searchForward.addActionListener(actionHandler);
        this.searchAllBuffers = new JRadioButton(jEdit.getProperty("search.all"));
        this.searchAllBuffers.setMnemonic(jEdit.getProperty("search.all.mnemonic").charAt(0));
        fileset.add(this.searchAllBuffers);
        searchSettings.add(this.searchAllBuffers);
        this.searchAllBuffers.addActionListener(actionHandler);
        this.regexp = new JCheckBox(jEdit.getProperty("search.regexp"));
        this.regexp.setMnemonic(jEdit.getProperty("search.regexp.mnemonic").charAt(0));
        searchSettings.add(this.regexp);
        this.regexp.addActionListener(actionHandler);
        this.wrap = new JCheckBox(jEdit.getProperty("search.wrap"));
        this.wrap.setMnemonic(jEdit.getProperty("search.wrap.mnemonic").charAt(0));
        searchSettings.add(this.wrap);
        this.wrap.addActionListener(actionHandler);
        this.searchDirectory = new JRadioButton(jEdit.getProperty("search.directory"));
        this.searchDirectory.setMnemonic(jEdit.getProperty("search.directory.mnemonic").charAt(0));
        fileset.add(this.searchDirectory);
        searchSettings.add(this.searchDirectory);
        this.searchDirectory.addActionListener(actionHandler);
        this.hyperSearch = new JCheckBox(jEdit.getProperty("search.hypersearch"));
        this.hyperSearch.setMnemonic(jEdit.getProperty("search.hypersearch.mnemonic").charAt(0));
        searchSettings.add(this.hyperSearch);
        this.hyperSearch.addActionListener(actionHandler);
        return searchSettings;
    }

    private JPanel createMultiFilePanel() {
        JPanel multifile = new JPanel();
        GridBagLayout layout = new GridBagLayout();
        multifile.setLayout(layout);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridheight = 1;
        cons.gridwidth = 1;
        cons.gridy = 1;
        cons.anchor = 17;
        cons.fill = 2;
        MultiFileActionHandler actionListener = new MultiFileActionHandler();
        this.filter = new HistoryTextField("search.filter");
        this.filter.addActionListener(actionListener);
        cons.insets = new Insets(0, 0, 3, 0);
        JLabel label = new JLabel(jEdit.getProperty("search.filterField"), 4);
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        label.setDisplayedMnemonic(jEdit.getProperty("search.filterField.mnemonic").charAt(0));
        label.setLabelFor(this.filter);
        cons.weightx = 0.0;
        layout.setConstraints(label, cons);
        multifile.add(label);
        cons.gridwidth = 2;
        cons.insets = new Insets(0, 0, 3, 6);
        cons.weightx = 1.0;
        layout.setConstraints(this.filter, cons);
        multifile.add(this.filter);
        cons.gridwidth = 1;
        cons.weightx = 0.0;
        cons.insets = new Insets(0, 0, 3, 0);
        this.synchronize = new JButton(jEdit.getProperty("search.synchronize"));
        this.synchronize.setMnemonic(jEdit.getProperty("search.synchronize.mnemonic").charAt(0));
        this.synchronize.addActionListener(actionListener);
        layout.setConstraints(this.synchronize, cons);
        multifile.add(this.synchronize);
        ++cons.gridy;
        this.directory = new HistoryTextField("search.directory");
        this.directory.setColumns(25);
        this.directory.addActionListener(actionListener);
        label = new JLabel(jEdit.getProperty("search.directoryField"), 4);
        label.setBorder(new EmptyBorder(0, 0, 0, 12));
        label.setDisplayedMnemonic(jEdit.getProperty("search.directoryField.mnemonic").charAt(0));
        label.setLabelFor(this.directory);
        cons.insets = new Insets(0, 0, 3, 0);
        cons.weightx = 0.0;
        layout.setConstraints(label, cons);
        multifile.add(label);
        cons.insets = new Insets(0, 0, 3, 6);
        cons.weightx = 1.0;
        cons.gridwidth = 2;
        layout.setConstraints(this.directory, cons);
        multifile.add(this.directory);
        this.choose = new JButton(jEdit.getProperty("search.choose"));
        this.choose.setMnemonic(jEdit.getProperty("search.choose.mnemonic").charAt(0));
        cons.insets = new Insets(0, 0, 3, 0);
        cons.weightx = 0.0;
        cons.gridwidth = 1;
        layout.setConstraints(this.choose, cons);
        multifile.add(this.choose);
        this.choose.addActionListener(actionListener);
        cons.insets = new Insets(0, 0, 0, 0);
        ++cons.gridy;
        cons.gridwidth = 3;
        this.searchSubDirectories = new JCheckBox(jEdit.getProperty("search.subdirs"));
        layout.setConstraints(this.searchSubDirectories, cons);
        multifile.add(this.searchSubDirectories);
        return multifile;
    }

    private Box createButtonsPanel() {
        Box box = new Box(1);
        ButtonActionHandler actionHandler = new ButtonActionHandler();
        box.add(Box.createVerticalStrut(12));
        JPanel grid = new JPanel(new GridLayout(5, 1, 0, 12));
        this.findBtn = new JButton(jEdit.getProperty("search.findBtn"));
        this.getRootPane().setDefaultButton(this.findBtn);
        grid.add(this.findBtn);
        this.findBtn.addActionListener(actionHandler);
        this.replaceAndFindBtn = new JButton(jEdit.getProperty("search.replaceAndFindBtn"));
        this.replaceAndFindBtn.setMnemonic(jEdit.getProperty("search.replaceAndFindBtn.mnemonic").charAt(0));
        grid.add(this.replaceAndFindBtn);
        this.replaceAndFindBtn.addActionListener(actionHandler);
        this.replaceAllBtn = new JButton(jEdit.getProperty("search.replaceAllBtn"));
        this.replaceAllBtn.setMnemonic(jEdit.getProperty("search.replaceAllBtn.mnemonic").charAt(0));
        grid.add(this.replaceAllBtn);
        this.replaceAllBtn.addActionListener(actionHandler);
        this.closeBtn = new JButton(jEdit.getProperty("common.close"));
        grid.add(this.closeBtn);
        this.closeBtn.addActionListener(actionHandler);
        grid.setMaximumSize(grid.getPreferredSize());
        box.add(grid);
        box.add(Box.createGlue());
        return box;
    }

    private void updateEnabled() {
        this.wrap.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
        boolean reverseEnabled = !this.hyperSearch.isSelected() && this.searchCurrentBuffer.isSelected() && !this.regexp.isSelected();
        this.searchBack.setEnabled(reverseEnabled);
        this.searchForward.setEnabled(reverseEnabled);
        if (!reverseEnabled) {
            this.searchForward.setSelected(true);
        }
        this.filter.setEnabled(this.searchAllBuffers.isSelected() || this.searchDirectory.isSelected());
        this.directory.setEnabled(this.searchDirectory.isSelected());
        this.choose.setEnabled(this.searchDirectory.isSelected());
        this.searchSubDirectories.setEnabled(this.searchDirectory.isSelected());
        this.synchronize.setEnabled(this.searchAllBuffers.isSelected() || this.searchDirectory.isSelected());
        this.findBtn.setEnabled(!this.searchSelection.isSelected() || this.hyperSearch.isSelected());
        this.replaceAndFindBtn.setEnabled(!this.hyperSearch.isSelected() && !this.searchSelection.isSelected());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(boolean cancel) {
        try {
            this.saving = true;
            SearchAndReplace.setIgnoreCase(this.ignoreCase.isSelected());
            SearchAndReplace.setRegexp(this.regexp.isSelected());
            SearchAndReplace.setReverseSearch(this.searchBack.isSelected());
            SearchAndReplace.setAutoWrapAround(this.wrap.isSelected());
            String filter = this.filter.getText();
            this.filter.addCurrentToHistory();
            if (filter.length() == 0) {
                filter = "*";
            }
            SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
            boolean recurse = this.searchSubDirectories.isSelected();
            if (this.searchSelection.isSelected()) {
                fileset = new CurrentBufferSet();
            } else if (this.searchCurrentBuffer.isSelected()) {
                fileset = new CurrentBufferSet();
                jEdit.setBooleanProperty("search.hypersearch.toggle", this.hyperSearch.isSelected());
            } else if (this.searchAllBuffers.isSelected()) {
                fileset = new AllBufferSet(filter);
            } else if (this.searchDirectory.isSelected()) {
                String directory = this.directory.getText();
                this.directory.addCurrentToHistory();
                directory = MiscUtilities.constructPath(this.view.getBuffer().getDirectory(), directory);
                if ((VFSManager.getVFSForPath(directory).getCapabilities() & 0x40) == 0) {
                    if (cancel) {
                        boolean bl = false;
                        return bl;
                    }
                    int retVal = GUIUtilities.confirm(this, "remote-dir-search", null, 0, 2);
                    if (retVal != 0) {
                        boolean bl = false;
                        return bl;
                    }
                }
                if (fileset instanceof DirectoryListSet) {
                    DirectoryListSet dset = (DirectoryListSet)fileset;
                    dset.setDirectory(directory);
                    dset.setFileFilter(filter);
                    dset.setRecursive(recurse);
                    EditBus.send(new SearchSettingsChanged(null));
                } else {
                    fileset = new DirectoryListSet(directory, filter, recurse);
                }
            } else {
                fileset = null;
            }
            jEdit.setBooleanProperty("search.subdirs.toggle", recurse);
            jEdit.setBooleanProperty("search.keepDialog.toggle", this.keepDialog.isSelected());
            SearchAndReplace.setSearchFileSet(fileset);
            this.replace.addCurrentToHistory();
            SearchAndReplace.setReplaceString(this.replace.getText());
            if (this.find.getText().length() == 0) {
                if (!cancel) {
                    this.getToolkit().beep();
                }
                boolean bl = false;
                return bl;
            }
            this.find.addCurrentToHistory();
            SearchAndReplace.setSearchString(this.find.getText());
            boolean bl = true;
            return bl;
        }
        finally {
            this.saving = false;
        }
    }

    private void synchronizeMultiFileSettings() {
        this.directory.setText(this.view.getBuffer().getDirectory());
        SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
        if (fileset instanceof AllBufferSet) {
            this.filter.setText(((AllBufferSet)fileset).getFileFilter());
        } else {
            this.filter.setText("*" + MiscUtilities.getFileExtension(this.view.getBuffer().getName()));
        }
    }

    private void closeOrKeepDialog() {
        if (this.keepDialog.isSelected()) {
            if (!this.hyperSearch.isSelected()) {
                this.toFront();
                this.requestFocus();
                this.find.requestFocus();
            }
            return;
        }
        GUIUtilities.saveGeometry(this, "search");
        this.setVisible(false);
    }

    private void load() {
        this.ignoreCase.setSelected(SearchAndReplace.getIgnoreCase());
        this.regexp.setSelected(SearchAndReplace.getRegexp());
        this.wrap.setSelected(SearchAndReplace.getAutoWrapAround());
        if (SearchAndReplace.getReverseSearch()) {
            this.searchBack.setSelected(true);
        } else {
            this.searchForward.setSelected(true);
        }
        if (SearchAndReplace.getBeanShellReplace()) {
            this.replace.setModel("replace.script");
            this.beanShellReplace.setSelected(true);
        } else {
            this.replace.setModel("replace");
            this.stringReplace.setSelected(true);
        }
        SearchFileSet fileset = SearchAndReplace.getSearchFileSet();
        HistoryModel model = this.filter.getModel();
        if (model.getSize() != 0) {
            this.filter.setText(model.getItem(0));
        } else {
            this.filter.setText("*" + MiscUtilities.getFileExtension(this.view.getBuffer().getName()));
        }
        model = this.directory.getModel();
        if (model.getSize() != 0) {
            this.directory.setText(model.getItem(0));
        } else {
            this.directory.setText(this.view.getBuffer().getDirectory());
        }
        this.searchSubDirectories.setSelected(jEdit.getBooleanProperty("search.subdirs.toggle"));
        if (fileset instanceof DirectoryListSet) {
            this.filter.setText(((DirectoryListSet)fileset).getFileFilter());
            this.directory.setText(((DirectoryListSet)fileset).getDirectory());
            this.searchSubDirectories.setSelected(((DirectoryListSet)fileset).isRecursive());
        } else if (fileset instanceof AllBufferSet) {
            this.filter.setText(((AllBufferSet)fileset).getFileFilter());
        }
        this.directory.addCurrentToHistory();
        this.keepDialog.setSelected(jEdit.getBooleanProperty("search.keepDialog.toggle"));
    }

    class ButtonActionHandler
    implements ActionListener {
        ButtonActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SearchDialog.this.closeBtn) {
                SearchDialog.this.cancel();
            } else if (source == SearchDialog.this.findBtn || source == SearchDialog.this.find || source == SearchDialog.this.replace) {
                SearchDialog.this.ok();
            } else if (source == SearchDialog.this.replaceAndFindBtn) {
                SearchDialog.this.save(false);
                if (SearchAndReplace.replace(SearchDialog.this.view)) {
                    SearchDialog.this.ok();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
            } else if (source == SearchDialog.this.replaceAllBtn) {
                if (SearchDialog.this.searchSelection.isSelected() && SearchDialog.this.view.getTextArea().getSelectionCount() == 0) {
                    GUIUtilities.error(SearchDialog.this.view, "search-no-selection", null);
                    return;
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                if (!SearchDialog.this.save(false)) {
                    SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                    SearchDialog.this.getToolkit().beep();
                    return;
                }
                if (SearchDialog.this.searchSelection.isSelected()) {
                    if (SearchAndReplace.replace(SearchDialog.this.view)) {
                        SearchDialog.this.closeOrKeepDialog();
                    } else {
                        SearchDialog.this.getToolkit().beep();
                    }
                } else if (SearchAndReplace.replaceAll(SearchDialog.this.view)) {
                    SearchDialog.this.closeOrKeepDialog();
                } else {
                    SearchDialog.this.getToolkit().beep();
                }
                SearchDialog.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    class MultiFileActionHandler
    implements ActionListener {
        MultiFileActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SearchDialog.this.choose) {
                String[] dirs = GUIUtilities.showVFSFileDialog(SearchDialog.this.view, SearchDialog.this.directory.getText(), 3, false);
                if (dirs != null) {
                    SearchDialog.this.directory.setText(dirs[0]);
                }
            } else if (evt.getSource() == SearchDialog.this.synchronize) {
                SearchDialog.this.synchronizeMultiFileSettings();
            } else {
                SearchDialog.this.ok();
            }
        }
    }

    class SettingsActionHandler
    implements ActionListener {
        SettingsActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object source = evt.getSource();
            if (source == SearchDialog.this.searchCurrentBuffer) {
                SearchDialog.this.hyperSearch.setSelected(false);
            } else if (source == SearchDialog.this.searchSelection || source == SearchDialog.this.searchAllBuffers || source == SearchDialog.this.searchDirectory) {
                SearchDialog.this.hyperSearch.setSelected(true);
            }
            SearchDialog.this.save(true);
            SearchDialog.this.updateEnabled();
        }
    }

    class ReplaceActionHandler
    implements ActionListener {
        ReplaceActionHandler() {
        }

        public void actionPerformed(ActionEvent evt) {
            SearchDialog.this.replace.setModel(SearchDialog.this.beanShellReplace.isSelected() ? "replace.script" : "replace");
            SearchAndReplace.setBeanShellReplace(SearchDialog.this.beanShellReplace.isSelected());
        }
    }

    class MyJRadioButton
    extends JRadioButton {
        MyJRadioButton(String label) {
            super(label);
        }

        public boolean isFocusTraversable() {
            return false;
        }
    }
}

