/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.BufferChangeAdapter;
import org.gjt.sp.jedit.buffer.IndentFoldHandler;
import org.gjt.sp.jedit.buffer.LineManager;
import org.gjt.sp.jedit.gui.BeanShellErrorDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextAreaPainter;
import org.gjt.sp.util.Log;

public class DisplayManager {
    public static long scanCount;
    public static long scannedLines;
    private static Map bufferMap;
    boolean softWrap;
    int wrapMargin;
    FirstLine firstLine;
    ScrollLineCount scrollLineCount;
    private boolean initialized;
    private boolean inUse;
    private Buffer buffer;
    private LineManager lineMgr;
    private JEditTextArea textArea;
    private BufferChangeHandler bufferChangeHandler;
    private int[] fvm;
    private int fvmcount;
    private int lastfvmget = -1;

    static DisplayManager getDisplayManager(Buffer buffer, JEditTextArea textArea) {
        DisplayManager dmgr;
        LinkedList<DisplayManager> l = (LinkedList<DisplayManager>)bufferMap.get(buffer);
        if (l == null) {
            l = new LinkedList<DisplayManager>();
            bufferMap.put(buffer, l);
        }
        Iterator liter = l.iterator();
        while (liter.hasNext()) {
            dmgr = (DisplayManager)liter.next();
            if (dmgr.inUse || dmgr.textArea != textArea) continue;
            dmgr.inUse = true;
            return dmgr;
        }
        dmgr = new DisplayManager(buffer, textArea);
        dmgr.inUse = true;
        l.add(dmgr);
        return dmgr;
    }

    static void releaseDisplayManager(DisplayManager dmgr) {
        dmgr.inUse = false;
    }

    public static void bufferClosed(Buffer buffer) {
        bufferMap.remove(buffer);
    }

    static void textAreaDisposed(JEditTextArea textArea) {
        Iterator biter = bufferMap.values().iterator();
        while (biter.hasNext()) {
            List l = (List)biter.next();
            Iterator liter = l.iterator();
            while (liter.hasNext()) {
                DisplayManager dmgr = (DisplayManager)liter.next();
                if (dmgr.textArea != textArea) continue;
                dmgr.dispose();
                liter.remove();
            }
        }
    }

    public final boolean isLineVisible(int line) {
        return this.fvmget(line) % 2 == 0;
    }

    public int getFirstVisibleLine() {
        return this.fvm[0];
    }

    public int getLastVisibleLine() {
        return this.fvm[this.fvmcount - 1] - 1;
    }

    public int getNextVisibleLine(int line) {
        if (line < 0 || line >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        int index = this.fvmget(line);
        if (index % 2 != 0) {
            if (this.fvmcount == index + 1) {
                return -1;
            }
            return this.fvm[index + 1];
        }
        if (line == this.fvm[index + 1] - 1) {
            if (this.fvmcount == index + 2) {
                return -1;
            }
            return this.fvm[index + 2];
        }
        return line + 1;
    }

    public int getPrevVisibleLine(int line) {
        if (line < 0 || line >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        int index = this.fvmget(line);
        if (index == -1) {
            return -1;
        }
        if (index % 2 == 1) {
            return this.fvm[index] - 1;
        }
        if (line == this.fvm[index]) {
            if (index == 0) {
                return -1;
            }
            return this.fvm[index - 1] - 1;
        }
        return line - 1;
    }

    public final int getScreenLineCount(int line) {
        if (this.lineMgr.isScreenLineCountValid(line)) {
            return this.lineMgr.getScreenLineCount(line);
        }
        int newCount = this.textArea.chunkCache.getLineSubregionCount(line);
        this.setScreenLineCount(line, newCount);
        return newCount;
    }

    public final int getScrollLineCount() {
        return this.scrollLineCount.scrollLine;
    }

    public void collapseFold(int line) {
        int lineCount = this.buffer.getLineCount();
        int start = 0;
        int end = lineCount - 1;
        if (line != 0 && line != this.buffer.getLineCount() - 1 && this.buffer.isFoldStart(line) && !this.isLineVisible(line + 1)) {
            --line;
        }
        int initialFoldLevel = this.buffer.getFoldLevel(line);
        if (line != lineCount - 1 && this.buffer.getFoldLevel(line + 1) > initialFoldLevel) {
            start = line + 1;
            for (int i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        } else {
            int i;
            boolean ok = false;
            for (i = line - 1; i >= 0; --i) {
                if (this.buffer.getFoldLevel(i) >= initialFoldLevel) continue;
                start = i + 1;
                ok = true;
                break;
            }
            if (!ok) {
                return;
            }
            for (i = line + 1; i < lineCount; ++i) {
                if (this.buffer.getFoldLevel(i) >= initialFoldLevel) continue;
                end = i - 1;
                break;
            }
        }
        this.hideLineRange(start, end);
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public int expandFold(int line, boolean fully) {
        int i;
        int index;
        int returnValue = -1;
        int lineCount = this.buffer.getLineCount();
        int start = 0;
        int end = lineCount - 1;
        int initialFoldLevel = this.buffer.getFoldLevel(line);
        if (line != lineCount - 1 && this.isLineVisible(line) && !this.isLineVisible(line + 1) && this.buffer.getFoldLevel(line + 1) > initialFoldLevel) {
            index = this.fvmget(line + 1);
            if (index == -1) {
                this.expandAllFolds();
                return -1;
            }
            start = this.fvm[index];
            if (index != this.fvmcount - 1) {
                end = this.fvm[index + 1] - 1;
            } else {
                start = line + 1;
                for (i = line + 1; i < lineCount; ++i) {
                    if (this.buffer.getFoldLevel(i) > initialFoldLevel) continue;
                    end = i - 1;
                    break;
                }
            }
        } else {
            index = this.fvmget(line);
            if (index == -1) {
                this.expandAllFolds();
                return -1;
            }
            start = this.fvm[index];
            if (index != this.fvmcount - 1) {
                end = this.fvm[index + 1] - 1;
            } else {
                for (i = line + 1; i < lineCount; ++i) {
                    if ((!this.isLineVisible(i) || this.buffer.getFoldLevel(i) >= initialFoldLevel) && i != this.getLastVisibleLine()) continue;
                    end = i - 1;
                    break;
                }
            }
        }
        if (fully) {
            this.showLineRange(start, end);
        } else {
            initialFoldLevel = this.buffer.getFoldLevel(start);
            int firstVisible = start;
            for (i = start; i <= end; ++i) {
                if (this.buffer.getFoldLevel(i) <= initialFoldLevel) continue;
                if (returnValue == -1 && i != 0 && this.buffer.isFoldStart(i - 1)) {
                    returnValue = i - 1;
                }
                if (firstVisible != i) {
                    this.showLineRange(firstVisible, i - 1);
                }
                firstVisible = i + 1;
            }
            if (firstVisible != end + 1) {
                this.showLineRange(firstVisible, end);
            }
            if (!this.isLineVisible(line)) {
                this.expandFold(line, false);
                return returnValue;
            }
        }
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
        return returnValue;
    }

    public void expandAllFolds() {
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void expandFolds(char digit) {
        if (digit < '1' || digit > '9') {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.expandFolds(digit - 49 + 1);
    }

    public void expandFolds(int foldLevel) {
        if (this.buffer.getFoldHandler() instanceof IndentFoldHandler) {
            foldLevel = (foldLevel - 1) * this.buffer.getIndentSize() + 1;
        }
        this.showLineRange(0, this.buffer.getLineCount() - 1);
        boolean seenVisibleLine = false;
        int firstInvisible = 0;
        for (int i = 0; i < this.buffer.getLineCount(); ++i) {
            if (seenVisibleLine && this.buffer.getFoldLevel(i) >= foldLevel) continue;
            if (firstInvisible != i) {
                this.hideLineRange(firstInvisible, i - 1);
            }
            firstInvisible = i + 1;
            seenVisibleLine = true;
        }
        if (firstInvisible != this.buffer.getLineCount()) {
            this.hideLineRange(firstInvisible, this.buffer.getLineCount() - 1);
        }
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    public void narrow(int start, int end) {
        if (start > end || start < 0 || end >= this.buffer.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException(start + ", " + end);
        }
        if (start < this.getFirstVisibleLine() || end > this.getLastVisibleLine()) {
            this.expandAllFolds();
        }
        if (start != 0) {
            this.hideLineRange(0, start - 1);
        }
        if (end != this.buffer.getLineCount() - 1) {
            this.hideLineRange(end + 1, this.buffer.getLineCount() - 1);
        }
        if (start != this.buffer.getLineCount() - 1 && !this.isLineVisible(start + 1)) {
            this.expandFold(start, false);
        }
        GUIUtilities.getView(this.textArea).getStatus().setMessageAndClear(jEdit.getProperty("view.status.narrow"));
        this._notifyScreenLineChanges();
        this.textArea.foldStructureChanged();
    }

    void init() {
        if (!this.initialized) {
            this.initialized = true;
            this.fvm = new int[2];
            if (this.buffer.isLoaded()) {
                this.bufferChangeHandler.foldHandlerChanged(this.buffer);
            } else {
                this.fvmreset();
            }
            this._notifyScreenLineChanges();
        } else {
            this.updateWrapSettings();
            if (this.buffer.isLoaded()) {
                this._notifyScreenLineChanges();
                this.textArea.updateScrollBars();
                this.textArea.recalculateLastPhysicalLine();
            }
        }
    }

    void setScreenLineCount(int line, int count) {
        int oldCount = this.lineMgr.getScreenLineCount(line);
        this.lineMgr.setScreenLineCount(line, count);
        if (count != oldCount) {
            Iterator iter = ((List)bufferMap.get(this.buffer)).iterator();
            while (iter.hasNext()) {
                ((DisplayManager)iter.next())._setScreenLineCount(line, oldCount, count);
            }
        }
    }

    void updateWrapSettings() {
        String wrap = this.buffer.getStringProperty("wrap");
        this.softWrap = wrap.equals("soft");
        if (this.textArea.maxLineLen <= 0) {
            this.softWrap = false;
            this.wrapMargin = 0;
        } else {
            char[] foo = new char[this.textArea.maxLineLen];
            for (int i = 0; i < foo.length; ++i) {
                foo[i] = 32;
            }
            TextAreaPainter painter = this.textArea.getPainter();
            this.wrapMargin = (int)painter.getFont().getStringBounds(foo, 0, foo.length, painter.getFontRenderContext()).getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _notifyScreenLineChanges() {
        if (Debug.SCROLL_DEBUG) {
            Log.log(1, this, "_notifyScreenLineChanges()");
        }
        if (this.textArea.getDisplayManager() == this) {
            try {
                if (this.firstLine.callReset) {
                    this.firstLine.reset();
                } else if (this.firstLine.callChanged) {
                    this.firstLine.changed();
                }
                if (this.scrollLineCount.callReset) {
                    this.scrollLineCount.reset();
                } else if (this.scrollLineCount.callChanged) {
                    this.scrollLineCount.changed();
                }
                Object var2_1 = null;
                this.firstLine.callChanged = false;
                this.firstLine.callReset = false;
                this.scrollLineCount.callChanged = false;
                this.scrollLineCount.callReset = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.firstLine.callChanged = false;
                this.firstLine.callReset = false;
                this.scrollLineCount.callChanged = false;
                this.scrollLineCount.callReset = false;
                throw throwable;
            }
        }
    }

    private DisplayManager(Buffer buffer, JEditTextArea textArea) {
        this.buffer = buffer;
        this.lineMgr = buffer._getLineManager();
        this.textArea = textArea;
        this.scrollLineCount = new ScrollLineCount();
        this.firstLine = new FirstLine();
        this.bufferChangeHandler = new BufferChangeHandler();
        buffer.addBufferChangeListener(this.bufferChangeHandler, 1);
    }

    private void dispose() {
        this.buffer.removeBufferChangeListener(this.bufferChangeHandler);
    }

    private void fvmreset() {
        this.lastfvmget = -1;
        this.fvmcount = 2;
        this.fvm[0] = 0;
        this.fvm[1] = this.buffer.getLineCount();
    }

    private int fvmget(int line) {
        ++scanCount;
        if (line < this.fvm[0]) {
            return -1;
        }
        if (line >= this.fvm[this.fvmcount - 1]) {
            return this.fvmcount - 1;
        }
        if (this.lastfvmget != -1 && line >= this.fvm[this.lastfvmget] && (this.lastfvmget == this.fvmcount - 1 || line < this.fvm[this.lastfvmget + 1])) {
            return this.lastfvmget;
        }
        int start = 0;
        int end = this.fvmcount - 1;
        block4: while (true) {
            ++scannedLines;
            switch (end - start) {
                case 0: {
                    this.lastfvmget = start;
                    break block4;
                }
                case 1: {
                    int value = this.fvm[end];
                    if (value <= line) {
                        this.lastfvmget = end;
                        break block4;
                    }
                    this.lastfvmget = start;
                    break block4;
                }
                default: {
                    int pivot = (end + start) / 2;
                    int value = this.fvm[pivot];
                    if (value == line) {
                        this.lastfvmget = pivot;
                        break block4;
                    }
                    if (value < line) {
                        start = pivot;
                        continue block4;
                    }
                    end = pivot - 1;
                    continue block4;
                }
            }
            break;
        }
        return this.lastfvmget;
    }

    private void fvmput(int start, int end, int[] put) {
        int putl;
        int delta;
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuffer buf = new StringBuffer("{");
            if (put != null) {
                for (int i = 0; i < put.length; ++i) {
                    if (i != 0) {
                        buf.append(',');
                    }
                    buf.append(put[i]);
                }
            }
            buf.append("}");
            Log.log(1, this, "fvmput(" + start + "," + end + "," + buf + ")");
        }
        if (this.fvmcount + (delta = (putl = put == null ? 0 : put.length) - (end - start)) > this.fvm.length) {
            int[] newfvm = new int[this.fvm.length * 2 + 1];
            System.arraycopy(this.fvm, 0, newfvm, 0, this.fvmcount);
            this.fvm = newfvm;
        }
        if (delta != 0) {
            System.arraycopy(this.fvm, end, this.fvm, start + putl, this.fvmcount - end);
        }
        if (putl != 0) {
            System.arraycopy(put, 0, this.fvm, start, put.length);
        }
        this.fvmcount += delta;
        this.fvmdump();
        if (this.fvmcount == 0) {
            throw new InternalError();
        }
    }

    private void fvmput2(int starti, int endi, int start, int end) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "*fvmput2(" + starti + "," + endi + "," + start + "," + end + ")");
        }
        if (starti != -1 && this.fvm[starti] == start) {
            if (endi <= this.fvmcount - 2 && this.fvm[endi + 1] == end + 1) {
                this.fvmput(starti, endi + 2, null);
            } else {
                this.fvmput(starti, endi + 1, new int[]{end + 1});
            }
        } else if (endi != this.fvmcount - 1 && this.fvm[endi + 1] == end + 1) {
            this.fvmput(starti + 1, endi + 2, new int[]{start});
        } else {
            this.fvmput(starti + 1, endi + 1, new int[]{start, end + 1});
        }
    }

    private void fvmdump() {
        if (Debug.FOLD_VIS_DEBUG) {
            StringBuffer buf = new StringBuffer("{");
            for (int i = 0; i < this.fvmcount; ++i) {
                if (i != 0) {
                    buf.append(',');
                }
                buf.append(this.fvm[i]);
            }
            buf.append("}");
            Log.log(1, this, "fvm = " + buf);
        }
    }

    private void showLineRange(int start, int end) {
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "showLineRange(" + start + "," + end + ")");
        }
        for (int i = start; i <= end; ++i) {
            if (this.isLineVisible(i)) continue;
            int screenLines = this.getScreenLineCount(i);
            if (this.firstLine.physicalLine >= i) {
                this.firstLine.scrollLine += screenLines;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine += screenLines;
            this.scrollLineCount.callChanged = true;
        }
        int starti = this.fvmget(start);
        int endi = this.fvmget(end);
        if (starti % 2 == 0) {
            if (endi % 2 == 0) {
                this.fvmput(starti + 1, endi + 1, null);
            } else if (endi != this.fvmcount - 1 && this.fvm[endi + 1] == end + 1) {
                this.fvmput(starti + 1, endi + 2, null);
            } else {
                this.fvmput(starti + 1, endi, null);
                this.fvm[starti + 1] = end + 1;
            }
        } else if (endi % 2 == 0) {
            if (starti != -1 && this.fvm[starti] == start) {
                this.fvmput(starti, endi + 1, null);
            } else {
                this.fvmput(starti + 1, endi, null);
                this.fvm[starti + 1] = start;
            }
        } else {
            this.fvmput2(starti, endi, start, end);
        }
        this.lastfvmget = -1;
    }

    private void hideLineRange(int start, int end) {
        int i;
        if (Debug.FOLD_VIS_DEBUG) {
            Log.log(1, this, "hideLineRange(" + start + "," + end + ")");
        }
        if (!this.isLineVisible(i = start)) {
            i = this.getNextVisibleLine(i);
        }
        while (i != -1 && i <= end) {
            int screenLines = this.lineMgr.getScreenLineCount(i);
            if (i < this.firstLine.physicalLine) {
                this.firstLine.scrollLine -= screenLines;
                this.firstLine.skew = 0;
                this.firstLine.callChanged = true;
            }
            this.scrollLineCount.scrollLine -= screenLines;
            this.scrollLineCount.callChanged = true;
            i = this.getNextVisibleLine(i);
        }
        int starti = this.fvmget(start);
        int endi = this.fvmget(end);
        if (starti % 2 == 0) {
            if (endi % 2 == 0) {
                this.fvmput2(starti, endi, start, end);
            } else if (start == this.fvm[0]) {
                this.fvmput(starti, endi + 1, null);
            } else {
                this.fvmput(starti + 1, endi, null);
                this.fvm[starti + 1] = start;
            }
        } else if (endi % 2 == 0) {
            if (end + 1 == this.fvm[this.fvmcount - 1]) {
                this.fvmput(starti + 1, endi + 2, null);
            } else {
                this.fvmput(starti + 1, endi, null);
                this.fvm[starti + 1] = end + 1;
            }
        } else {
            this.fvmput(starti + 1, endi + 1, null);
        }
        this.lastfvmget = -1;
        if (!this.isLineVisible(this.firstLine.physicalLine)) {
            int firstVisible = this.getFirstVisibleLine();
            if (this.firstLine.physicalLine < firstVisible) {
                this.firstLine.physicalLine = firstVisible;
                this.firstLine.scrollLine = 0;
            } else {
                this.firstLine.physicalLine = this.getPrevVisibleLine(this.firstLine.physicalLine);
                this.firstLine.scrollLine -= this.lineMgr.getScreenLineCount(this.firstLine.physicalLine);
            }
            this.firstLine.callChanged = true;
        }
    }

    private void _setScreenLineCount(int line, int oldCount, int count) {
        if (!this.isLineVisible(line)) {
            return;
        }
        if (this.firstLine.physicalLine >= line) {
            if (this.firstLine.physicalLine == line) {
                this.firstLine.callChanged = true;
            } else {
                this.firstLine.scrollLine += count - oldCount;
                this.firstLine.callChanged = true;
            }
        }
        this.scrollLineCount.scrollLine += count - oldCount;
        this.scrollLineCount.callChanged = true;
    }

    static {
        bufferMap = new HashMap();
    }

    class BufferChangeHandler
    extends BufferChangeAdapter {
        boolean delayedUpdate;
        boolean delayedMultilineUpdate;
        int delayedUpdateStart;
        int delayedUpdateEnd;

        BufferChangeHandler() {
        }

        public void foldHandlerChanged(Buffer buffer) {
            DisplayManager.this.fvmreset();
            DisplayManager.this.firstLine.callReset = true;
            DisplayManager.this.scrollLineCount.callReset = true;
            int collapseFolds = buffer.getIntegerProperty("collapseFolds", 0);
            if (collapseFolds != 0) {
                DisplayManager.this.expandFolds(collapseFolds);
            }
            DisplayManager.this._notifyScreenLineChanges();
        }

        public void foldLevelChanged(Buffer buffer, int start, int end) {
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this && end != 0 && buffer.isLoaded()) {
                DisplayManager.this.textArea.invalidateLineRange(start - 1, DisplayManager.this.textArea.getLastPhysicalLine());
            }
        }

        public void contentInserted(Buffer buffer, int startLine, int offset, int numLines, int length) {
            if (!buffer.isLoaded()) {
                DisplayManager.this.fvmreset();
                return;
            }
            int endLine = startLine + numLines;
            if (numLines != 0) {
                int start;
                this.delayedMultilineUpdate = true;
                int index = DisplayManager.this.fvmget(startLine);
                int i = start = index + 1;
                while (i < DisplayManager.this.fvmcount) {
                    int[] nArray = DisplayManager.this.fvm;
                    int n = i++;
                    nArray[n] = nArray[n] + numLines;
                }
                DisplayManager.this.lastfvmget = -1;
                DisplayManager.this.fvmdump();
            }
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this) {
                int scrollMode;
                if (numLines != 0) {
                    this.contentInserted(DisplayManager.this.firstLine, startLine, numLines);
                    this.contentInserted(DisplayManager.this.scrollLineCount, startLine, numLines);
                }
                if (this.delayedUpdateEnd >= startLine) {
                    this.delayedUpdateEnd += numLines;
                }
                this.delayedUpdate(startLine, endLine);
                for (int i = 0; i < ((DisplayManager)DisplayManager.this).textArea.selection.size(); ++i) {
                    Selection s = (Selection)((DisplayManager)DisplayManager.this).textArea.selection.elementAt(i);
                    if (!s.contentInserted(buffer, startLine, offset, numLines, length)) continue;
                    this.delayedUpdate(s.startLine, s.endLine);
                }
                int caret = DisplayManager.this.textArea.getCaretPosition();
                if (caret >= offset) {
                    scrollMode = this.caretAutoScroll() ? JEditTextArea.ELECTRIC_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(caret + length, scrollMode);
                } else {
                    scrollMode = this.caretAutoScroll() ? JEditTextArea.NORMAL_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(caret, scrollMode);
                }
            } else {
                DisplayManager.this.firstLine.callReset = true;
                DisplayManager.this.scrollLineCount.callReset = true;
            }
        }

        public void preContentRemoved(Buffer buffer, int startLine, int offset, int numLines, int length) {
            if (!buffer.isLoaded()) {
                return;
            }
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this) {
                if (numLines != 0) {
                    this.preContentRemoved(DisplayManager.this.firstLine, startLine, numLines);
                    this.preContentRemoved(DisplayManager.this.scrollLineCount, startLine, numLines);
                }
                if (this.delayedUpdateEnd >= startLine) {
                    this.delayedUpdateEnd -= numLines;
                }
                this.delayedUpdate(startLine, startLine);
            } else {
                DisplayManager.this.firstLine.callReset = true;
                DisplayManager.this.scrollLineCount.callReset = true;
            }
            if (numLines == 0) {
                return;
            }
            this.delayedMultilineUpdate = true;
            int endLine = startLine + numLines;
            int starti = DisplayManager.this.fvmget(startLine);
            int endi = DisplayManager.this.fvmget(endLine);
            if (Math.abs(starti % 2) == Math.abs(endi % 2)) {
                if (endi - starti == DisplayManager.this.fvmcount) {
                    DisplayManager.this.fvmreset();
                    DisplayManager.this.firstLine.callReset = true;
                    DisplayManager.this.scrollLineCount.callReset = true;
                    starti = 1;
                } else {
                    DisplayManager.this.fvmput(starti + 1, endi + 1, null);
                    ++starti;
                }
            } else if (starti != -1 && DisplayManager.this.fvm[starti] == startLine) {
                if (endi - starti == DisplayManager.this.fvmcount - 1) {
                    DisplayManager.this.fvmreset();
                    DisplayManager.this.firstLine.callReset = true;
                    DisplayManager.this.scrollLineCount.callReset = true;
                    starti = 1;
                } else {
                    DisplayManager.this.fvmput(starti, endi + 1, null);
                }
            } else {
                DisplayManager.this.fvmput(starti + 1, endi, null);
                ((DisplayManager)DisplayManager.this).fvm[starti + 1] = startLine;
                starti += 2;
            }
            int i = starti;
            while (i < DisplayManager.this.fvmcount) {
                int[] nArray = DisplayManager.this.fvm;
                int n = i++;
                nArray[n] = nArray[n] - numLines;
            }
            if (DisplayManager.this.firstLine.physicalLine <= DisplayManager.this.getLastVisibleLine() && DisplayManager.this.firstLine.physicalLine >= DisplayManager.this.getFirstVisibleLine() && !DisplayManager.this.isLineVisible(DisplayManager.this.firstLine.physicalLine)) {
                DisplayManager.this.firstLine.physicalLine = DisplayManager.this.getNextVisibleLine(DisplayManager.this.firstLine.physicalLine);
            }
            DisplayManager.this.lastfvmget = -1;
            DisplayManager.this.fvmdump();
        }

        public void contentRemoved(Buffer buffer, int startLine, int start, int numLines, int length) {
            if (!buffer.isLoaded()) {
                return;
            }
            if (DisplayManager.this.textArea.getDisplayManager() == DisplayManager.this) {
                for (int i = 0; i < ((DisplayManager)DisplayManager.this).textArea.selection.size(); ++i) {
                    Selection s = (Selection)((DisplayManager)DisplayManager.this).textArea.selection.elementAt(i);
                    if (!s.contentRemoved(buffer, startLine, start, numLines, length)) continue;
                    this.delayedUpdate(s.startLine, s.endLine);
                    if (s.start != s.end) continue;
                    ((DisplayManager)DisplayManager.this).textArea.selection.removeElementAt(i);
                    --i;
                }
                int caret = DisplayManager.this.textArea.getCaretPosition();
                if (caret >= start + length) {
                    int scrollMode = this.caretAutoScroll() ? JEditTextArea.ELECTRIC_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(caret - length, scrollMode);
                } else if (caret >= start) {
                    int scrollMode = this.caretAutoScroll() ? JEditTextArea.ELECTRIC_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(start, scrollMode);
                } else {
                    int scrollMode = this.caretAutoScroll() ? JEditTextArea.NORMAL_SCROLL : JEditTextArea.NO_SCROLL;
                    DisplayManager.this.textArea.moveCaretPosition(caret, scrollMode);
                }
            }
        }

        public void transactionComplete(Buffer buffer) {
            if (DisplayManager.this.textArea.getDisplayManager() != DisplayManager.this) {
                this.delayedUpdate = false;
                return;
            }
            if (this.delayedUpdate) {
                this.doDelayedUpdate();
            }
            DisplayManager.this.textArea._finishCaretUpdate();
            this.delayedUpdate = false;
        }

        private void doDelayedUpdate() {
            int _firstLine = DisplayManager.this.textArea.getFirstPhysicalLine();
            int _lastLine = DisplayManager.this.textArea.getLastPhysicalLine();
            int line = this.delayedUpdateStart;
            if (!DisplayManager.this.isLineVisible(line)) {
                line = DisplayManager.this.getNextVisibleLine(line);
            }
            while (line != -1 && line <= this.delayedUpdateEnd) {
                if (line < _firstLine || line > _lastLine) {
                    DisplayManager.this.getScreenLineCount(line);
                }
                line = DisplayManager.this.getNextVisibleLine(line);
            }
            DisplayManager.this._notifyScreenLineChanges();
            if (this.delayedMultilineUpdate) {
                DisplayManager.this.textArea.invalidateScreenLineRange(((DisplayManager)DisplayManager.this).textArea.chunkCache.getScreenLineOfOffset(this.delayedUpdateStart, 0), DisplayManager.this.textArea.getVisibleLines());
                this.delayedMultilineUpdate = false;
            } else {
                DisplayManager.this.textArea.invalidateLineRange(this.delayedUpdateStart, this.delayedUpdateEnd);
            }
            int visibleLines = DisplayManager.this.textArea.getVisibleLines();
            if (visibleLines != 0) {
                ((DisplayManager)DisplayManager.this).textArea.chunkCache.getLineInfo(visibleLines - 1);
            }
            DisplayManager.this.buffer.getFoldLevel(this.delayedUpdateEnd);
        }

        private void contentInserted(Anchor anchor, int startLine, int numLines) {
            if (anchor.physicalLine >= startLine) {
                if (anchor.physicalLine != startLine) {
                    anchor.physicalLine += numLines;
                }
                anchor.callChanged = true;
            }
        }

        private void preContentRemoved(Anchor anchor, int startLine, int numLines) {
            if (anchor.physicalLine >= startLine) {
                if (anchor.physicalLine == startLine) {
                    anchor.callChanged = true;
                } else {
                    int end = Math.min(startLine + numLines, anchor.physicalLine);
                    for (int i = startLine; i < end; ++i) {
                        if (!DisplayManager.this.isLineVisible(i)) continue;
                        anchor.scrollLine -= DisplayManager.this.lineMgr.getScreenLineCount(i);
                    }
                    anchor.physicalLine -= end - startLine;
                    anchor.callChanged = true;
                }
            }
        }

        private void delayedUpdate(int startLine, int endLine) {
            ((DisplayManager)DisplayManager.this).textArea.chunkCache.invalidateChunksFromPhys(startLine);
            if (!this.delayedUpdate) {
                this.delayedUpdateStart = startLine;
                this.delayedUpdateEnd = endLine;
                this.delayedUpdate = true;
            } else {
                this.delayedUpdateStart = Math.min(this.delayedUpdateStart, startLine);
                this.delayedUpdateEnd = Math.max(this.delayedUpdateEnd, endLine);
            }
        }

        private boolean caretAutoScroll() {
            View view = DisplayManager.this.textArea.getView();
            return view == jEdit.getActiveView() && view.getTextArea() == DisplayManager.this.textArea;
        }
    }

    class FirstLine
    extends Anchor {
        int skew;

        FirstLine() {
        }

        public void changed() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "changed() before: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.ensurePhysicalLineIsVisible();
            int screenLines = DisplayManager.this.getScreenLineCount(this.physicalLine);
            if (this.skew >= screenLines) {
                this.skew = screenLines - 1;
            }
            if (Debug.SCROLL_VERIFY) {
                System.err.println("SCROLL_VERIFY");
                int verifyScrollLine = 0;
                for (int i = 0; i < DisplayManager.this.buffer.getLineCount(); ++i) {
                    if (!DisplayManager.this.isLineVisible(i)) continue;
                    if (i >= this.physicalLine) break;
                    verifyScrollLine += DisplayManager.this.getScreenLineCount(i);
                }
                if (verifyScrollLine != this.scrollLine) {
                    Exception ex = new Exception(this.scrollLine + ":" + verifyScrollLine);
                    Log.log(9, this, ex);
                    new BeanShellErrorDialog(null, (Throwable)ex);
                }
            }
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "changed() after: " + this.physicalLine + ":" + this.scrollLine);
            }
            if (!DisplayManager.this.scrollLineCount.callChanged && !DisplayManager.this.scrollLineCount.callReset) {
                DisplayManager.this.textArea.updateScrollBars();
                DisplayManager.this.textArea.recalculateLastPhysicalLine();
            }
        }

        public void reset() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "reset()");
            }
            String wrap = DisplayManager.this.buffer.getStringProperty("wrap");
            DisplayManager.this.softWrap = wrap.equals("soft");
            if (((DisplayManager)DisplayManager.this).textArea.maxLineLen <= 0) {
                DisplayManager.this.softWrap = false;
                DisplayManager.this.wrapMargin = 0;
            } else {
                char[] foo = new char[((DisplayManager)DisplayManager.this).textArea.maxLineLen];
                for (int i = 0; i < foo.length; ++i) {
                    foo[i] = 32;
                }
                TextAreaPainter painter = DisplayManager.this.textArea.getPainter();
                DisplayManager.this.wrapMargin = (int)painter.getFont().getStringBounds(foo, 0, foo.length, painter.getFontRenderContext()).getWidth();
            }
            this.scrollLine = 0;
            int i = DisplayManager.this.getFirstVisibleLine();
            while (i < this.physicalLine) {
                this.scrollLine += DisplayManager.this.getScreenLineCount(i);
                int nextLine = DisplayManager.this.getNextVisibleLine(i);
                if (nextLine == -1) break;
                i = nextLine;
            }
            this.physicalLine = i;
            int screenLines = DisplayManager.this.getScreenLineCount(this.physicalLine);
            if (this.skew >= screenLines) {
                this.skew = screenLines - 1;
            }
            DisplayManager.this.textArea.updateScrollBars();
        }

        void physDown(int amount, int screenAmount) {
            int nextPhysicalLine;
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physDown() start: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.skew = 0;
            if (!DisplayManager.this.isLineVisible(this.physicalLine)) {
                int lastVisibleLine = DisplayManager.this.getLastVisibleLine();
                if (this.physicalLine > lastVisibleLine) {
                    this.physicalLine = lastVisibleLine;
                } else {
                    int nextPhysicalLine2 = DisplayManager.this.getNextVisibleLine(this.physicalLine);
                    amount -= nextPhysicalLine2 - this.physicalLine;
                    this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                    this.physicalLine = nextPhysicalLine2;
                }
            }
            while ((nextPhysicalLine = DisplayManager.this.getNextVisibleLine(this.physicalLine)) != -1 && nextPhysicalLine <= this.physicalLine + amount) {
                this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                amount -= nextPhysicalLine - this.physicalLine;
                this.physicalLine = nextPhysicalLine;
            }
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physDown() end: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.callChanged = true;
            if (screenAmount < 0) {
                this.scrollUp(-screenAmount);
            } else if (screenAmount > 0) {
                this.scrollDown(screenAmount);
            }
        }

        void physUp(int amount, int screenAmount) {
            int prevPhysicalLine;
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physUp() start: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.skew = 0;
            if (!DisplayManager.this.isLineVisible(this.physicalLine)) {
                int firstVisibleLine = DisplayManager.this.getFirstVisibleLine();
                if (this.physicalLine < firstVisibleLine) {
                    this.physicalLine = firstVisibleLine;
                } else {
                    int prevPhysicalLine2 = DisplayManager.this.getPrevVisibleLine(this.physicalLine);
                    amount -= this.physicalLine - prevPhysicalLine2;
                }
            }
            while ((prevPhysicalLine = DisplayManager.this.getPrevVisibleLine(this.physicalLine)) != -1 && prevPhysicalLine >= this.physicalLine - amount) {
                amount -= this.physicalLine - prevPhysicalLine;
                this.physicalLine = prevPhysicalLine;
                this.scrollLine -= DisplayManager.this.getScreenLineCount(prevPhysicalLine);
            }
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "physUp() end: " + this.physicalLine + ":" + this.scrollLine);
            }
            this.callChanged = true;
            if (screenAmount < 0) {
                this.scrollUp(-screenAmount);
            } else if (screenAmount > 0) {
                this.scrollDown(screenAmount);
            }
        }

        void scrollDown(int amount) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "scrollDown()");
            }
            this.ensurePhysicalLineIsVisible();
            amount += this.skew;
            this.skew = 0;
            while (amount > 0) {
                int screenLines = DisplayManager.this.getScreenLineCount(this.physicalLine);
                if (amount < screenLines) {
                    this.skew = amount;
                    break;
                }
                int nextLine = DisplayManager.this.getNextVisibleLine(this.physicalLine);
                if (nextLine == -1) break;
                boolean visible = DisplayManager.this.isLineVisible(this.physicalLine);
                this.physicalLine = nextLine;
                if (!visible) continue;
                amount -= screenLines;
                this.scrollLine += screenLines;
            }
            this.callChanged = true;
        }

        void scrollUp(int amount) {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "scrollUp()");
            }
            this.ensurePhysicalLineIsVisible();
            if (amount <= this.skew) {
                this.skew -= amount;
            } else {
                int prevLine;
                amount -= this.skew;
                this.skew = 0;
                while (amount > 0 && (prevLine = DisplayManager.this.getPrevVisibleLine(this.physicalLine)) != -1) {
                    this.physicalLine = prevLine;
                    int screenLines = DisplayManager.this.getScreenLineCount(this.physicalLine);
                    this.scrollLine -= screenLines;
                    if (amount < screenLines) {
                        this.skew = screenLines - amount;
                        break;
                    }
                    amount -= screenLines;
                }
            }
            this.callChanged = true;
        }

        private void ensurePhysicalLineIsVisible() {
            if (!DisplayManager.this.isLineVisible(this.physicalLine)) {
                if (this.physicalLine > DisplayManager.this.getLastVisibleLine()) {
                    this.physicalLine = DisplayManager.this.getLastVisibleLine();
                    this.scrollLine = DisplayManager.this.getScrollLineCount() - 1;
                } else if (this.physicalLine < DisplayManager.this.getFirstVisibleLine()) {
                    this.physicalLine = DisplayManager.this.getFirstVisibleLine();
                    this.scrollLine = 0;
                } else {
                    this.physicalLine = DisplayManager.this.getNextVisibleLine(this.physicalLine);
                    this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                }
            }
        }
    }

    class ScrollLineCount
    extends Anchor {
        ScrollLineCount() {
        }

        public void changed() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "changed()");
            }
            DisplayManager.this.textArea.updateScrollBars();
            DisplayManager.this.textArea.recalculateLastPhysicalLine();
        }

        public void reset() {
            if (Debug.SCROLL_DEBUG) {
                Log.log(1, this, "reset()");
            }
            this.physicalLine = DisplayManager.this.getFirstVisibleLine();
            this.scrollLine = 0;
            while (this.physicalLine != -1) {
                this.scrollLine += DisplayManager.this.getScreenLineCount(this.physicalLine);
                this.physicalLine = DisplayManager.this.getNextVisibleLine(this.physicalLine);
            }
            this.physicalLine = DisplayManager.this.buffer.getLineCount();
            DisplayManager.this.firstLine.ensurePhysicalLineIsVisible();
            DisplayManager.this.textArea.recalculateLastPhysicalLine();
            DisplayManager.this.textArea.updateScrollBars();
        }
    }

    static abstract class Anchor {
        int physicalLine;
        int scrollLine;
        boolean callChanged;
        boolean callReset;

        Anchor() {
        }

        abstract void reset();

        abstract void changed();

        public String toString() {
            return this.getClass().getName() + "[" + this.physicalLine + "," + this.scrollLine + "]";
        }
    }
}

