function [A] = combinatorial_method(f,xd,tol1,max_Num,T_int,OCP)
%Returns a i x 2 matrix A, i=1,...,max_Num, containing a combination of
%external stimuli causing the desired switch up to tolerance tol1. In its
%first column are the numbers of external stimuli belonging to this combination, in its second column are the
%times of duration of application of the corresponding external stimulus
%which is in the same row

found=0;                                                        %Flag, found=1 combination of external stimuli found by get_stimuli causing the desired switch, found=0 no stimuli found
for i=1:max_Num                                                 %Going through all possible length of combinations from length i=1 to i=max_Num
    fprintf('Combinations with %i external stimuli are being tested...\n',i)
    begin_calc=cputime;                                         %Start time for the calculation of all combinations with i external stimuli
    Combis=nchoosek(1:OCP.numControls,i);                       %Making all the combinations of i different controls out of numControls many external stimuli
    B=size(Combis);                                             %B(1,1) number of different combinations, B(1,2)=i lenght of the combination
    for j=1:B(1,1)                                              %Testing if combination j can provide the desired switch
        A=[Combis(j,:)', (0.5*OCP.timeHorizon)*ones(B(1,2),1)]; %Applying each external stimuli for the duration of 0.5*timeHorizon, from t=0 to t=timeHorizon and zeros for the rest of the time
        u=setControls(A,OCP);                                   %Setting the controls as functions over                                      
        x=forward(f,u,OCP);                                     %Calculating the state x corresponding to the external stimuli u
        if(min((abs(x(:,end)-xd(:,end))<tol1)))                 %If the state x has desired values at t=timeHorizon up to tol1, find smallest duration of application still causing the desird switch         
            T=0.5*OCP.timeHorizon;
            Tnew=0.9*T;
            while(abs(T-Tnew)>=T_int)                           %Figuring out a smaller duration than 0.5*timeHorizon of applicataion of external stimuli causing the desired switch up to duration changes more than T_int 
                A=[Combis(j,:)', Tnew*ones(B(1,2),1)];
                u=setControls(A,OCP);
                x=forward(f,u,OCP);
                if(min((abs(x(:,end)-xd(:,end))<tol1)))
                    T=Tnew;
                    Tnew=T*0.9;
                else                                            %If duration is to short to cause the desired switch, return last duration which has still caused to switch
                    A=[Combis(j,:)', T*ones(B(1,2),1)];
                    break;
                end
            end
            found=1;
        end
        if(found==1)                                            %Break inner for loop
            break;
        end
    end
    if(found==1)                                                %Break outer for loop
        break;
    end
    end_calc=cputime;                                           %End time for the calculation of all combinations with i external stimuli
    fprintf('All combinations with %i external stimuli have been tested in %d seconds\n',i,end_calc-begin_calc)
end

if(found==0)                                                    %If no combination has caused the desred switch, return emty matrix []
    fprintf('No combination of external stimuli found causing the desired switch\n')
    A=[];
end


end

