package jimena.analysis;

import java.util.ArrayList;
import java.util.Collections;

import jimena.libs.MathLib;

/**
 * Some basic statistics functions.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public class Statistics {
    /**
     * Return the mean of a list of values.
     * 
     * @param values
     *            The list of values.
     * @return Mean of the list.
     */
    public static double E(ArrayList<Double> values) {
        double sum = 0;
        for (double value : values) {
            sum += value;
        }
        return sum / values.size();
    }

    /**
     * Variance of a list of values.
     * 
     * @param values
     *            The list of values.
     * @return Variance of the list.
     */
    public static double Var(ArrayList<Double> values) {
        double mean = E(values);
        double sum = 0;

        for (double value : values) {
            sum += (value - mean) * (value - mean);
        }

        return sum / values.size();
    }

    /**
     * Copies an array of values into a new list.
     * 
     * @param values
     *            The array of values.
     * @return A list with the values.
     */
    public static ArrayList<Double> asList(double[] values) {
        ArrayList<Double> valuesList = new ArrayList<Double>();
        for (double value : values) {
            valuesList.add(value);
        }
        return valuesList;
    }

    /**
     * Calculates the Gini coefficient of an array of values.
     * 
     * @param values
     *            The array of values.
     * @return Gini coefficient of the array
     */
    public static double gini(double[] values) {
        return gini(asList(values));
    }

    /**
     * Calculates the Gini coefficient of a list of values.
     * 
     * @param values
     *            The list of values.
     * @return Gini coefficient of the list
     */
    public static double gini(ArrayList<Double> values) {
        ArrayList<Double> summed = new ArrayList<Double>(values);
        Collections.sort(summed);

        double sum = 0;

        for (int i = 1; i <= summed.size(); i++) {
            sum += summed.get(i - 1) * (2 * i - summed.size() - 1);
        }

        return sum / summed.size() / summed.size() / MathLib.mean(summed);
    }
}
