package jimena.binarybf.treebf;

import java.util.LinkedList;

import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

/**
 * Represents an constant node in a tree representing a binary function.
 * 
 * The node always returns true (1) or false (0)
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class ConstantNode extends TreeNode {
    private static final long serialVersionUID = 8937440249240667194L;
    private boolean value;

    /**
     * Creates a constant node.
     * 
     * @param value
     *            Value of node
     */
    public ConstantNode(boolean value) {
        this.value = value;
    }

    @Override
    public double interpolateBooleCube(double[] inputs) {
        return value ? 1 : 0;
    }

    @Override
    public boolean eval(boolean[] inputs) {
        return value;
    }

    @Override
    public int getMinArity() {
        return 0;
    }

    @Override
    protected boolean isCyclic(LinkedList<TreeNode> predecessors) {
        return false;
    }

    @Override
    public ConstantNode clone() {
        return new ConstantNode(value);
    }

    @Override
    protected BDD createBDD(BDD[] inputs, BDDFactory bddFactory) {
        return value ? bddFactory.one() : bddFactory.zero();
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @Override
    public void disableConnection(int position) {
        // Do nothing
    }

    @Override
    public String getFunctionString(String[] nodeNames, boolean odefyCompatible) {
        return odefyCompatible?(value?"1":"0"):String.valueOf(value);
        
    }
}
