package jimena.binaryrn;

/**
 * An interface for objects which need to listen to changes in a regulatory network.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public interface RegulatoryNetworkObserver {
    /**
     * Notifies the observer that a change in the given network has taken place. This includes for example the removal of nodes etc.
     */
    public void notifyNetworkChanged();
    
    /**
     * Notifies the observer that the values of the network have changed.
     */
    public void notifyValuesChanged();
}
