package jimena.binaryrn;

import java.awt.geom.Rectangle2D;

/**
 * Represents a graph node during the creation of the network.
 * 
 * All methods are UNCHECKED. This class is a mere data structure without any functionality.
 */
public class TempNode {
    private String label;
    private String id;
    private Rectangle2D.Double rectangle;
    private boolean isRealNode;
    private double initialValue;

    /**
     * Creates a new temporary node.
     * 
     * @param label
     *            Label of the node
     * @param id
     *            ID of the node in the xml file
     * @param rectangle
     *            Rectangle of the node
     * @param isRealNode
     *            True, if it's a real node and not a logic gate
     * @param initialValue
     *            Initial value of the node
     */
    public TempNode(String label, String id, Rectangle2D.Double rectangle, boolean isRealNode, double initialValue) {
        this.label = label;
        this.id = id;
        this.rectangle = rectangle;
        this.isRealNode = isRealNode;
        this.initialValue = initialValue;
    }

    /**
     * Returns the label of the temporary node.
     * 
     * @return The label
     */
    public String getLabel() {
        return label;
    }

    /**
     * Returns the id of the temporary node.
     * 
     * @return The id
     */
    public String getID() {
        return id;
    }

    /**
     * Returns the position of the temporary node.
     * 
     * @return The label
     */
    public Rectangle2D.Double getRectangle() {
        return rectangle;
    }

    /**
     * Returns whether the node is a real not and not a logic gate.
     * 
     * @return True, if it's a real node
     */
    public boolean isRealNode() {
        return isRealNode;
    }

    @Override
    public String toString() {
        return label;
    }

    /**
     * Returns the initial value of the node.
     * 
     * @return the initialValue
     */
    public double getInitialValue() {
        return initialValue;
    }

    /**
     * Sets the initial value of the node.
     * 
     * @param initialValue
     *            The initial value of the node.
     */
    public void setInitialValue(double initialValue) {
        this.initialValue = initialValue;
    }
}