package jimena.calculationparameters;

import jimena.simulationmethods.SimulationMethod;

/**
 * A set of standard stable state search parameters.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class StandardConvergenceParameters extends ConvergenceParameters {

    /**
     * Creates a new set of standard stable state search parameters.
     * 
     * @param method
     *            The method to use for the simulation.
     * @param dt
     *            The time step to use for the simulation.
     */
    public StandardConvergenceParameters(SimulationMethod method, double dt) {
        super(method, dt, 150, null, 1E-6, 2, Runtime.getRuntime().availableProcessors(), 1E-4);
        // TODO Auto-generated constructor stub
    }

}
