package jimena.gui.charts;


import java.awt.Dimension;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;

/**
 * A list to choose the nodes that are to be displayed in the charts window.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class NodeList extends JList<NetworkNode> implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = -901705554970335446L;
    private RegulatoryNetwork network;

    /**
     * Creates a new node list.
     * 
     * @param network
     *            The network whose nodes are to be displayed
     */
    public NodeList(RegulatoryNetwork network) {
        super();

        this.network = network;
        network.addObserver(this);
        reloadList();

        addListSelectionListener(new ListSelectionListener() {
            @Override
            public void valueChanged(ListSelectionEvent e) {
                NodeList.this.network.notifyObserversOfChangedValues();
            }
        });
    }

    private void reloadList() {
        setListData(network.getNetworkNodes());
        revalidate();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension((int) Math.max(120, getPreferredSize().getWidth()), (int) getPreferredSize().getHeight());
    }

    /**
     * Returns the nodes selected in the list.
     * 
     * @return An array of the nodes selected in the list.
     */
    public NetworkNode[] getSelectedNodes() {
        NetworkNode[] selectedNodes = new NetworkNode[getSelectedValuesList().size()];

        for (int i = 0; i < getSelectedValuesList().size(); i++) {
            selectedNodes[i] = (NetworkNode) getSelectedValuesList().get(i);
        }

        return selectedNodes;
    }

    @Override
    public void notifyNetworkChanged() {
        reloadList();
    }

    @Override
    public void notifyValuesChanged() {
        // Do nothing
    }

    /**
     * Returns the network of this node list.
     * 
     * @return Network
     */
    public RegulatoryNetwork getNetwork() {
        return network;
    }
}
