package jimena.gui.guilib;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;

import javax.swing.JTextField;

/**
 * A text field that selects all of its text as soon as it's focussed.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class AutoselectingTextField extends JTextField {
    private static final long serialVersionUID = 2238638802185826106L;

    /**
     * Performs calls common to all autoselecting text fields.
     */
    public AutoselectingTextField() {
        addFocusListener(new FocusAdapter() {
            @Override
            public void focusGained(FocusEvent arg0) {
                AutoselectingTextField.this.selectAll();
            }
        });
    }
}
