package jimena.gui.guilib.datatable;


import java.io.File;

import javax.swing.ImageIcon;

import jimena.binaryrn.RegulatoryNetwork;

/**
 * A JFrame that displays information about the connections of the nodes and their parameters.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public class ConnectionsTable extends TableJFrame {
    private static final long serialVersionUID = -6512233325428879911L;

    /**
     * Creates a new ConnectionsTable window.
     * 
     * @param network The network whose connections are to be displayed.
     */
    public ConnectionsTable(RegulatoryNetwork network){
        // Check of the network done by the network model
        super(new TableModelConnections(network), "Connections Table", new ImageIcon("images" + File.separator + "table16.png").getImage());
    }
}
