package jimena.gui.guilib.datatable;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

import jimena.gui.guilib.AutoselectingTable;

/**
 * Implements a JFrame that consists of a single table. The window adapts its size to the displayed data.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class TableJFrame extends JFrame  {
    private static final long serialVersionUID = 4270837247107232398L;
    private JTable table;

    /**
     * Creates a new table JFrame.
     * 
     * @param model
     *            Table model of the table.
     * @param title
     *            The title of the window.
     * @param icon
     *            Icon of the window
     */
    public TableJFrame(NetworkTableModel model, String title, Image icon) {
        super(title);
        setIconImage(icon);

        if (model == null || title == null) {
            throw new NullPointerException();
        }

        getContentPane().setLayout(new BorderLayout());

        JTable table = new AutoselectingTable(model) {
            private static final long serialVersionUID = -2420578218907845991L;

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                pack();
            }
        };
        this.table = table;

        table.getTableHeader().setReorderingAllowed(false);

        setContentPane(new JScrollPane(table){
            private static final long serialVersionUID = 3440292986354206149L;

            @Override
            public Dimension getPreferredSize(){
                // Prevent the JFrame from being resized when the user clicks on the the table.
                return this.getSize();
            }
        });
        setMinimumSize(new Dimension(500,150));

        pack();

        setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
    }

    /**
     * Returns the table underlying this JFrame.
     * 
     * @return The table
     */
    public JTable getTable() {
        return table;
    }
}
