package jimena.gui.main;

/**
 * An interface for object which can activate a node of the network in some way.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public interface HasActivatableNodes {
    /**
     * Activates the node with the given index in the object.
     * 
     * @param nodeIndex
     *            Index of the node to activate
     */
    public void activateNode(int nodeIndex);
}
