package jimena.gui.main;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * A custom Executor service for Jimena.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public class JimenaExecutor extends ThreadPoolExecutor {
    RuntimeException error = null;

    /**
     * Returns the last error thrown by the thread.
     * 
     * @return The last error or null.
     */
    public RuntimeException getError() {
        return error;
    }

    /**
     * Creates a new Executor service.
     * 
     * @param threads
     *            Number of available threads of the thread pool.
     */
    public JimenaExecutor(int threads) {
        super(threads, threads, 10, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t != null && t instanceof RuntimeException) {
            error = ((RuntimeException) t);
        }
    }

    @Override
    public void terminated() {
        super.terminated();
        // Nothing at this point.
    }
}
