package jimena.gui.main;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jimena.solver.Node;

public class Test {

	public Test() throws IOException {
		String networkS = null;
		String ls = null;

		BufferedReader br = null;
		br = new BufferedReader(new FileReader("/home/binf027/jimena2/mischnik_network.graphml"));
		String networkS1 = null;
		String ls1;
		Integer target = null;
		Integer source = null;
		Integer nodeId = null;
		String nodeLabel = null;
		float alpha = 1;
		float beta = 10;
		float gamma = 1;
		float h = 10;
		float timeInterval = 0.1f;
		float timeHorizon = 20;
		float alphaM = 0.1f;

		HashMap<String, Integer> ctlP = new HashMap<String, Integer>();
		ctlP.put("GPVI", 1);
		ctlP.put("ATP", 2);
		ctlP.put("PTGDR", 3);
		HashMap<String, Integer> ctlN = new HashMap<String, Integer>();
		ctlN.put("GPVI", 1);
		ctlN.put("ATP", 2);
		ctlN.put("PTGDR", 3);

		HashMap<Integer, Node> nodeMap = new HashMap<Integer, Node>();

		BufferedReader br2 = new BufferedReader(new FileReader("/home/binf027/martin/init.txt"));
		String lr2 = null;
		int ln = 0;
		String[] colName = null, initValue = null, targetValue = null;
		HashMap initState = new HashMap();
		HashMap targetState = new HashMap();
		while ((lr2 = br2.readLine()) != null) {
			ln++;
			if (ln == 1) { // head line
				colName = lr2.split("\\t");
			} else if (ln == 2) {
				initValue = lr2.split("\\t");
				for (int i = 0; i < colName.length; i++) {
					initState.put(colName[i], initValue[i]);
				}
			} else if (ln == 3) {
				targetValue = lr2.split("\\t");
				for (int i = 0; i < colName.length; i++) {
					targetState.put(colName[i], targetValue[i]);
				}
			}
		}
		br2.close();

		while ((ls1 = br.readLine()) != null) {
			networkS1 += ls1 + "\n";

			Matcher m1 = Pattern.compile("<node\\sid=\\\"n(\\d+)\\\">").matcher(ls1);
			if (m1.find()) {
				// System.out.println("Found node_id: " + m1.group(1));
				nodeId = Integer.parseInt(m1.group(1)) + 1; // +1, start from 1 not 0
			} else {
				// System.out.println("Found node_id: " + nodeId);
				Matcher m2 = Pattern.compile("\\s*<y:NodeLabel.+?>(.+)?<y:LabelModel>").matcher(ls1);
				if (m2.find()) {
					System.out.println("Found node_Label: " + m2.group(1) + " node_id: " + nodeId);
					nodeLabel = m2.group(1);
					nodeMap.put(nodeId, new Node(nodeId, nodeLabel));

				} else {
					Matcher m3 = Pattern.compile("<edge\\sid=\"e(\\d+)\"\\ssource=\"n(\\d+?)\"\\starget=\"n(\\d+?)\">")
							.matcher(ls1);
					if (m3.find()) {
						source = Integer.parseInt(m3.group(2)) + 1;
						target = Integer.parseInt(m3.group(3)) + 1;
					} else {
						Matcher m4 = Pattern.compile("<y:Arrows\\ssource=\"\\w+?\"\\starget=\"(\\w+?)\"\\/>")
								.matcher(ls1);
						if (m4.find()) {
							// System.out.println(m4.group(1)+ "\tsource: " + source + "\t target:
							// "+target);
							if (m4.group(1).equals("standard")) {
								// act
								nodeMap.get(target).addActBy(source);
							} else if (m4.group(1).equals("t_shape")) {
								// inh
								nodeMap.get(target).addInhBy(source);
							}
						}
					}
				}
			}
		} // while ls
		br.close();

		String content = "";
		for (Integer i : nodeMap.keySet()) {
			String output_j = "";
			System.out.println("Node " + i + " : " + nodeMap.get(i).getName());
			String nodeX = "x(" + i + ")";
			String omega = "";
			if (nodeMap.get(i).getActBy().size() > 0) {
				float alphasum = 0;
				String actsum = "";
				boolean alreadyinput = false;

				for (Integer j : nodeMap.get(i).getActBy()) {
					System.out.println("\tActivated by " + j + ":" + nodeMap.get(j).getName());
					alphasum += alpha;
					if (alreadyinput)
						actsum += '+';
					actsum += (alpha == 1 ? "" : Float.toString(alpha) + "*") + "x(" + Integer.toString(j) + ")";
					alreadyinput = true;
				}
				omega = "(" + Float.toString(1 + alphasum) + "/" + Float.toString(alphasum) + ")*((" + actsum + ")/(1+"
						+ actsum + "))";
			}

			if (nodeMap.get(i).getInhBy().size() > 0) {
				boolean alreadyinput = false;
				float betasum = 0;
				String inhsum = "";
				for (Integer j : nodeMap.get(i).getInhBy()) {
					System.out.println("\tInhed by " + j + ":" + nodeMap.get(j).getName());

					betasum += beta;
					if (alreadyinput)
						inhsum += '+';
					inhsum += (beta == 1 ? "" : Float.toString(beta) + "*") + "x(" + Integer.toString(j) + ")";
					alreadyinput = true;
				}
				if (!omega.isEmpty()) {
					omega += "*";
				}
				omega = "(" + Float.toString(1 + betasum) + "/" + Float.toString(betasum) + ")*((" + inhsum + ")/(1+"
						+ inhsum + "))";
			}

			if (nodeMap.get(i).getActBy().size() > 0 || nodeMap.get(i).getInhBy().size() > 0) {
				output_j += "@(x,u)((-exp(" + (0.5 * h) + ")+exp(-" + h + "*((" + omega + ")-0.5)))/((1-exp("
						+ (0.5 * h) + "))*(1+exp(-" + h + "*((" + omega + ")-0.5)))))-"
						+ (gamma == 1 ? nodeX : gamma + "*" + nodeX);
				;
				// output_j .=
				// "@(x,u)((-exp(".0.5*$h.")+exp(-$h*(($omega)-0.5)))/((1-exp(".0.5*$h."))*(1+exp(-$h*(($omega)-0.5)))))-$gamma*$nodeX";
			} else {
				output_j += "@(x,u)-" + gamma + "*" + nodeX; // $output_j .="@(x,u)-$gamma*$nodeX";
			}

			if (ctlP.containsKey(nodeMap.get(i).getName())) {
				System.out.println("positive Control added for node " + nodeMap.get(i).toString());
				output_j += "+u(" + ((ctlP.get(nodeMap.get(i).getName()) - 1) * 2 + 1) + ")*(1-x(" + i + "))";
				// $output_j .= '+u('.$posContr_h{$nodeList{$nID}}.')*(1-x('.$nID.'))';
			}
			if (ctlN.containsKey(nodeMap.get(i).getName())) {
				System.out.println("negative Control added for node " + nodeMap.get(i).toString());
				output_j += "-u(" + (ctlN.get(nodeMap.get(i).getName()) * 2) + ")*x(" + i + ")";
				// $output_j .= '-u('.$negContr_h{$nodeList{$nID}}.')*x('.$nID.')';
			}

			if (!content.isEmpty())
				content += ",...\n";
			content += output_j;
		} // node

		String targetStateS = "";
		for (Integer i : nodeMap.keySet()) {
			if (!targetStateS.isEmpty())
				targetStateS += ',';
			targetStateS += targetState.get(nodeMap.get(i).getName());
		}

		String initStateS = "";
		for (Integer i : nodeMap.keySet()) {
			if (!initStateS.isEmpty())
				initStateS += ',';
			initStateS += initState.get(nodeMap.get(i).getName());
		}

		
		System.out.println(matlab_header(nodeMap.size(), ctlP.size() + ctlN.size(), timeInterval, timeHorizon, alphaM,
				initStateS,targetStateS));
		System.out.println(matlab_content(content));
		System.out.println(matlab_footer());
		
		BufferedWriter bw=new BufferedWriter(new FileWriter("testm.m"));
		bw.write(matlab_header(nodeMap.size(), ctlP.size() + ctlN.size(), timeInterval, timeHorizon, alphaM,
				initStateS,targetStateS));
		bw.write(matlab_content(content));
		bw.write(matlab_footer());
		bw.close();
		

	}

	public String matlab_header(int numNodes, int numControls, float timeInterval, float timeHorizon, float alphaM,
			String initStateS, String targetStateS) {
		String a = "function [  ] = main()\n" 
				+ "tol1=10^-1;\n"
				+ "tol2=10^-2;\n"
				+ "T_int=10^-1;\n"
				+ "max_Num=4;\n"
				+ "max_iter=1000;\n"
				+ "combi_method=1;\n"
				+ "local_optimization_method=1;\n"
				+ "OCP=struct(\'numNodes\'," + numNodes + ",\'numControls\',"
				+ numControls + ",\'timeInterval\'," + timeInterval + ",\'timeHorizon\'," + timeHorizon + ",\'alpha\',"
				+ alphaM + ",\'initialState\',[" + initStateS + "]);\n\n";
		a += "xd=get_xd([" + targetStateS + "], OCP);\n";
		return a;
	}

	public String matlab_content(String c) {
		String a = "f= {" + c + "};\n";
		return a;
	}

	public String matlab_footer() {
		String a = "";
		BufferedReader br2=null;
		try {
			br2= new BufferedReader(new FileReader("matlabcode_template.txt"));
			String l="";
			while ((l=br2.readLine())!=null) {
				a+=l+"\n";			
			}
		} catch (Exception e) {			
			e.printStackTrace();
		}
		return a;
	}

	public static void main(String[] args) throws IOException {
		try {
			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getMessage(), "Startup failed",
					JOptionPane.OK_OPTION ^ JOptionPane.ERROR_MESSAGE);
			System.exit(0);
		}
		Locale.setDefault(Locale.US);
		new Test();
	}
}