package jimena.libs;

import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.BuDDyFactory;
import net.sf.javabdd.JFactory;

/**
 * Provides the BDD factory.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class BDDLib {
    private static BDDFactory bddFactory = null;
    private static final int BDDPRESETS = 2000000;
    private static boolean forceJava = true;

    /**
     * Forces the library to use the Java implementation of BDD. This might be necessary for large numbers of results which seem to be
     * causing problems in the native buddy.dll.
     */
    public static void forceJavaImplementation() {
        forceJava = true;
    }

    /**
     * Returns the unique BDD Factory of this project.
     * 
     * @return The BDD factory.
     */
    public static BDDFactory getBDDFactory() {
        if (bddFactory == null) {
            if (forceJava) {
                bddFactory = JFactory.init(BDDPRESETS, BDDPRESETS);
            } else {
                try {
                    bddFactory = BuDDyFactory.init(BDDPRESETS, BDDPRESETS);
                } catch (Error e) {
                    System.out.println("buddy.dll could not be loaded, falling back to the java implementation.\n"
                            + "This will result in a ~40% increase in BDD calculation times.");
                    bddFactory = JFactory.init(BDDPRESETS, BDDPRESETS);
                }
            }

            bddFactory.setMaxIncrease(1000000);
        }

        return bddFactory;
    }
}
