package jimena.libs;

import jimena.binaryrn.RegulatoryNetwork;

/**
 * Represents a method which analyzes a network in some way.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public abstract class NetworkAnalyzer {
    /**
     * Analyzes the network.
     * 
     * @param network
     *            The network the analyze.
     */
    public abstract void run(RegulatoryNetwork network);

    /**
     * Analyzes the network.
     * 
     * @param network
     *            The network the analyze.
     * @param description
     *            A description of the network ready to be output by the analyzer.
     */
    public abstract void run(RegulatoryNetwork network, String description);
}
