package jimena.libs;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

/**
 * A file chooser to save to txt files. Also provides static method as a function wrapper around itself.
 * 
 * @author Chunguang Liang, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class OptimizeMatlab extends JFileChooser {
    private static final long serialVersionUID = -7783911168522977256L;

    
    private static FileFilter txtFilter = new FileFilter() {
        @Override
        public boolean accept(File file) {
            return file.getName().matches(".*\\.txt$") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "txt-files (*.txt)";
        }
    };

    /**
     * Creates a new file chooser for a text file as Matlab routine for optimization.
     */
    public OptimizeMatlab() {
        for (FileFilter filter : getChoosableFileFilters()) {
            removeChoosableFileFilter(filter);
        }

        addChoosableFileFilter(txtFilter);
        setDialogTitle("Save to a text-file for optimization in Matlab");
        setDialogType(JFileChooser.SAVE_DIALOG);
    }

    /**
     * Returns the txt file filter used by the file chooser.
     * 
     * @return The file filter
     */
    public static FileFilter getTxtFilter() {
        return txtFilter;
    }

    /**
     * Saves the given string to txt file that may be chosen with a new instance of this file chooser.
     * 
     * @param string
     *            The string to save.
     * @param parent
     *            The parent component of the window
     */
    public static void writeToTextFile(String string, File currentFile, Component parent) {
        JFileChooser filechooser = new TxtFileChooser();

        int returnVal = filechooser.showSaveDialog(parent);

        if (returnVal == JFileChooser.APPROVE_OPTION) {
            try {
                File file = filechooser.getSelectedFile();
                File fileM;
                File fileN;
                if (!TxtFileChooser.getTxtFilter().accept(filechooser.getSelectedFile())) {
                    file = new File(file.toString() + ".txt");
                    fileM=new File(file.toString() + ".txt" +".m");
                    fileN=new File(file.toString() + ".txt" +".net");
                } else {
                	 fileM=new File(file.toString() +".m");
                	 fileN=new File(file.toString() + ".net");
                }
                
                // steady state file
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(string);            
                writer.close();
               
                // network file      
                BufferedWriter writer2 = new BufferedWriter(new FileWriter(fileN));
                
                BufferedReader br = new BufferedReader(new  FileReader(currentFile));
                String networkS = null;
                String ls;
                
                HashMap<String,String> nodeList=new HashMap<String,String>();
                HashMap<String,String> nodeListRev=new HashMap<String,String>();
                HashMap<String,ArrayList> relationAct=new HashMap<String,ArrayList>();
                HashMap<String,ArrayList> relationInh=new HashMap<String,ArrayList>();
                
                while ((ls=br.readLine()) != null) {
                	networkS+=ls+"\n";    
                	String target = null;
                	String source = null;
                                       
                    Matcher m1 = Pattern.compile("<node\\sid=\\\"n(\\d+)\\\">").matcher(ls);
                    if (m1.find()) {
                       System.out.println("Found node_id: " + m1.group(1) );                          
                    } else {
                    	Matcher m2 = Pattern.compile("\\s*<y:NodeLabel.+?>(.+)?<y:LabelModel>").matcher(ls);
                    	if (m2.find()) {
                    		System.out.println("Found node_Label: " + m2.group(1) );
                    		nodeList.put(m2.group(1),m1.group(1));
                    		nodeListRev.put(m2.group(1),m1.group(1));
                    	} else {
                    		Matcher m3 = Pattern.compile("<edge\\sid=\"e(\\d+)\"\\ssource=\"n(\\d+?)\"\\starget=\"n(\\d+?)\">").matcher(ls);
                    		if (m3.find()) {
                    			System.out.println("Found edge_id: " + m3.group(1) + "\tsource: "+m3.group(2)+"\ttarget: "+m3.group(3) );
                    			source=m3.group(2);
                    			target=m3.group(3);
                    		} else {
                    			Matcher m4 = Pattern.compile("<y:Arrows\\ssource=\"\\w+?\"\\starget=\"(\\w+?)\"\\/>").matcher(ls);
                    			if (m4.find()) {
                    				if (m4.group(1).equals("standard")) {
                    					//act
                    					if (!relationAct.containsKey(target)) {relationAct.put(target,new ArrayList<String>()); }
                    					relationAct.get(target).add(source);                    				
                    				
                    				} else if (m4.group(1).equals("t_share")) {
                    					//inh		
                    					if (!relationInh.containsKey(target)) {relationInh.put(target,new ArrayList<String>()); }
                    					relationInh.get(target).add(source);          
                    				}                    			
                    			}
                    		}
                    	} 
                    }                
                   
                } // while ls
                
                for (String a: relationAct.keySet()) {
                	System.out.println(a);
                	
                	System.out.println(a+"<-"+relationAct.get(a));                		
                	
                }
                
                br.close();
                writer2.write(networkS);
                writer2.close();
                
                // Matlab file
                BufferedWriter writer3 = new BufferedWriter(new FileWriter(fileM));
                writer3.write(string);            
                writer3.close();

            } catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Export failed", JOptionPane.OK_OPTION ^ JOptionPane.ERROR_MESSAGE);
            }
            
            
        }
    }
}
