package jimena.libs;

import java.text.NumberFormat;

/**
 * Provides standard number formats for the application.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class StandardNumberFormat {
    /**
     * The standard number format.
     */
    public static NumberFormat NUMBERFORMAT = NumberFormat.getNumberInstance();

    static {
        NUMBERFORMAT.setMaximumFractionDigits(6);
        NUMBERFORMAT.setGroupingUsed(false);
    }

    /**
     * A short fixed length number format.
     */
    public static NumberFormat SHORTFIXEDNUMBERFORMAT = NumberFormat.getNumberInstance();

    static {
        SHORTFIXEDNUMBERFORMAT.setMaximumFractionDigits(4);
        SHORTFIXEDNUMBERFORMAT.setMinimumFractionDigits(4);
        SHORTFIXEDNUMBERFORMAT.setGroupingUsed(false);
    }
}
