package jimena.simulation;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * A calculation controller that outputs information about the calculation on the standard output.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class BasicCalculationController implements CalculationController {
    private long lastStatusMessage = System.currentTimeMillis();
    private static final long statusMessageInterval = 1000;
    private static final NumberFormat percentageFormatter = new DecimalFormat("##0.0#########");
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    /**
     * Creates a new command line calculation controller.
     */
    public BasicCalculationController() {
        Date date = new Date();
        System.out.println("Calculation started at " + dateFormat.format(date) + ".");
    }

    public void setProgress(double progress, int stepsDone) {
        if (System.currentTimeMillis() - lastStatusMessage >= statusMessageInterval) {
            System.out.println("Progress: " + percentageFormatter.format(progress * 100) + "%, steps done: " + stepsDone);
            lastStatusMessage = System.currentTimeMillis();
        }
    }

    @Override
    public boolean isOn() {
        return true;
    }

    @Override
    public void notifyCalculationFinished() {
        Date date = new Date();
        System.out.println("Calculation finished at " + dateFormat.format(date));
    }

    @Override
    public void setProgress(int stepsDone, int maxSteps) {
        setProgress(((double) stepsDone) / maxSteps, stepsDone);
    }

}
