package jimena.simulation;

/**
 * The result of a convergence calculation.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class ConvergenceResult {
    /**
     * Creates a new convergence calculation result.
     * 
     * @param result
     *            The vector the network converged to.
     * @param convergingTime
     *            Time it took the network to converge.
     */
    public ConvergenceResult(double[] result, double convergingTime) {
        this.result = result;
        this.convergingTime = convergingTime;
    }

    /**
     * The result of the SSS search.
     */
    protected double[] result = null;

    /**
     * The time it took for the calculation to converge.
     */
    protected double convergingTime = Double.NaN;

    /**
     * Returns the steady stable state.
     * 
     * @return The steady stable state assume by the network or null of the network didn't assume a steady stable state (in time).
     */
    public double[] getResult() {
        return result;
    }

    /**
     * Returns the converging time of the calculation or Double.NaN if the simulation has not ended yet. If the simulation was aborted the
     * last simulated time index is returned.
     * 
     * @return Double.NaN
     */
    public double getConvergingTime() {
        return convergingTime;
    }
}
