package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;

/**
 * Implements the CRBN interpolation method. All new nodes are updated synchronously.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 * 
 */
public class CRBNMethod extends DiscreteSimulationMethod {

    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        double[] result = new double[network.size()];

        for (int i = 0; i < network.size(); i++) {
            NetworkNode node = network.getNetworkNodes()[i];
            BinaryBooleanFunction function = node.getFunction();

            result[i] = function.eval(getBooleanInputs(network, i)) ? 1D : 0D;
        }

        network.setValues(result);
    }

    @Override
    public String toString() {
        return "CRBN";
    }
    
    @Override
    public SimulationMethod clone() {
        return new CRBNMethod();
    }
}
