package jimena.simulationmethods;

import java.util.ArrayList;
import java.util.Collections;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;

/**
 * Implements the DARBN interpolation method. All nodes will be updated in random order, but the order is constant for all steps.
 *
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public class DARBNMethod extends DiscreteSimulationMethod {
    private static ArrayList<Integer> order;

    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        if (order == null || order.size() != network.size()) {
            // Create a random list of the node indexes
            order = new ArrayList<Integer>();
            for (int i = 0; i < network.size(); i++) {
                order.add(i);
            }
            Collections.shuffle(order);
        }

        // Update all nodes in the order given by the random list
        for (int i = 0; i < order.size(); i++) {
            NetworkNode node = network.getNetworkNodes()[order.get(i)];
            BinaryBooleanFunction function = node.getFunction();

            node.setValue(function.eval(getBooleanInputs(network, order.get(i))) ? 1D : 0D);
        }

    }

    @Override
    public String toString() {
        return "DARBN";
    }

    @Override
    public SimulationMethod clone() {
        return new DARBNMethod();
    }
}
