package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;

/**
 * Implements the HillCube interpolation method.
 *
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public class HillCubeMethod extends ContinuousSimulationMethod {

    @Override
    public double getDerivativeValueInternal(RegulatoryNetwork network, int nodeIndex, double[] values) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        double interpol = function.interpolateBooleOrHillCube(getInputs(network, nodeIndex, values), true, false, node.getHillNs(),
                node.getHillKs());
        return (interpol - values[nodeIndex]) / network.getNetworkNodes()[nodeIndex].getOdefyDecay();
    }

    @Override
    public String toString() {
        return "HillCube";
    }

    @Override
    public SimulationMethod clone() {
        return new HillCubeMethod();
    }
}
