package jimena.solver;

import java.util.ArrayList;

public class Node {
	private String name = "NodeRich";
	private Integer id;	
	
	private ArrayList<Integer> inhBy=new ArrayList<Integer>();
	private ArrayList<Integer> actBy=new ArrayList<Integer>();
	private ArrayList<Integer> act=new ArrayList<Integer>();
	private ArrayList<Integer> inh=new ArrayList<Integer>();
	
	public Node() {
	}
	
	public Node(Integer nodeID) {
		this();
		setID(nodeID);		
	}
	public Node(Integer nodeID, String nodeLabel) {		
		this();
		setID(nodeID);
		setName(nodeLabel);
	}
	
	public boolean equals(Node o) {
		if (!(o instanceof Node)) return false;
		if (this.getID()==o.getID()) return true;
		return false;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		if (this.name.equals(name))
			return;
		this.name = name;
	}
	
	public void setID(Integer id) {
		this.id=id;
	}
	
	public Integer getID() {
		return this.id;
	}
	
	public void addInhBy(Integer n) {
		inhBy.add(n);
	}
	
	public void addActBy(Integer n) {
		actBy.add(n);
	}
	
	public ArrayList<Integer> getInhBy() {
		return this.inhBy;
	}
	
	public ArrayList<Integer> getActBy() {
		return this.actBy;
	}	

	public void addAct(Integer n) {
		act.add(n);
	}
	
	public void addInh(Integer n) {
		inh.add(n);
	}
	
	public ArrayList<Integer> getAct() {
		return this.act;		
	}
	
	public ArrayList<Integer> getInh() {
		return this.inh;
	}
	
	public int countEdges() {
		return act.size()+inh.size();
	}
	
	public int countByEdges() {
		return actBy.size()+inhBy.size();
	}
	
	public String toString() {
		return "("+getID()+") "+getName();
	}

}
