package jimena.sssearcher;

import java.util.ArrayList;

/**
 * Stores the result of a SSS search in a continuous model.
 * 
 * @author Stefan Karl, Department of Bioinformatics, University of Würzburg, stefan[dot]karl[at]uni-wuerzburg[dot]de
 *
 */
public class SSSearchResult {
    private ArrayList<double[]> results = new ArrayList<double[]>();
    private ArrayList<Integer> counter = new ArrayList<Integer>();
    
    /**
     * Returns the results of a SSS search.
     * 
     * @return Results of a SSS search.
     */
    public ArrayList<double[]> getResults(){
        return results;
    }
    
    /**
     * Returns information on how many times the SSS found by the algorithm were reached.
     * 
     * @return Information on how many times the SSS found by the algorithm were reached.
     */
    public ArrayList<Integer> getCounter(){
        return counter;
    }
}
